/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.xltdriver;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.xceptance.xlt.engine.xltdriver.HtmlUnitDriver;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.UnhandledAlertException;

public class HtmlUnitAlert
implements Alert {
    HtmlUnitDriver driver;
    private AlertHolder holder_;
    private boolean quitting_;
    private Lock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();
    private WebWindow webWindow_;
    private UnexpectedAlertBehaviour unexpectedAlertBehaviour = UnexpectedAlertBehaviour.DISMISS_AND_NOTIFY;

    HtmlUnitAlert(HtmlUnitDriver driver) {
        this.driver = driver;
        WebClient webClient = driver.getWebClient();
        webClient.setAlertHandler(this::alertHandler);
        webClient.setPromptHandler(this::promptHandler);
        webClient.setConfirmHandler(this::confirmHandler);
        webClient.setOnbeforeunloadHandler(this::onbeforeunloadHandler);
    }

    private void alertHandler(Page page, String message) {
        if (this.quitting_) {
            return;
        }
        this.webWindow_ = page.getEnclosingWindow();
        this.holder_ = new AlertHolder(message);
        this.awaitCondition();
    }

    private boolean confirmHandler(Page page, String message) {
        if (this.quitting_) {
            return false;
        }
        this.webWindow_ = page.getEnclosingWindow();
        AlertHolder localHolder = this.holder_ = new AlertHolder(message);
        this.awaitCondition();
        return localHolder.isAccepted();
    }

    private void awaitCondition() {
        block5: {
            this.lock.lock();
            try {
                if (!this.driver.isProcessAlert()) break block5;
                try {
                    this.condition.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private String promptHandler(Page page, String message, String defaultMessage) {
        if (this.quitting_) {
            return null;
        }
        this.webWindow_ = page.getEnclosingWindow();
        this.holder_ = new PromptHolder(message, defaultMessage);
        PromptHolder localHolder = (PromptHolder)this.holder_;
        this.awaitCondition();
        return localHolder.value;
    }

    private boolean onbeforeunloadHandler(Page page, String returnValue) {
        if (this.quitting_) {
            return true;
        }
        this.webWindow_ = page.getEnclosingWindow();
        AlertHolder localHolder = this.holder_ = new AlertHolder(returnValue);
        this.awaitCondition();
        return localHolder.isAccepted();
    }

    WebWindow getWebWindow() {
        return this.webWindow_;
    }

    public void setAutoAccept(boolean autoAccept) {
        this.quitting_ = autoAccept;
    }

    public void handleBrowserCapabilities(Capabilities capabilities) {
        UnexpectedAlertBehaviour behaviour = (UnexpectedAlertBehaviour)capabilities.getCapability("unexpectedAlertBehaviour");
        if (behaviour != null) {
            this.unexpectedAlertBehaviour = behaviour;
        }
    }

    public void dismiss() {
        this.lock.lock();
        this.condition.signal();
        this.holder_ = null;
        this.lock.unlock();
    }

    public void accept() {
        this.lock.lock();
        this.holder_.accept();
        this.condition.signal();
        this.holder_ = null;
        this.lock.unlock();
    }

    public String getText() {
        if (this.holder_ == null) {
            throw new NoAlertPresentException();
        }
        String msg = this.holder_.message;
        msg = msg.replace("\r\n", "\n");
        if (!this.driver.getBrowserVersion().isIE()) {
            msg = msg.replace('\r', '\n');
        }
        return msg;
    }

    public void sendKeys(String keysToSend) {
        this.holder_.sendKeys(keysToSend);
    }

    void close() {
        this.lock.lock();
        this.condition.signal();
        this.setAutoAccept(true);
        this.lock.unlock();
        this.holder_ = null;
    }

    boolean isLocked() {
        return this.holder_ != null;
    }

    public void ensureUnlocked() {
        if (this.isLocked()) {
            String text = this.getText();
            switch (this.unexpectedAlertBehaviour) {
                case ACCEPT: {
                    this.accept();
                    return;
                }
                case ACCEPT_AND_NOTIFY: {
                    this.accept();
                    break;
                }
                case DISMISS: {
                    this.dismiss();
                    return;
                }
                case DISMISS_AND_NOTIFY: {
                    this.dismiss();
                    break;
                }
            }
            throw new UnhandledAlertException("Alert found", text);
        }
    }

    private static class PromptHolder
    extends AlertHolder {
        String defaultMessage;
        String value;

        public PromptHolder(String message, String defaultMessage) {
            super(message);
            this.defaultMessage = defaultMessage;
        }

        @Override
        void sendKeys(String keysToSend) {
            if (keysToSend == null) {
                keysToSend = this.defaultMessage;
            }
            this.value = keysToSend;
        }

        @Override
        void accept() {
            if (this.value == null) {
                this.value = this.defaultMessage;
            }
        }
    }

    private static class AlertHolder {
        String message;
        boolean accepted;

        AlertHolder(String message) {
            this.message = message;
        }

        void sendKeys(String keysToSend) {
            if (keysToSend != null) {
                throw new ElementNotInteractableException("alert is not interactable");
            }
            throw new IllegalArgumentException();
        }

        void accept() {
            this.accepted = true;
        }

        boolean isAccepted() {
            return this.accepted;
        }
    }
}

