/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.xltdriver;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowEvent;
import com.gargoylesoftware.htmlunit.WebWindowListener;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.xceptance.xlt.engine.xltdriver.HtmlUnitDriver;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;

public class HtmlUnitWindow
implements WebDriver.Window {
    private final int SCROLLBAR_WIDTH = 8;
    private final int HEADER_HEIGHT = 150;
    private final HtmlUnitDriver driver;
    private final Dimension initialWindowDimension;
    private Point windowPosition = this.getBasePoint();

    public HtmlUnitWindow(HtmlUnitDriver driver) {
        this.driver = driver;
        this.initialWindowDimension = new Dimension(driver.getCurrentWindow().getOuterWidth(), driver.getCurrentWindow().getOuterHeight());
        this.initWindow();
    }

    private void initWindow() {
        this.getWebClient().addWebWindowListener(new WebWindowListener(){

            @Override
            public void webWindowOpened(WebWindowEvent webWindowEvent) {
            }

            @Override
            public void webWindowContentChanged(WebWindowEvent event) {
                HtmlUnitWindow.this.driver.getElementsMap().remove(event.getOldPage());
                WebWindow current = HtmlUnitWindow.this.driver.getCurrentWindow();
                if (current == event.getWebWindow()) {
                    HtmlUnitWindow.this.switchToDefaultContentOfWindow(current);
                }
            }

            @Override
            public void webWindowClosed(WebWindowEvent event) {
                HtmlUnitWindow.this.driver.getElementsMap().remove(event.getOldPage());
                WebWindow current = HtmlUnitWindow.this.getWebClient().getCurrentWindow();
                do {
                    if (current != event.getWebWindow()) continue;
                    HtmlUnitWindow.this.getWebClient().setCurrentWindow(current.getTopWindow());
                    return;
                } while ((current = current.getParentWindow()) != HtmlUnitWindow.this.getWebClient().getCurrentWindow().getTopWindow());
            }
        });
    }

    private WebClient getWebClient() {
        return this.driver.getWebClient();
    }

    public void setSize(Dimension targetSize) {
        WebWindow topWindow = this.driver.getCurrentWindow().getTopWindow();
        int width = targetSize.getWidth();
        if (width < 8) {
            width = 8;
        }
        topWindow.setOuterWidth(width);
        topWindow.setInnerWidth(width - 8);
        int height = targetSize.getHeight();
        if (height < 150) {
            height = 150;
        }
        topWindow.setOuterHeight(height);
        topWindow.setInnerHeight(height - 150);
    }

    public void setPosition(Point targetPosition) {
        this.windowPosition = targetPosition;
    }

    public Dimension getSize() {
        WebWindow topWindow = this.driver.getCurrentWindow().getTopWindow();
        return new Dimension(topWindow.getOuterWidth(), topWindow.getOuterHeight());
    }

    public Point getPosition() {
        return this.windowPosition;
    }

    public void maximize() {
        this.setSize(this.initialWindowDimension);
        this.setPosition(this.getBasePoint());
    }

    public void minimize() {
        throw new UnsupportedOperationException("Cannot minimize window");
    }

    public void fullscreen() {
        this.maximize();
    }

    public Page lastPage() {
        return this.driver.getCurrentWindow().getEnclosedPage();
    }

    protected void switchToDefaultContentOfWindow(WebWindow window) {
        Page page = window.getEnclosedPage();
        if (page instanceof HtmlPage) {
            this.driver.setCurrentWindow(window);
        }
    }

    private Point getBasePoint() {
        return new Point(0, 0);
    }
}

