/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.common.lang.ThreadUtils;
import com.xceptance.common.util.ConsoleUiUtils;
import com.xceptance.xlt.agentcontroller.TestResultAmount;
import com.xceptance.xlt.mastercontroller.BasicConsoleUI;
import com.xceptance.xlt.mastercontroller.MasterController;
import com.xceptance.xlt.mastercontroller.ReportCreationType;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FireAndForgetUI
extends BasicConsoleUI {
    private static final Logger log = LoggerFactory.getLogger(FireAndForgetUI.class);
    private final boolean generateReport;
    private final boolean isSequential;
    private final AtomicBoolean isShutdownHookActive = new AtomicBoolean();
    private final AtomicBoolean isTestAborted = new AtomicBoolean();
    private final boolean noResults;
    private final long initialResponseTimeout;
    private final TestResultAmount testResultAmount;

    public FireAndForgetUI(MasterController masterController, boolean isSequential, boolean generateReport, boolean noResults, long initialResponseTimeout, TestResultAmount resultAmount) {
        super(masterController);
        this.isSequential = isSequential;
        this.generateReport = generateReport && !noResults;
        this.noResults = noResults;
        this.initialResponseTimeout = initialResponseTimeout;
        this.testResultAmount = resultAmount;
    }

    @Override
    public void run() {
        ShutdownHook hook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(hook);
        ConsoleUiUtils.addEofHandler(new ConsoleUiUtils.EofHandler(){

            @Override
            public void onEof() {
                FireAndForgetUI.this.isShutdownHookActive.set(false);
            }
        });
        String cancelMessage = null;
        if (this.checkAlive(this.initialResponseTimeout)) {
            if (!this.isLoadTestRunning()) {
                if (this.uploadAgentFiles()) {
                    if (this.isSequential) {
                        for (String activeTestCaseName : this.masterController.getActiveTestCaseNames()) {
                            this.executeTestCase(activeTestCaseName);
                            if (!this.isTestAborted.get()) continue;
                            break;
                        }
                    } else {
                        this.executeTestCase(null);
                    }
                } else {
                    cancelMessage = "Uploading test suite failed.";
                }
            } else {
                cancelMessage = "There is another load test running.";
            }
        } else {
            cancelMessage = "There are unreachable agent controllers.";
        }
        this.masterController.shutdown();
        if (cancelMessage != null) {
            throw new RuntimeException(cancelMessage);
        }
    }

    protected boolean checkAlive(long timeout) {
        System.out.println("Waiting for agent controllers up to " + timeout / 1000L + "s.");
        long deadline = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < deadline) {
            try {
                this.masterController.checkAlive();
                return true;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {}
            }
        }
        return super.checkAlive();
    }

    private void executeTestCase(String activeTestCaseName) {
        if (!this.startAgents(activeTestCaseName)) {
            this.stopAgents();
            throw new RuntimeException("Starting agents failed.");
        }
        this.isShutdownHookActive.set(true);
        this.printLoadTestSettings();
        System.out.println();
        System.out.println();
        try {
            ThreadUtils.sleep(3000L);
            this.masterController.startAgentStatusList();
            while (this.masterController.isAnyAgentRunning_SAFE()) {
                this.printAgentStatusList();
                ThreadUtils.sleep(this.getStatusListUpdateInterval() * 1000);
            }
            this.printAgentStatusList();
            this.masterController.stopAgentStatusList();
        }
        catch (Exception ex) {
            log.error("Failed to update agent status:", (Throwable)ex);
        }
        if (this.isTestAborted.get()) {
            if (ConsoleUiUtils.confirm("Do you want to download the results of the aborted test run?")) {
                System.out.println();
                this.downloadTestResults(null);
            }
            this.isShutdownHookActive.set(false);
        } else {
            this.isShutdownHookActive.set(false);
            if (this.noResults) {
                log.info("Download of test results has been skipped.");
            } else {
                if (!this.downloadTestResults(this.testResultAmount)) {
                    throw new RuntimeException("Downloading test results failed.");
                }
                if (this.generateReport) {
                    this.generateReport(ReportCreationType.ALL);
                }
            }
        }
    }

    public boolean isSequential() {
        return this.isSequential;
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            if (FireAndForgetUI.this.isShutdownHookActive.get()) {
                FireAndForgetUI.this.isTestAborted.set(true);
                FireAndForgetUI.this.stopAgents();
                while (FireAndForgetUI.this.isShutdownHookActive.get()) {
                    ThreadUtils.sleep(500L);
                }
            }
        }
    }
}

