/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.xlt.agentcontroller.TestResultAmount;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.mastercontroller.BasicConsoleUI;
import com.xceptance.xlt.mastercontroller.MasterController;
import com.xceptance.xlt.mastercontroller.ReportCreationType;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class NonInteractiveUI
extends BasicConsoleUI {
    private final long agentControllerTimeout;
    private final MasterControllerCommands[] commands;
    private final TestResultAmount testResultAmount;

    public NonInteractiveUI(MasterController masterController, String commandList, long agentControllerTimeout, TestResultAmount resultAmount) {
        super(masterController);
        this.commands = MasterControllerCommands.convert(commandList);
        this.agentControllerTimeout = agentControllerTimeout;
        this.testResultAmount = resultAmount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.checkAlive(this.agentControllerTimeout);
            for (MasterControllerCommands command : this.commands) {
                if (command == MasterControllerCommands.upload) {
                    this.upload();
                    continue;
                }
                if (command == MasterControllerCommands.start) {
                    this.start();
                    continue;
                }
                if (command == MasterControllerCommands.abort) {
                    this.abort();
                    continue;
                }
                if (command == MasterControllerCommands.download) {
                    this.download();
                    continue;
                }
                if (command != MasterControllerCommands.report) continue;
                this.report();
            }
        }
        finally {
            this.masterController.shutdown();
        }
    }

    private void checkAlive(long timeout) {
        if (timeout > 0L) {
            System.out.println("Waiting for agent controllers up to " + timeout / 1000L + "s.");
            long deadline = System.currentTimeMillis() + timeout;
            while (System.currentTimeMillis() < deadline) {
                try {
                    this.masterController.checkAlive();
                    return;
                }
                catch (Exception exception) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception2) {}
                }
            }
        }
        if (!this.checkAlive()) {
            throw new XltException("There are unreachable agent controllers.");
        }
    }

    private void upload() {
        if (this.isLoadTestRunning()) {
            throw new XltException("There is another load test running.");
        }
        if (!this.uploadAgentFiles()) {
            throw new XltException("Uploading test suite failed.");
        }
    }

    private void start() {
        if (this.isLoadTestRunning()) {
            throw new XltException("There is another load test running.");
        }
        if (!this.startAgents(null)) {
            throw new XltException("Starting agents failed.");
        }
    }

    private void abort() {
        if (this.isLoadTestRunning() && !this.stopAgents()) {
            throw new XltException("Stopping agents failed.");
        }
    }

    private void download() {
        if (!this.downloadTestResults(this.testResultAmount)) {
            throw new XltException("Downloading test results failed.");
        }
    }

    private void report() {
        if (!this.generateReport(ReportCreationType.ALL)) {
            throw new XltException("Creating test report failed.");
        }
    }

    public static enum MasterControllerCommands {
        upload,
        start,
        abort,
        download,
        report;


        public static MasterControllerCommands[] convert(String commandList) {
            String[] commands = MasterControllerCommands.parse(commandList);
            MasterControllerCommands[] mcCommands = new MasterControllerCommands[commands.length];
            for (int i = 0; i < commands.length; ++i) {
                mcCommands[i] = MasterControllerCommands.valueOf(commands[i]);
            }
            return mcCommands;
        }

        public static String[] validate(String commandList) {
            String[] commands = MasterControllerCommands.parse(commandList);
            ArrayList<String> unknownCommands = new ArrayList<String>();
            for (String command : commands) {
                try {
                    MasterControllerCommands.valueOf(command);
                }
                catch (IllegalArgumentException e) {
                    unknownCommands.add(command);
                }
            }
            return unknownCommands.toArray(new String[unknownCommands.size()]);
        }

        private static String[] parse(String commandList) {
            return StringUtils.split((String)commandList, (String)", ");
        }
    }
}

