/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class XltProxySelector
extends ProxySelector {
    private final ProxySelector defsel;
    private final SocketAddress sa;
    private final Proxy proxy;
    private final Set<BypassHost> bypasses;

    public XltProxySelector(ProxySelector def) {
        int port;
        this.defsel = def;
        String host = System.getProperty("https.proxyHost");
        if (StringUtils.isBlank((CharSequence)host)) {
            throw new IllegalArgumentException("Proxy host must not be NULL or empty.");
        }
        try {
            port = Integer.valueOf(System.getProperty("https.proxyPort", "80").trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Proxy port must be a number.");
        }
        this.sa = new InetSocketAddress(host, port);
        this.proxy = new Proxy(Proxy.Type.HTTP, this.sa);
        this.bypasses = new HashSet<BypassHost>();
        String bypassProp = System.getProperty("https.nonProxyHosts");
        if (!StringUtils.isBlank((CharSequence)bypassProp)) {
            for (String bypass : bypassProp.split("\\|")) {
                this.bypasses.add(new BypassHost(bypass));
            }
        }
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI can't be null.");
        }
        String protocol = uri.getScheme();
        if ("https".equalsIgnoreCase(protocol)) {
            String host = uri.getHost();
            for (BypassHost bypass : this.bypasses) {
                if (!bypass.matches(host)) continue;
                ArrayList<Proxy> l = new ArrayList<Proxy>();
                l.add(Proxy.NO_PROXY);
                return l;
            }
            ArrayList<Proxy> l = new ArrayList<Proxy>();
            l.add(this.proxy);
            return l;
        }
        if (this.defsel != null) {
            return this.defsel.select(uri);
        }
        ArrayList<Proxy> l = new ArrayList<Proxy>();
        l.add(Proxy.NO_PROXY);
        return l;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        if (uri == null || sa == null || ioe == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
        if (!this.sa.equals(sa) && this.defsel != null) {
            this.defsel.connectFailed(uri, sa, ioe);
        }
    }

    class BypassHost {
        private final boolean wcLeft;
        private final boolean wcRight;
        private final String bypassHost;

        public BypassHost(String bypass) {
            if (StringUtils.isBlank((CharSequence)bypass) || bypass.matches("\\*+")) {
                throw new IllegalArgumentException("Bypass host must not be NULL or empty or consist of wildcard only.");
            }
            String tmp = bypass.trim();
            this.wcLeft = tmp.startsWith("*");
            if (this.wcLeft) {
                tmp = tmp.substring(1);
            }
            this.wcRight = tmp.endsWith("*");
            if (this.wcRight) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            this.bypassHost = tmp;
            if (StringUtils.isBlank((CharSequence)this.bypassHost)) {
                throw new IllegalArgumentException("Bypass host must not be NULL or empty or consist of wildcard only.");
            }
        }

        public boolean matches(String host) {
            if (this.wcLeft && this.wcRight) {
                return host.contains(this.bypassHost);
            }
            if (this.wcLeft) {
                return host.endsWith(this.bypassHost);
            }
            if (this.wcRight) {
                return host.startsWith(this.bypassHost);
            }
            return host.equals(this.bypassHost);
        }
    }
}

