/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.common.util.SynchronizingCounter;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.report.LineChunk;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;

public class Dispatcher {
    private final AtomicLong totalDirectoryCount = new AtomicLong();
    private final SynchronizingCounter directoriesToBeProcessed = new SynchronizingCounter();
    private final SynchronizingCounter chunksToBeProcessed;
    private final Semaphore permits;
    private final BlockingQueue<LineChunk> lineChunkQueue;
    private final BlockingQueue<List<Data>> dataRecordChunkQueue;
    private final ProgressBar progressBar = new ProgressBarBuilder().setTaskName("Reading").setStyle(ProgressBarStyle.ASCII).build();

    public Dispatcher(int maxActiveThreads) {
        this.permits = new Semaphore(maxActiveThreads);
        this.chunksToBeProcessed = new SynchronizingCounter();
        this.lineChunkQueue = new ArrayBlockingQueue<LineChunk>(10);
        this.dataRecordChunkQueue = new ArrayBlockingQueue<List<Data>>(10);
    }

    public void addDirectory() {
        this.progressBar.maxHint(this.totalDirectoryCount.incrementAndGet());
        this.directoriesToBeProcessed.increment();
    }

    public void beginReading() throws InterruptedException {
        this.permits.acquire();
    }

    public void addNewLineChunk(LineChunk lineChunk) throws InterruptedException {
        this.chunksToBeProcessed.increment();
        this.permits.release();
        this.lineChunkQueue.put(lineChunk);
        this.permits.acquire();
    }

    public void finishedReading() {
        this.progressBar.step();
        this.directoriesToBeProcessed.decrement();
        this.permits.release();
    }

    public LineChunk getNextLineChunk() throws InterruptedException {
        LineChunk chunk = this.lineChunkQueue.take();
        this.permits.acquire();
        return chunk;
    }

    public void addNewParsedDataRecordChunk(List<Data> dataRecordChunk) throws InterruptedException {
        this.permits.release();
        this.dataRecordChunkQueue.put(dataRecordChunk);
    }

    public List<Data> getNextParsedDataRecordChunk() throws InterruptedException {
        List<Data> chunk = this.dataRecordChunkQueue.take();
        this.permits.acquire();
        return chunk;
    }

    public void finishedProcessing() {
        this.chunksToBeProcessed.decrement();
        this.permits.release();
    }

    public void waitForDataRecordProcessingToComplete() throws InterruptedException {
        this.directoriesToBeProcessed.awaitZero();
        this.chunksToBeProcessed.awaitZero();
        this.progressBar.close();
    }
}

