/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.report.providers.AbstractDataProcessor;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractDataProcessorBasedReportProvider<T extends AbstractDataProcessor>
extends AbstractReportProvider {
    private final Class<T> implClass;
    private final Map<String, T> processors = new HashMap<String, T>();

    protected AbstractDataProcessorBasedReportProvider(Class<T> c) {
        this.implClass = c;
    }

    @Override
    public void processDataRecord(Data stat) {
        T processor = this.getProcessor(stat.getName());
        ((AbstractDataProcessor)processor).processDataRecord(stat);
    }

    protected T getProcessor(String name) {
        AbstractDataProcessor processor = (AbstractDataProcessor)this.processors.get(name);
        if (processor == null) {
            try {
                Constructor<T> constructor = this.implClass.getConstructor(String.class, AbstractReportProvider.class);
                processor = (AbstractDataProcessor)constructor.newInstance(name, this);
            }
            catch (Exception ex) {
                throw new RuntimeException("", ex);
            }
            this.processors.put(name, processor);
        }
        return (T)processor;
    }

    protected Collection<T> getProcessors() {
        return Collections.unmodifiableCollection(new TreeMap<String, T>(this.processors).values());
    }
}

