/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.EventData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.api.report.ReportProviderConfiguration;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.providers.EventMessageInfo;
import com.xceptance.xlt.report.providers.EventReport;
import com.xceptance.xlt.report.providers.EventsReport;
import com.xceptance.xlt.report.util.JFreeChartUtils;
import com.xceptance.xlt.report.util.TaskManager;
import com.xceptance.xlt.report.util.ValueSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class EventsReportProvider
extends AbstractReportProvider {
    private final ValueSet eventsPerSecondValueSet = new ValueSet();
    private final Map<String, EventReport> eventReports = new HashMap<String, EventReport>();
    private final Map<EventReport, Map<String, EventMessageInfo>> messageInfos = new HashMap<EventReport, Map<String, EventMessageInfo>>();
    private boolean groupEventsByTestCase;

    @Override
    public void setConfiguration(ReportProviderConfiguration config) {
        super.setConfiguration(config);
        this.groupEventsByTestCase = ((ReportGeneratorConfiguration)config).getGroupEventsByTestCase();
    }

    @Override
    public Object createReportFragment() {
        if (this.getConfiguration().shouldChartsGenerated()) {
            TaskManager taskManager = TaskManager.getInstance();
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    int minMaxValueSetSize = EventsReportProvider.this.getConfiguration().getChartWidth();
                    TimeSeries eventsPerSecondTimeSeries = JFreeChartUtils.toStandardTimeSeries(EventsReportProvider.this.eventsPerSecondValueSet.toMinMaxValueSet(minMaxValueSetSize), "Events/s");
                    EventsReportProvider.this.createEventChart(eventsPerSecondTimeSeries);
                }
            });
        }
        EventsReport eventsReport = new EventsReport();
        for (EventReport eventReport : this.eventReports.values()) {
            Map<String, EventMessageInfo> messageInfosPerEvent = this.messageInfos.get(eventReport);
            for (EventMessageInfo messageInfo : messageInfosPerEvent.values()) {
                eventReport.messages.add(messageInfo);
            }
        }
        eventsReport.events = new ArrayList<EventReport>(this.eventReports.values());
        return eventsReport;
    }

    @Override
    public void processDataRecord(Data stat) {
        if (stat instanceof EventData) {
            EventData eventStat = (EventData)stat;
            this.eventsPerSecondValueSet.addOrUpdateValue(eventStat.getTime(), 1);
            String eventKey = this.groupEventsByTestCase ? eventStat.getName() + "-" + eventStat.getTestCaseName() : eventStat.getName();
            EventReport eventReport = this.eventReports.get(eventKey);
            if (eventReport == null) {
                eventReport = new EventReport();
                eventReport.name = eventStat.getName();
                eventReport.testCaseName = this.groupEventsByTestCase ? eventStat.getTestCaseName() : "(ignored)";
                eventReport.totalCount = 1;
                this.eventReports.put(eventKey, eventReport);
                this.messageInfos.put(eventReport, new HashMap());
            } else {
                ++eventReport.totalCount;
            }
            Map<String, EventMessageInfo> messageInfosPerEvent = this.messageInfos.get(eventReport);
            EventMessageInfo messageInfo = messageInfosPerEvent.get(eventStat.getMessage());
            if (messageInfo == null) {
                messageInfo = new EventMessageInfo();
                messageInfo.info = eventStat.getMessage();
                messageInfo.count = 1;
                messageInfosPerEvent.put(eventStat.getMessage(), messageInfo);
            } else {
                ++messageInfo.count;
            }
        }
    }

    private void createEventChart(TimeSeries eventsPerSecondTimeSeries) {
        TimeSeriesCollection events = new TimeSeriesCollection(eventsPerSecondTimeSeries);
        ReportProviderConfiguration config = this.getConfiguration();
        JFreeChart chart = JFreeChartUtils.createBarChart("Events", (XYDataset)events, "Events", JFreeChartUtils.COLOR_EVENT, config.getChartStartTime(), config.getChartEndTime());
        JFreeChartUtils.saveChart(chart, "Events", config.getChartDirectory(), config.getChartWidth(), config.getChartHeight());
    }
}

