/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.engine.TransactionData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.api.report.ReportProviderConfiguration;
import com.xceptance.xlt.report.providers.GeneralReport;
import com.xceptance.xlt.report.providers.SlowestRequestsTracker;
import com.xceptance.xlt.report.util.ConcurrentUsersTable;
import com.xceptance.xlt.report.util.JFreeChartUtils;
import com.xceptance.xlt.report.util.MinMaxValueSet;
import com.xceptance.xlt.report.util.TaskManager;
import com.xceptance.xlt.report.util.ValueSet;
import java.io.File;
import java.util.Date;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class GeneralReportProvider
extends AbstractReportProvider {
    private final ValueSet bytesReceivedValueSet = new ValueSet();
    private final ValueSet bytesSentValueSet = new ValueSet();
    private final ValueSet requestsValueSet = new ValueSet();
    private long totalBytesReceived = 0L;
    private long totalBytesSent = 0L;
    private long totalRequests = 0L;
    private final ValueSet failedTransactionsValueSet = new ValueSet();
    private final ValueSet totalTransactionsValueSet = new ValueSet();
    private MinMaxValueSet requestRunTimeValueSet;
    private int minMaxValueSetSize;
    private SlowestRequestsTracker slowestRequestsTracker;

    @Override
    public GeneralReport createReportFragment() {
        final ReportProviderConfiguration config = this.getConfiguration();
        final File chartsDir = config.getChartDirectory();
        if (config.shouldChartsGenerated()) {
            TaskManager taskManager = TaskManager.getInstance();
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    JFreeChartUtils.createPlaceholderChart(chartsDir, config.getChartWidth(), config.getChartHeight());
                }
            });
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    MinMaxValueSet bytesReceived = GeneralReportProvider.this.bytesReceivedValueSet.toMinMaxValueSet(GeneralReportProvider.this.minMaxValueSetSize);
                    GeneralReportProvider.this.createChart(JFreeChartUtils.toMinMaxTimeSeries(bytesReceived, "Received Bytes/s"), true, "Received Bytes Per Second", "Bytes", "ReceivedBytesPerSecond", chartsDir);
                }
            });
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    MinMaxValueSet bytesSent = GeneralReportProvider.this.bytesSentValueSet.toMinMaxValueSet(GeneralReportProvider.this.minMaxValueSetSize);
                    GeneralReportProvider.this.createChart(JFreeChartUtils.toMinMaxTimeSeries(bytesSent, "Sent Bytes/s"), true, "Sent Bytes Per Second", "Bytes", "SentBytesPerSecond", chartsDir);
                }
            });
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    MinMaxValueSet requests = GeneralReportProvider.this.requestsValueSet.toMinMaxValueSet(GeneralReportProvider.this.minMaxValueSetSize);
                    GeneralReportProvider.this.createChart(JFreeChartUtils.toMinMaxTimeSeries(requests, "Requests/s"), true, "Requests Per Second", "Requests", "RequestsPerSecond", chartsDir);
                }
            });
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    ValueSet concurrentUsersValueSet = ConcurrentUsersTable.getInstance().getConcurrentUsersValueSet();
                    MinMaxValueSet concurrentUsers = concurrentUsersValueSet.toMinMaxValueSet(GeneralReportProvider.this.minMaxValueSetSize);
                    GeneralReportProvider.this.createChart(JFreeChartUtils.toMinMaxTimeSeries(concurrentUsers, "Concurrent Users"), true, "Concurrent Users", "Users", "ConcurrentUsers", chartsDir);
                }
            });
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    GeneralReportProvider.this.createChart(JFreeChartUtils.toMinMaxTimeSeries(GeneralReportProvider.this.requestRunTimeValueSet, "Request Runtime"), true, "Request Runtime", "Runtime [ms]", "RequestRuntime", chartsDir);
                }
            });
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    MinMaxValueSet failedTransactions = GeneralReportProvider.this.failedTransactionsValueSet.toMinMaxValueSet(GeneralReportProvider.this.minMaxValueSetSize);
                    TimeSeries failedTransactionsTimeSeries = JFreeChartUtils.toStandardTimeSeries(failedTransactions, "Transaction Errors/s");
                    TimeSeries errorRateTimeSeries = JFreeChartUtils.calculateRateTimeSeries(GeneralReportProvider.this.failedTransactionsValueSet, GeneralReportProvider.this.totalTransactionsValueSet, GeneralReportProvider.this.minMaxValueSetSize, "Error Rate");
                    TimeSeries errorRateAverageTimeSeries = JFreeChartUtils.createMovingAverageTimeSeries(errorRateTimeSeries, GeneralReportProvider.this.getConfiguration().getMovingAveragePercentage());
                    GeneralReportProvider.this.createErrorsChart(failedTransactionsTimeSeries, errorRateAverageTimeSeries, "Transaction Errors", "TransactionErrors", chartsDir);
                }
            });
        }
        GeneralReport report = new GeneralReport();
        long testStartTime = config.getChartStartTime();
        long testEndTime = config.getChartEndTime();
        report.startTime = new Date(testStartTime);
        report.endTime = new Date(testEndTime);
        report.duration = Math.round((float)(testEndTime - testStartTime) / 1000.0f);
        report.hits = this.totalRequests;
        report.bytesSent = this.totalBytesSent;
        report.bytesReceived = this.totalBytesReceived;
        if (this.slowestRequestsTracker != null) {
            report.slowestRequests = this.slowestRequestsTracker.getSlowestRequests();
        }
        return report;
    }

    @Override
    public void processDataRecord(Data data) {
        if (data instanceof RequestData) {
            RequestData reqData = (RequestData)data;
            long time = reqData.getTime();
            long endTime = reqData.getEndTime();
            long runTime = reqData.getRunTime();
            long sendCompletedAt = time + (long)reqData.getConnectTime() + (long)reqData.getSendTime();
            this.totalBytesSent += (long)reqData.getBytesSent();
            this.totalBytesReceived += (long)reqData.getBytesReceived();
            this.bytesSentValueSet.addOrUpdateValue(sendCompletedAt, reqData.getBytesSent());
            this.bytesReceivedValueSet.addOrUpdateValue(endTime, reqData.getBytesReceived());
            ++this.totalRequests;
            this.requestsValueSet.addOrUpdateValue(endTime, 1);
            this.requestRunTimeValueSet.addOrUpdateValue(endTime, (int)runTime);
            if (this.slowestRequestsTracker != null) {
                this.slowestRequestsTracker.update(reqData);
            }
        } else if (data instanceof TransactionData) {
            TransactionData txnData = (TransactionData)data;
            long time = txnData.getTime();
            long endTime = txnData.getEndTime();
            ConcurrentUsersTable.getInstance().recordUserActivity(time, endTime, txnData.getName(), txnData.getTestUserNumber());
            this.totalTransactionsValueSet.addOrUpdateValue(endTime, 1);
            if (txnData.hasFailed()) {
                this.failedTransactionsValueSet.addOrUpdateValue(endTime, 1);
            }
        }
    }

    protected void createChart(TimeSeries timeSeries, boolean showMovingAverage, String title, String yAxisTitle, String fileName, File outputDir) {
        ReportProviderConfiguration config = this.getConfiguration();
        JFreeChart chart = JFreeChartUtils.createLineChart(title, yAxisTitle, timeSeries, config.getChartStartTime(), config.getChartEndTime(), showMovingAverage, config.getMovingAveragePercentage());
        JFreeChartUtils.saveChart(chart, fileName, outputDir, config.getChartWidth(), config.getChartHeight());
    }

    protected void createErrorsChart(TimeSeries errorCountTimeSeries, TimeSeries errorRateTimeSeries, String title, String fileName, File outputDir) {
        ReportProviderConfiguration config = this.getConfiguration();
        XYPlot errorCountPlot = JFreeChartUtils.createBarPlot((XYDataset)new TimeSeriesCollection(errorCountTimeSeries), null, "Error Count", JFreeChartUtils.COLOR_ERROR);
        XYPlot errorRatePlot = JFreeChartUtils.createLinePlot((XYDataset)new TimeSeriesCollection(errorRateTimeSeries), null, "Error Rate [%]", new JFreeChartUtils.ColorSet(JFreeChartUtils.COLOR_ERROR, JFreeChartUtils.COLOR_LINE));
        ValueAxis errorRateAxis = errorRatePlot.getRangeAxis();
        errorRateAxis.setLowerBound(0.0);
        double maxRate = errorRateTimeSeries.getMaxY();
        if (0.0 < maxRate && maxRate < 1.0) {
            errorRateAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits());
        }
        CombinedDomainXYPlot combinedPlot = JFreeChartUtils.createCombinedPlot(config.getChartStartTime(), config.getChartEndTime());
        combinedPlot.add(errorCountPlot);
        combinedPlot.add(errorRatePlot);
        JFreeChart chart = JFreeChartUtils.createChart(title, (Plot)combinedPlot);
        JFreeChartUtils.saveChart(chart, fileName, outputDir, config.getChartWidth(), config.getChartHeight());
    }

    @Override
    public void setConfiguration(ReportProviderConfiguration config) {
        super.setConfiguration(config);
        this.minMaxValueSetSize = this.getConfiguration().getChartWidth();
        this.requestRunTimeValueSet = new MinMaxValueSet(this.minMaxValueSetSize);
        if (config.getProperties().getProperty("monitoring.trackSlowestRequests") != null) {
            this.slowestRequestsTracker = new SlowestRequestsTracker(10);
        }
    }
}

