/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.common.util.ParameterCheckUtils;
import java.util.BitSet;

public class LowPrecisionIntValueSet {
    private static int DEFAULT_BUCKET_COUNT = 128;
    private final BitSet bitSet;
    private final int buckets;
    private int scale;

    public static void setDefaultBucketCount(int buckets) {
        ParameterCheckUtils.isNotNegative(buckets, "buckets");
        DEFAULT_BUCKET_COUNT = buckets;
    }

    public LowPrecisionIntValueSet() {
        this(DEFAULT_BUCKET_COUNT);
    }

    public LowPrecisionIntValueSet(int buckets) {
        this.buckets = buckets;
        this.scale = 1;
        this.bitSet = new BitSet(this.buckets);
    }

    public void addValue(int value) {
        if (value < 0) {
            return;
        }
        value /= this.scale;
        while (value >= this.buckets) {
            this.scale();
            value /= 2;
        }
        this.bitSet.set(value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LowPrecisionIntValueSet other = (LowPrecisionIntValueSet)obj;
        if (this.bitSet == null ? other.bitSet != null : !this.bitSet.equals(other.bitSet)) {
            return false;
        }
        if (this.scale != other.scale) {
            return false;
        }
        return this.buckets == other.buckets;
    }

    public double[] getValues() {
        double[] values = new double[this.bitSet.cardinality()];
        int j = this.bitSet.nextSetBit(0);
        for (int i = 0; i < values.length; ++i) {
            values[i] = j * this.scale;
            j = this.bitSet.nextSetBit(j + 1);
        }
        return values;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bitSet == null ? 0 : this.bitSet.hashCode());
        result = 31 * result + this.scale;
        result = 31 * result + this.buckets;
        return result;
    }

    public void merge(LowPrecisionIntValueSet other) {
        if (this.scale != other.scale) {
            int targetScale;
            LowPrecisionIntValueSet toBeScaled;
            if (this.scale < other.scale) {
                toBeScaled = this;
                targetScale = other.scale;
            } else {
                toBeScaled = other;
                targetScale = this.scale;
            }
            while (toBeScaled.scale < targetScale) {
                toBeScaled.scale();
            }
        }
        this.bitSet.or(other.bitSet);
    }

    private void scale() {
        this.scale *= 2;
        for (int i = 0; i < this.buckets; i += 2) {
            int bitIndex = i / 2;
            boolean bitValue = this.bitSet.get(i) || this.bitSet.get(i + 1);
            this.bitSet.set(bitIndex, bitValue);
        }
        this.bitSet.clear(this.buckets / 2, this.buckets);
    }
}

