/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.xlt.report.util.DoubleMinMaxTimeSeriesDataItem;
import com.xceptance.xlt.report.util.MinMaxTimeSeriesDataItem;
import java.util.TimeZone;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;

public class MinMaxTimeSeriesCollection
extends TimeSeriesCollection {
    private static final long serialVersionUID = -7636814302926500703L;

    public MinMaxTimeSeriesCollection() {
    }

    public MinMaxTimeSeriesCollection(TimeSeries series, TimeZone zone) {
        super(series, zone);
    }

    public MinMaxTimeSeriesCollection(TimeSeries series) {
        super(series);
    }

    public MinMaxTimeSeriesCollection(TimeZone zone) {
        super(zone);
    }

    public Number getEndY(int series, int item) {
        TimeSeries ts = this.getSeries(series);
        TimeSeriesDataItem dataItem = ts.getDataItem(item);
        if (dataItem instanceof MinMaxTimeSeriesDataItem) {
            return ((MinMaxTimeSeriesDataItem)dataItem).getMinMaxValue().getMaximumValue();
        }
        if (dataItem instanceof DoubleMinMaxTimeSeriesDataItem) {
            return ((DoubleMinMaxTimeSeriesDataItem)dataItem).getMinMaxValue().getMaximumValue();
        }
        return dataItem.getValue();
    }

    public Number getStartY(int series, int item) {
        TimeSeries ts = this.getSeries(series);
        TimeSeriesDataItem dataItem = ts.getDataItem(item);
        if (dataItem instanceof MinMaxTimeSeriesDataItem) {
            return ((MinMaxTimeSeriesDataItem)dataItem).getMinMaxValue().getMinimumValue();
        }
        if (dataItem instanceof DoubleMinMaxTimeSeriesDataItem) {
            return ((DoubleMinMaxTimeSeriesDataItem)dataItem).getMinMaxValue().getMinimumValue();
        }
        return dataItem.getValue();
    }

    public double[] getValues(int series, int item) {
        TimeSeries timeSeries = this.getSeries(series);
        TimeSeriesDataItem dataItem = timeSeries.getDataItem(item);
        if (dataItem instanceof MinMaxTimeSeriesDataItem) {
            return ((MinMaxTimeSeriesDataItem)dataItem).getMinMaxValue().getValues();
        }
        if (dataItem instanceof DoubleMinMaxTimeSeriesDataItem) {
            return ((DoubleMinMaxTimeSeriesDataItem)dataItem).getMinMaxValue().getValues();
        }
        return new double[]{dataItem.getValue().doubleValue()};
    }
}

