/* See license.txt for terms of usage */

/**
 * @license i18n 2.0.6 Copyright jQuery Foundation and other contributors.
 * Released under MIT license, http://github.com/requirejs/i18n/LICENSE
 */

/**
 * JSONSchema Validator - Validates JavaScript objects using JSON Schemas
 *	(http://www.json.com/json-schema-proposal/)
 *
 * Copyright (c) 2007 Kris Zyp SitePen (www.sitepen.com)
 * Licensed under the MIT (MIT-LICENSE.txt) license.
To use the validator call JSONSchema.validate with an instance object and an optional schema object.
If a schema is provided, it will be used to validate. If the instance object refers to a schema (self-validating),
that schema will be used to validate and the schema parameter is not necessary (if both exist,
both validations will occur).
The validate method will return an array of validation errors. If there are no errors, then an
empty list will be returned. A validation error will have two properties:
"property" which indicates which property had the error
"message" which indicates what the error was
 */

define("domplate/domplate",[],function(){return Domplate={},function(){function DomplateTag(e){this.tagName=e}function DomplateEmbed(){}function DomplateLoop(){}function Variable(e,t){this.name=e,this.format=t}function Parts(e){this.parts=e}function parseParts(e){for(var t,n=/\$([_A-Za-z][_A-Za-z0-9.|]*)/g,i=0,r=[];t=n.exec(e);){var s=e.substr(i,n.lastIndex-t[0].length-i);s&&r.push(s);var a=t[1].split("|");r.push(new Variable(a[0],a.slice(1))),i=n.lastIndex}if(!i)return e;var o=e.substr(i);return o&&r.push(o),new Parts(r)}function parseValue(e){return"string"==typeof e?parseParts(e):e}function parseChildren(e,t,n,i){for(var r=t;r<e.length;++r){var s=parseValue(e[r]);i.push(s),readPartNames(s,n)}}function readPartNames(e,t){if(e instanceof Parts)for(var n=0;n<e.parts.length;++n){var i=e.parts[n];i instanceof Variable&&t.push(i.name)}}function generateArg(e,t,n){if(e instanceof Parts){for(var i=[],r=0;r<e.parts.length;++r){var s=e.parts[r];if(s instanceof Variable){var a="d"+t.renderIndex++;if(s.format)for(var o=0;o<s.format.length;++o)a=s.format[o]+"("+a+")";i.push(a)}else i.push('"'+s.replace(/"/g,'\\"')+'"')}return i.join("+")}return n.push(e),"s"+t.staticIndex++}function addParts(e,t,n,i,r){var s=[];if(e instanceof Parts)for(var a=0;a<e.parts.length;++a){var o=e.parts[a];if(o instanceof Variable){var l=o.name;if(o.format)for(var p=0;p<o.format.length;++p)l=o.format[p]+"("+l+")";r?s.push("__escape__("+l+")"):s.push(l)}else s.push('"'+o+'"')}else isTag(e)?(i.args.push(e),s.push("s"+i.argIndex++)):s.push('"'+e+'"');var c=s.join(t);c&&n.push(t,c)}function isTag(e){return("function"==typeof e||e instanceof Function)&&Boolean(e.tag)}function creator(e,t){var n=new Function("var tag = arguments.callee.tag;var cons = arguments.callee.cons;var newTag = new cons();return newTag.merge(arguments, tag);");return n.tag=e,n.cons=t,extend(n,Renderer),n}function copyArray(e){var t=[];if(e)for(var n=0;n<e.length;++n)t.push(e[n]);return t}function copyObject(e,t){var n={};return extend(n,e),extend(n,t),n}function extend(e,t){for(var n in t)e[n]=t[n]}function ArrayIterator(e){var t=-1;this.next=function(){if(++t>=e.length)throw StopIteration;return e[t]}}function StopIteration(){}function defineTags(){for(var e=0;e<arguments.length;++e){var t=arguments[e],n=new Function("var newTag = new Domplate.DomplateTag('"+t+"'); return newTag.merge(arguments);"),i=t.toUpperCase();Domplate[i]=n}}this.DomplateTag=DomplateTag;var womb=null,domplate=function(){for(var e,t=0;t<arguments.length;++t)e=e?copyObject(e,arguments[t]):arguments[t];for(var n in e){var i=e[n];isTag(i)&&(i.tag.subject&&(e[n]=i=copyObject({},i),i.tag=copyObject({},i.tag)),i.tag.subject=e)}return e};domplate.context=function(e,t){var n=domplate.lastContext;domplate.topContext=e,t.apply(e),domplate.topContext=n},this.domplate=domplate,this.create=domplate,this.TAG=function(){return(new DomplateEmbed).merge(arguments)},this.FOR=function(){return(new DomplateLoop).merge(arguments)},DomplateTag.prototype={merge:function(e,t){t&&(this.tagName=t.tagName),this.context=t?t.context:null,this.subject=t?t.subject:null,this.attrs=t?copyObject(t.attrs):{},this.classes=t?copyObject(t.classes):{},this.props=t?copyObject(t.props):null,this.listeners=t?copyArray(t.listeners):null,this.children=t?copyArray(t.children):[],this.vars=t?copyArray(t.vars):[];var n=e.length?e[0]:null,i="object"==typeof n&&!isTag(n);return this.children=[],domplate.topContext&&(this.context=domplate.topContext),e.length&&parseChildren(e,i?1:0,this.vars,this.children),i&&this.parseAttrs(n),creator(this,DomplateTag)},parseAttrs:function(e){for(var t in e){var n=parseValue(e[t]);if(readPartNames(n,this.vars),0===t.indexOf("on")){var i=t.substr(2);this.listeners||(this.listeners=[]),this.listeners.push(i,n)}else if(0===t.indexOf("_")){var r=t.substr(1);this.props||(this.props={}),this.props[r]=n}else if(0===t.indexOf("$")){var s=t.substr(1);this.classes||(this.classes={}),this.classes[s]=n}else"class"===t&&t in this.attrs?this.attrs[t]+=" "+n:this.attrs[t]=n}},compile:function(){this.renderMarkup||(this.compileMarkup(),this.compileDOM())},compileMarkup:function(){function __link__(e,t,n,i){e.tag.compile();var r=[],s=[t,e.tag.context,i,r];s.push.apply(s,e.tag.markupArgs),e.tag.renderMarkup.apply(e.tag.subject,s),n.push(e),n.push(r)}function __escape__(e){function t(e){switch(e){case"<":return"&lt;";case">":return"&gt;";case"&":return"&amp;";case"'":return"&#39;";case'"':return"&quot;"}return"?"}return String(e).replace(/[<>&"']/g,t)}function __loop__(e,t,n){var i=[];t.push(i),e instanceof Array&&(e=new ArrayIterator(e));try{for(;;){var r=e.next(),s=[0,0];i.push(s),n.apply(this,[r,s])}}catch(e){if(e!==StopIteration)throw e}}this.markupArgs=[];var topBlock=[],topOuts=[],blocks=[],info={args:this.markupArgs,argIndex:0};this.generateMarkup(topBlock,topOuts,blocks,info),this.addCode(topBlock,topOuts,blocks);for(var fnBlock=["(function (__code__, __context__, __in__, __out__"],i=0;i<info.argIndex;++i)fnBlock.push(", s",i);fnBlock.push(") {\n"),this.subject&&fnBlock.push("with (this) {\n"),this.context&&fnBlock.push("with (__context__) {\n"),fnBlock.push("with (__in__) {\n"),fnBlock.push.apply(fnBlock,blocks),this.subject&&fnBlock.push("}\n"),this.context&&fnBlock.push("}\n"),fnBlock.push("}})\n");var js=fnBlock.join("");this.renderMarkup=eval(js)},getVarNames:function(e){this.vars&&e.push.apply(e,this.vars);for(var t=0;t<this.children.length;++t){var n=this.children[t];if(isTag(n))n.tag.getVarNames(e);else if(n instanceof Parts)for(var i=0;i<n.parts.length;++i)if(n.parts[i]instanceof Variable){var r=n.parts[i].name,s=r.split(".");e.push(s[0])}}},generateMarkup:function(e,t,n,i){e.push(',"<',this.tagName,'"');var r;for(r in this.attrs)if("class"!==r){var s=this.attrs[r];e.push(', " ',r,'=\\""'),addParts(s,",",e,i,!0),e.push(', "\\""')}if(this.listeners)for(var a=0;a<this.listeners.length;a+=2)readPartNames(this.listeners[a+1],t);if(this.props)for(r in this.props)readPartNames(this.props[r],t);if("class"in this.attrs||this.classes){e.push(', " class=\\""'),"class"in this.attrs&&addParts(this.attrs.class,",",e,i,!0),e.push(', " "');for(r in this.classes)e.push(", ("),addParts(this.classes[r],"",e,i),e.push(' ? "',r,'" + " " : "")');e.push(', "\\""')}e.push(',">"'),this.generateChildMarkup(e,t,n,i),e.push(',"</',this.tagName,'>"')},generateChildMarkup:function(e,t,n,i){for(var r=0;r<this.children.length;++r){var s=this.children[r];isTag(s)?s.tag.generateMarkup(e,t,n,i):addParts(s,",",e,i,!0)}},addCode:function(e,t,n){e.length&&n.push('__code__.push(""',e.join(""),");\n"),t.length&&n.push("__out__.push(",t.join(","),");\n"),e.splice(0,e.length),t.splice(0,t.length)},addLocals:function(e){var t=[];this.getVarNames(t);for(var n={},i=0;i<t.length;++i){var r=t[i];if(!n.hasOwnProperty(r)){n[r]=1;var s=r.split(".");e.push("var ",s[0]+" = __in__."+s[0]+";\n")}}},compileDOM:function(){function __prop__(e,t,n){e[t]=n}function __bind__(e,t){return function(n){return t.apply(e,[n])}}function __link__(e,t,n){t.tag.compile();var i=[e,t.tag.context,0];return i.push.apply(i,t.tag.domArgs),i.push.apply(i,n),t.tag.renderDOM.apply(t.tag.subject,i)}function __loop__(e,t){for(var n=0,i=0;i<e.length;++i)e[i][0]=i,e[i][1]=n,n+=t.apply(this,e[i]);return n}function __path__(e,t){for(var n=2;n<arguments.length;++n){var i=arguments[n];3===n&&(i+=t),e=-1===i?e.parentNode:e.childNodes[i]}return e}var path=[],blocks=[];this.domArgs=[],path.embedIndex=0,path.loopIndex=0,path.staticIndex=0,path.renderIndex=0;var nodeCount=this.generateDOM(path,blocks,this.domArgs),fnBlock=["(function (root, context, o"],i;for(i=0;i<path.staticIndex;++i)fnBlock.push(", ","s"+i);for(i=0;i<path.renderIndex;++i)fnBlock.push(", ","d"+i);for(fnBlock.push(") {\n"),i=0;i<path.loopIndex;++i)fnBlock.push("var l",i," = 0;\n");for(i=0;i<path.embedIndex;++i)fnBlock.push("var e",i," = 0;\n");this.subject&&fnBlock.push("with (this) {\n"),this.context&&fnBlock.push("with (context) {\n"),fnBlock.push(blocks.join("")),this.subject&&fnBlock.push("}\n"),this.context&&fnBlock.push("}\n"),fnBlock.push("return ",nodeCount,";\n"),fnBlock.push("})\n");var self=this,js=fnBlock.join("");this.renderDOM=eval(js)},generateDOM:function(e,t,n){(this.listeners||this.props)&&this.generateNodePath(e,t);var i,r;if(this.listeners)for(var s=0;s<this.listeners.length;s+=2)i=this.listeners[s+1],r=generateArg(i,e,n),t.push('node.addEventListener("',this.listeners[s],'", __bind__(this, ',r,"), false);\n");if(this.props)for(var a in this.props)i=this.props[a],r=generateArg(i,e,n),t.push("__prop__(node, '"+a+"', "+r+");\n");return this.generateChildDOM(e,t,n),1},generateNodePath:function(e,t){t.push("var node = __path__(root, o");for(var n=0;n<e.length;++n)t.push(",",e[n]);t.push(");\n")},generateChildDOM:function(e,t,n){e.push(0);for(var i=0;i<this.children.length;++i){var r=this.children[i];isTag(r)?e[e.length-1]+="+"+r.tag.generateDOM(e,t,n):e[e.length-1]+="+1"}e.pop()}},DomplateEmbed.prototype=copyObject(DomplateTag.prototype,{merge:function(e,t){this.value=t?t.value:parseValue(e[0]),this.attrs=t?t.attrs:{},this.vars=t?copyArray(t.vars):[];var n=e[1];for(var i in n){var r=parseValue(n[i]);this.attrs[i]=r,readPartNames(r,this.vars)}return creator(this,DomplateEmbed)},getVarNames:function(e){this.value instanceof Parts&&e.push(this.value.parts[0].name),this.vars&&e.push.apply(e,this.vars)},generateMarkup:function(e,t,n,i){this.addCode(e,t,n),n.push("__link__("),addParts(this.value,"",n,i),n.push(", __code__, __out__, {\n");var r=null;for(var s in this.attrs){r&&n.push(","),r=s;var a=this.attrs[s];n.push('"',s,'":'),addParts(a,"",n,i)}n.push("});\n")},generateDOM:function(e,t,n){var i="e"+e.embedIndex++;this.generateNodePath(e,t);var r="d"+e.renderIndex++,s="d"+e.renderIndex++;return t.push(i+" = __link__(node, ",r,", ",s,");\n"),i}}),DomplateLoop.prototype=copyObject(DomplateTag.prototype,{merge:function(e,t){return this.isLoop=!0,this.varName=t?t.varName:e[0],this.iter=t?t.iter:parseValue(e[1]),this.vars=[],this.children=t?copyArray(t.children):[],parseChildren(e,Math.min(e.length,2),this.vars,this.children),creator(this,DomplateLoop)},getVarNames:function(e){this.iter instanceof Parts&&e.push(this.iter.parts[0].name),DomplateTag.prototype.getVarNames.apply(this,[e])},generateMarkup:function(e,t,n,i){this.addCode(e,t,n);var r;if(this.iter instanceof Parts){var s=this.iter.parts[0];if(r=s.name,s.format)for(var a=0;a<s.format.length;++a)r=s.format[a]+"("+r+")"}else r=this.iter;n.push("__loop__.apply(this, [",r,", __out__, function(",this.varName,", __out__) {\n"),this.generateChildMarkup(e,t,n,i),this.addCode(e,t,n),n.push("}]);\n")},generateDOM:function(e,t,n){var i="d"+e.renderIndex++,r="i"+e.loopIndex,s="l"+e.loopIndex++;e.length||e.push(-1,0);var a=e.renderIndex;e.renderIndex=0;for(var o=0,l=[],p=e[e.length-1],c=0;c<this.children.length;++c){e[e.length-1]=p+"+"+s+"+"+o;var u=this.children[c];isTag(u)?o+="+"+u.tag.generateDOM(e,l,n):o+="+1"}e[e.length-1]=p+"+"+s,t.push(s," = __loop__.apply(this, [",i,", function(",r,",",s);for(var h=0;h<e.renderIndex;++h)t.push(",d"+h);return t.push(") {\n"),t.push(l.join("")),t.push("return ",o,";\n"),t.push("}]);\n"),e.renderIndex=a,s}}),this.$break=function(){throw StopIteration};var Renderer={renderHTML:function(e,t,n){var i=[],r=[i,this.tag.context,e,t];return r.push.apply(r,this.tag.markupArgs),this.tag.renderMarkup.apply(n||this.tag.subject,r),i.join("")},insertRows:function(e,t,n){this.tag.compile();var i=[],r=this.renderHTML(e,i,n),s=t.ownerDocument,a=s.createElement("div");a.innerHTML="<table>"+r+"</table>";for(var o,l=a.firstChild.firstChild,p="tr"===t.tagName.toLowerCase()?t.parentNode:t,c="tr"===t.tagName.toLowerCase()?t.nextSibling:null,u=l.firstChild;l.firstChild;)o=l.firstChild,c?p.insertBefore(o,c):p.appendChild(o);var h=0;if(this.tag.isLoop)for(var d=u.parentNode.firstChild;d&&d!==u;d=d.nextSibling)++h;var f=[u,this.tag.context,h];return f.push.apply(f,this.tag.domArgs),f.push.apply(f,i),this.tag.renderDOM.apply(n||this.tag.subject,f),[u,o]},insertAfter:function(e,t,n){this.tag.compile();var i=[],r=this.renderHTML(e,i,n),s=t.ownerDocument,a=s.createRange();a.selectNode(s.body);var o=a.createContextualFragment(r),l=o.firstChild;t.nextSibling?t.parentNode.insertBefore(o,t.nextSibling):t.parentNode.appendChild(o);var p=[l,this.tag.context,0];return p.push.apply(p,this.tag.domArgs),p.push.apply(p,i),this.tag.renderDOM.apply(n||(this.tag.subject?this.tag.subject:null),p),l},replace:function(e,t,n){this.tag.compile();var i,r=[],s=this.renderHTML(e,r,n);1===t.nodeType?(t.innerHTML=s,i=t.firstChild):(t&&9===t.nodeType||(t=document),womb&&womb.ownerDocument===t||(womb=t.createElement("div")),womb.innerHTML=s,i=womb.firstChild);var a=[i,this.tag.context,0];return a.push.apply(a,this.tag.domArgs),a.push.apply(a,r),this.tag.renderDOM.apply(n||this.tag.subject,a),i},append:function(e,t,n){this.tag.compile();var i=[],r=this.renderHTML(e,i,n);womb&&womb.ownerDocument===t.ownerDocument||(womb=t.ownerDocument.createElement("div")),womb.innerHTML=r;for(var s=womb.firstChild;womb.firstChild;)t.appendChild(womb.firstChild);var a=[s,this.tag.context,0];return a.push.apply(a,this.tag.domArgs),a.push.apply(a,i),this.tag.renderDOM.apply(n||this.tag.subject,a),s},insertCols:function(e,t,n){this.tag.compile();var i=[],r=this.renderHTML(e,i,n),s=t.ownerDocument.createElement("div");s.innerHTML="<table><tbody><tr>"+r+"</tr></tbody></table>",s=s.firstChild.firstChild.firstChild;var a=s.firstChild;if(!a)return null;for(;s.firstChild;)t.appendChild(s.firstChild);var o=0;if(this.tag.isLoop)for(var l=a.parentNode.firstChild;l&&l!==a;l=l.nextSibling)++o;var p=[a,this.tag.context,o];return p.push.apply(p,this.tag.domArgs),p.push.apply(p,i),this.tag.renderDOM.apply(n||this.tag.subject,p),a}};defineTags("a","button","br","canvas","col","colgroup","div","fieldset","form","h1","h2","h3","hr","img","input","label","legend","li","ol","optgroup","option","p","pre","select","span","strong","table","tbody","td","textarea","tfoot","th","thead","tr","tt","ul","code","iframe","canvas")}.apply(Domplate),Domplate}),define("core/trace",[],function(){var e={log:function(){},error:function(){},exception:function(){},time:function(){},timeEnd:function(){}};return"undefined"==typeof console?e:(e.error=function(){"function"==typeof console.error&&console.error.apply(console,arguments)},e.exception=function(){"function"==typeof console.error&&console.error.apply(console,arguments)},e)}),define("core/array",["./trace"],function(e){var t={};return t.isArray=function(e){return Array.isArray(e)},t.cloneArray=function(e,t){var n=[];if(t)for(var i=0;i<e.length;++i)n.push(t(e[i]));else for(var r=0;r<e.length;++r)n.push(e[r]);return n},t.arrayInsert=function(e,t,n){for(var i=0;i<n.length;++i)e.splice(i+t,0,n[i]);return e},t.remove=function(e,t){for(var n=0;n<e.length;++n)if(e[n]===t)return e.splice(n,1),!0;return!1},t}),define("core/css",["./trace"],function(e){var t={};return t.hasClass=function(e,t){if(!e||1!==e.nodeType)return!1;for(var n=jQuery(e),i=1;i<arguments.length;++i)if(t=arguments[i],!n.hasClass(t))return!1;return!0},t.setClass=function(e,t){e&&jQuery(e).addClass(t)},t.removeClass=function(e,t){e&&jQuery(e).removeClass(t)},t.toggleClass=function(e,t){e&&jQuery(e).toggleClass(t)},t.setClassTimed=function(e,n,i){i||(i=1300),e.__setClassTimeout?clearTimeout(e.__setClassTimeout):t.setClass(e,n),e.__setClassTimeout=setTimeout(function(){delete e.__setClassTimeout,t.removeClass(e,n)},i)},t.getHead=function(e){return e.getElementsByTagName("head")[0]},t.addStyleSheet=function(e,n){if(!e.getElementById(n)){var i=e.createElement("link");i.type="text/css",i.rel="stylesheet",i.href=n,i.setAttribute("id",n);t.getHead(e).appendChild(i)}},t}),define("core/date",["./trace"],function(e){var t={};return t.parseISO8601=function(e){var n=t.fromISOString(e);return n?n.getTime():null},t.fromISOString=function(e){if(!e)return null;var t=/(\d\d\d\d)(-)?(\d\d)(-)?(\d\d)(T)?(\d\d)(:)?(\d\d)(:)?(\d\d)(\.\d+)?(Z|([+-])(\d\d)(:)?(\d\d))/,n=e.toString().match(new RegExp(t));if(!n)return null;var i=new Date;if(i.setUTCDate(1),i.setUTCFullYear(parseInt(n[1],10)),i.setUTCMonth(parseInt(n[3],10)-1),i.setUTCDate(parseInt(n[5],10)),i.setUTCHours(parseInt(n[7],10)),i.setUTCMinutes(parseInt(n[9],10)),i.setUTCSeconds(parseInt(n[11],10)),n[12]?i.setUTCMilliseconds(1e3*parseFloat(n[12])):i.setUTCMilliseconds(0),"Z"!==n[13]){var r=60*n[15]+parseInt(n[17],10);r*="-"===n[14]?-1:1,i.setTime(i.getTime()-60*r*1e3)}return i},t.toISOString=function(e){function t(e,t){t||(t=2);for(var n=new String(e);n.length<t;)n="0"+n;return n}var n=e.getUTCFullYear()+"-"+t(e.getMonth()+1)+"-"+t(e.getDate())+"T"+t(e.getHours())+":"+t(e.getMinutes())+":"+t(e.getSeconds())+"."+t(e.getMilliseconds(),3),i=e.getTimezoneOffset(),r=Math.floor(i/60),s=Math.floor(i%60);return n+(i>0?"-":"+")+t(Math.abs(r))+":"+t(Math.abs(s))},t}),define("core/sniff",["./trace"],function(e){var t={},n="undefined"!=typeof navigator,i="undefined"!=typeof window,r=n?navigator.userAgent.toLowerCase():"";return t.isFirefox=/firefox/.test(r),t.isOpera=/opera/.test(r),t.isWebkit=/webkit/.test(r),t.isSafari=/webkit/.test(r),t.isIE=/msie/.test(r)&&!/opera/.test(r),t.isIE6=n&&/msie 6/i.test(navigator.appVersion),t.browserVersion=(r.match(/.+(?:rv|it|ra|ie)[\/: ]([\d.]+)/)||[0,"0"])[1],t.isIElt8=t.isIE&&t.browserVersion-0<8,t.supportsSelectElementText=i&&(window.getSelection&&window.document.createRange||window.document.body.createTextRange),t}),define("core/dom",["./array","./css","./sniff","./trace"],function(e,t,n,i){var r={};return r.getBody=function(e){if(e.body)return e.body;var t=e.getElementsByTagName("body")[0];return t||null},r.getAncestorByClass=function(e,n){for(var i=e;i;i=i.parentNode)if(t.hasClass(i,n))return i;return null},r.$=function(){return r.getElementByClass.apply(this,arguments)},r.getElementByClass=function(n,i){if(!n)return null;var s=e.cloneArray(arguments);s.splice(0,1);for(var a=n.firstChild;a;a=a.nextSibling){var o=e.cloneArray(s);if(o.unshift(a),t.hasClass.apply(this,o))return a;var l=r.getElementByClass.apply(this,o);if(l)return l}return null},r.getElementsByClass=function(n,i){function r(n,i,s){for(var a=n.firstChild;a;a=a.nextSibling){var o=e.cloneArray(i);o.unshift(a),t.hasClass.apply(null,o)&&s.push(a),r(a,i,s)}}var s=e.cloneArray(arguments);if(s.shift(),n.querySelectorAll){var a="."+s.join(".");return n.querySelectorAll(a)}var o=[];return r(n,s,o),o},r.getChildByClass=function(e){for(var n=1;n<arguments.length;++n){var i=arguments[n],r=e.firstChild;for(e=null;r;r=r.nextSibling)if(t.hasClass(r,i)){e=r;break}}return e},r.isAncestor=function(e,t){for(var n=e;n;n=n.parentNode)if(n===t)return!0;return!1},r.eraseNode=function(e){for(;e.lastChild;)e.removeChild(e.lastChild)},r.clearNode=function(e){e.innerHTML=""},r.getOverflowParent=function(e){for(var t=e.parentNode;t;t=t.offsetParent)if(t.scrollHeight>t.offsetHeight)return t},r.getElementBox=function(e){var t={};if(e.getBoundingClientRect){var i=e.getBoundingClientRect(),s=n.isIE?document.body.clientTop||document.documentElement.clientTop:0,a=r.getWindowScrollPosition();t.top=Math.round(i.top-s+a.top),t.left=Math.round(i.left-s+a.left),t.height=Math.round(i.bottom-i.top),t.width=Math.round(i.right-i.left)}else{var o=r.getElementPosition(e);t.top=o.top,t.left=o.left,t.height=e.offsetHeight,t.width=e.offsetWidth}return t},r.getElementPosition=function(e){var t=0,n=0;do{t+=e.offsetLeft,n+=e.offsetTop}while(e===e.offsetParent);return{left:t,top:n}},r.getWindowSize=function(){var e,t=0,n=0;return"number"==typeof window.innerWidth?(t=window.innerWidth,n=window.innerHeight):(e=document.documentElement)&&(e.clientHeight||e.clientWidth)?(t=e.clientWidth,n=e.clientHeight):(e=document.body)&&(e.clientHeight||e.clientWidth)&&(t=e.clientWidth,n=e.clientHeight),{width:t,height:n}},r.getWindowScrollSize=function(){var e,t=0,i=0;return!n.isIEQuiksMode&&(e=document.documentElement)&&(e.scrollHeight||e.scrollWidth)&&(t=e.scrollWidth,i=e.scrollHeight),(e=document.body)&&(e.scrollHeight||e.scrollWidth)&&(e.scrollWidth>t||e.scrollHeight>i)&&(t=e.scrollWidth,i=e.scrollHeight),{width:t,height:i}},r.getWindowScrollPosition=function(){var e,t=0,n=0;return"number"==typeof window.pageYOffset?(t=window.pageYOffset,n=window.pageXOffset):(e=document.body)&&(e.scrollTop||e.scrollLeft)?(t=e.scrollTop,n=e.scrollLeft):(e=document.documentElement)&&(e.scrollTop||e.scrollLeft)&&(t=e.scrollTop,n=e.scrollLeft),{top:t,left:n}},r.scrollIntoCenterView=function(e,t,n,i){if(e&&(t||(t=r.getOverflowParent(e)),t)){var s=r.getClientOffset(e);if(!i){var a=s.y-t.scrollTop,o=t.scrollTop+t.clientHeight-(s.y+e.offsetHeight);if(a<0||o<0){var l=s.y-t.clientHeight/2;t.scrollTop=l}}if(!n){var p=s.x-t.scrollLeft,c=t.scrollLeft+t.clientWidth-(s.x+e.clientWidth);if(p<0||c<0){var u=s.x-t.clientWidth/2;t.scrollLeft=u}}}},r.getClientOffset=function(e){function t(e,n,i){var r=e.offsetParent,s=i.getComputedStyle(e,"");e.offsetLeft&&(n.x+=e.offsetLeft+parseInt(s.borderLeftWidth,10)),e.offsetTop&&(n.y+=e.offsetTop+parseInt(s.borderTopWidth,10)),r?1===r.nodeType&&t(r,n,i):e.ownerDocument.defaultView.frameElement&&t(e.ownerDocument.defaultView.frameElement,n,e.ownerDocument.defaultView)}var n={x:0,y:0};if(e){t(e,n,e.ownerDocument.defaultView)}return n},r}),define("core/events",["./trace"],function(e){var t={};return t.dispatch=function(t,n,i){for(var r=0;t&&r<t.length;r++){var s=t[r];if(s[n])try{s[n].apply(s,i)}catch(t){e.exception(t)}}},t.dispatch2=function(t,n,i){for(var r=0;r<t.length;r++){var s=t[r];if(s[n])try{var a=s[n].apply(s,i);if(a)return a}catch(t){e.exception(t)}}},t.fixEvent=function(e){return jQuery.event.fix(e||window.event)},t.fireEvent=function(e,t){if(document.createEvent){var n=document.createEvent("Events");return n.initEvent(t,!0,!1),!e.dispatchEvent(n)}},t.cancelEvent=function(e){var n=t.fixEvent(e);n.stopPropagation(),n.preventDefault()},t.addEventListener=function(e,t,n,i){i=i||!1,e.addEventListener?e.addEventListener(t,n,i):e.attachEvent("on"+t,n)},t.removeEventListener=function(e,t,n,i){i=i||!1,e.removeEventListener?e.removeEventListener(t,n,i):e.detachEvent("on"+t,n)},t.isLeftClick=function(e){return 0===e.button&&t.noKeyModifiers(e)},t.noKeyModifiers=function(e){return!(e.ctrlKey||e.shiftKey||e.altKey||e.metaKey)},t.isControlClick=function(e){return 0===e.button&&t.isControl(e)},t.isShiftClick=function(e){return 0===e.button&&t.isShift(e)},t.isControl=function(e){return(e.metaKey||e.ctrlKey)&&!e.shiftKey&&!e.altKey},t.isAlt=function(e){return e.altKey&&!e.ctrlKey&&!e.shiftKey&&!e.metaKey},t.isAltClick=function(e){return 0===e.button&&t.isAlt(e)},t.isControlShift=function(e){return(e.metaKey||e.ctrlKey)&&e.shiftKey&&!e.altKey},t.isShift=function(e){return e.shiftKey&&!e.metaKey&&!e.ctrlKey&&!e.altKey},t}),define("core/json",["./trace"],function(e){var t={};return t.cloneJSON=function(t){if(null===t||"object"!=typeof t)return t;try{var n=t.constructor();for(var i in t)n[i]=this.cloneJSON(t[i]);return n}catch(t){e.exception(t)}return null},t}),define("core/mime",["./trace"],function(e){var t={};return t.extractMimeType=function(e){if("string"!=typeof e)throw new Error(typeof e+" is not of type string");var t=e.indexOf(";");return t>-1&&(e=e.substring(0,t).trim()),e},t}),define("core/object",["./array","./sniff"],function(e,t){var n={},i=Object.prototype.toString,r=/^\s*function(\s+[\w_$][\w\d_$]*)?\s*\(/;return n.isFunction=function(e){return!!e&&("[object Function]"===i.call(e)||t.isIE&&"string"!=typeof e&&r.test(String(e)))},n.extend=function(e,t){var i={};return n.append(i,e),n.append(i,t),i},n.append=function(e,t){for(var n in t)e[n]=t[n];return e},n.bind=function(){var t=e.cloneArray(arguments),n=t.shift(),i=t.shift();return function(){var r=t.concat(e.cloneArray(arguments));return n.apply(i,r)}},n.bindFixed=function(){var t=e.cloneArray(arguments),n=t.shift(),i=t.shift();return function(){return n.apply(i,t)}},n}),define("core/rect",["./trace"],function(e){var t={};return t.inflateRect=function(e,t,n){return{top:e.top-n,left:e.left-t,height:e.height+2*n,width:e.width+2*t}},t.pointInRect=function(e,t,n){return n>=e.top&&n<=e.top+e.height&&t>=e.left&&t<=e.left+e.width},t}),define("core/string",["./array","./trace"],function(e,t){var n={};return n.formatSize=function(e){var t=1;if(t=t>2?2:t,-1===(t=t<-1?-1:t))return e+" B";var n=Math.pow(10,t);return-1===e||void 0===e?"?":0===e?"0":e<1024?e+" B":e<1048576?Math.round(e/1024*n)/n+" KB":Math.round(e/1048576*n)/n+" MB"},n.formatTime=function(e){return-1===e?"-":e<1e3?e+"ms":e<6e4?Math.ceil(e/10)/100+"s":Math.ceil(e/6e4*100)/100+"m"},n.formatNumber=function(e){e=String(e);for(var t=e.split("."),n=t[0],i=t.length>1?"."+t[1]:"",r=/(\d+)(\d{3})/;r.test(n);)n=n.replace(r,"$1 $2");return n+i},n.formatString=function(t){var n=e.cloneArray(arguments);t=n.shift();for(var i=0;i<n.length;i++){var r=n[i].toString();t=t.replace("%S",r)}return t},n.startsWith=function(e,t,n){return n=n||0,e.indexOf(t,n)===n},n.trim=function(e){return e.replace(/^\s*|\s*$/g,"")},n.wrapText=function(e,t){for(var i=/[^A-Za-z_$0-9'"-]/,r=[],s=n.splitLines(e),a=0;a<s.length;++a){for(var o=s[a];o.length>100;){var l=i.exec(o.substr(100,100)),p=100+(l?l.index:0),c=o.substr(0,p);o=o.substr(p),t||r.push("<pre>"),r.push(t?c:n.escapeHTML(c)),t||r.push("</pre>")}t||r.push("<pre>"),r.push(t?o:n.escapeHTML(o)),t||r.push("</pre>")}return r.join(t?"\n":"")},n.insertWrappedText=function(e,t,i){t.innerHTML="<pre>"+n.wrapText(e,i)+"</pre>"},n.splitLines=function(e){var t=/\r\n|\r|\n/;return e?e.split?e.split(t):String(e).split(t):[]},n.escapeHTML=function(e){function t(e){switch(e){case"<":return"&lt;";case">":return"&gt;";case"&":return"&amp;";case"'":return"&#39;";case'"':return"&quot;"}return"?"}return String(e).replace(/[<>&"']/g,t)},n.cropString=function(e,t){e=String(e);var i=t?t/2:50;return e.length>t?n.escapeNewLines(e.substr(0,i)+"..."+e.substr(e.length-i)):n.escapeNewLines(e)},n.escapeNewLines=function(e){return e.replace(/\r/g,"\\r").replace(/\n/g,"\\n")},n}),define("core/url",["./trace"],function(e){var t={};return t.getFileName=function(n){try{return t.splitURLBase(n).name}catch(t){e.log(unescape(n))}return n},t.getFileExtension=function(e){if(!e)return null;var t=e.indexOf("?");-1!==t&&(e=e.substr(0,t));var n=e.lastIndexOf(".");return e.substr(n+1)},t.splitURLBase=function(e){return t.isDataURL(e)?t.splitDataURL(e):t.splitURLTrue(e)},t.isDataURL=function(e){return e&&"data:"===e.substr(0,5)},t.splitDataURL=function(e){var n=e.indexOf(":",3);if(4!==n)return!1;var i=e.indexOf(",",n+1);if(i<n)return!1;for(var r={encodedContent:e.substr(i+1)},s=e.substr(n+1,i),a=s.split(";"),o=0;o<a.length;o++){var l=a[o].split("=");2===l.length&&(r[l[0]]=l[1])}if(r.hasOwnProperty("fileName")){var p=decodeURIComponent(r.fileName),c=t.splitURLTrue(p);if(r.hasOwnProperty("baseLineNumber")){r.path=c.path,r.line=r.baseLineNumber;var u=r.encodedContent.substr(0,200),h=decodeURIComponent(u).replace(/\s*$/,"");r.name="eval->"+h}else r.name=c.name,r.path=c.path}else if(r.hasOwnProperty("path")||(r.path="data:"),!r.hasOwnProperty("name")){var d=r.encodedContent.substr(0,200);r.name=decodeURIComponent(d).replace(/\s*$/,"")}return r},t.splitURLTrue=function(e){var t=/:\/{1,3}(.*?)\/([^\/]*?)\/?($|\?.*)/,n=t.exec(e);return n?n[2]?{path:n[1],name:n[2]+n[3]}:{path:n[1],name:n[1]}:{name:e,path:e}},t.getQuery=function(e){if("string"!=typeof e)return window.location.search.substring(1);var t=e.indexOf("?");return t<0?"":e.substring(t+1)},t.getHash=function(e){if("string"!=typeof e)return window.location.hash.substring(1);var t=e.indexOf("#");return t<0?"":e.substring(t+1)},t.getURLParameter=function(e,n){for(var i=t.getQuery(n),r=i.split("&"),s=0;s<r.length;s++){var a=r[s].split("=");if(a[0]===e)return unescape(a[1])}return null},t.getURLParameters=function(e,n){for(var i=t.getQuery(n),r=[],s=i.split("&"),a=0;a<s.length;a++){var o=s[a].split("=");o[0]===e&&r.push(unescape(o[1]))}return r},t.getHashParameters=function(e,n){for(var i=t.getHash(n),r=[],s=i.split("&"),a=0;a<s.length;a++){var o=s[a].split("=");o[0]===e&&r.push(unescape(o[1]))}return r},t.parseURLParams=function(e){var n=e?e.indexOf("?"):-1;if(-1===n)return[];var i=e.substr(n+1),r=i.lastIndexOf("#");return-1!==r&&(i=i.substr(0,r)),i?t.parseURLEncodedText(i):[]},t.parseURLEncodedText=function(e,t){function n(e){try{return decodeURIComponent(e)}catch(t){return decodeURIComponent(unescape(e))}}var i=[];if(!e)return i;e=e.replace(/\+/g," ");for(var r=e.split("&"),s=0;s<r.length;++s)try{var a,o=r[s].indexOf("=");if(-1!==o){a=r[s].substring(0,o);var l=r[s].substring(o+1);l.length>25e3&&!t&&(l="LargeData"),i.push({name:n(a),value:n(l)})}else a=r[s],i.push({name:n(a),value:""})}catch(e){}return i.sort(function(e,t){return e.name<=t.name?-1:1}),i},t.getPrettyDomain=function(e){var t=/^(?!data:)[^:]+:\/{1,3}(www\.)?([^\/]{1,256})/.exec(e);return t?t[2]:""},t}),define("core/lib",["./array","./css","./date","./dom","./events","./json","./mime","./object","./rect","./sniff","./string","./url","./trace"],function(e,t,n,i,r,s,a,o,l,p,c,u,h){var d={};return o.append(d,p),o.append(d,o),o.append(d,r),o.append(d,l),o.append(d,e),o.append(d,c),o.append(d,n),o.append(d,a),o.append(d,u),o.append(d,i),o.append(d,t),o.append(d,s),d}),function(){"use strict";function e(e,t,n,i,r,s){t[e]&&(n.push(e),!0!==t[e]&&1!==t[e]||i.push(r+e+"/"+s))}function t(e,t,n,i,r){var s=i+t+"/"+r;require._fileExists(e.toUrl(s+".js"))&&n.push(s)}function n(e,t,i){var r;for(r in t)!t.hasOwnProperty(r)||e.hasOwnProperty(r)&&!i?"object"==typeof t[r]&&(!e[r]&&t[r]&&(e[r]={}),n(e[r],t[r],i)):e[r]=t[r]}var i=/(^.*(^|\/)nls(\/|$))([^\/]*)\/?([^\/]*)/;define("i18n",["module"],function(r){var s=r.config?r.config():{};return{version:"2.0.6",load:function(r,a,o,l){l=l||{},l.locale&&(s.locale=l.locale);var p,c,u,h=i.exec(r),d=h[1],f=h[4],m=h[5],g=f.split("-"),v=[],y={},b="";if(h[5]?(d=h[1],p=d+m):(p=r,m=h[4],f=s.locale,f||(f=s.locale="undefined"==typeof navigator?"root":(navigator.languages&&navigator.languages[0]||navigator.language||navigator.userLanguage||"root").toLowerCase()),g=f.split("-")),l.isBuild){for(v.push(p),t(a,"root",v,d,m),c=0;c<g.length;c++)u=g[c],b+=(b?"-":"")+u,t(a,b,v,d,m);a(v,function(){o()})}else a([p],function(t){var i,r=[];for(e("root",t,r,v,d,m),c=0;c<g.length;c++)i=g[c],b+=(b?"-":"")+i,e(b,t,r,v,d,m);a(v,function(){var e,i,s;for(e=r.length-1;e>-1&&r[e];e--)s=r[e],i=t[s],!0!==i&&1!==i||(i=a(d+s+"/"+m)),n(y,i);o(y)})})}}})}(),define("nls/requestList",{root:{summaryFromCache:"From Cache",resourceFromCache:"Resource from cache",uncompressed:"Uncompressed",menuBreakLayout:"Break Timeline Layout",menuOpenRequestInWindow:"Open Request in New Window",menuOpenResponseInWindow:"Open Response in New Window",request:"Request",requests:"Requests",tooltipSize:"%S (%S bytes)",tooltipZippedSize:"%S (%S bytes) - compressed",tooltipUnzippedSize:"%S (%S bytes) - uncompressed",unknownSize:"Unknown size","request.Started":"Request start time since the beginning","request.phases.label":"Request phases start and elapsed time relative to the request start:","request.phase.Resolving":"DNS Lookup","request.phase.Connecting":"Connecting","request.phase.Blocking":"Blocking","request.phase.Sending":"Sending","request.phase.Waiting":"Waiting","request.phase.Receiving":"Receiving","request.timings.label":"Event timing relative to the request start:",ContentLoad:"DOM Loaded",WindowLoad:"Page Loaded","page.event.Load":"Page Loaded","paint.event.FP":"First Paint","paint.event.FCP":"First Contentful Paint",menuBreakTimeline:"Break Timeline Layout",menuOpenRequest:"Open Request in New Window",menuOpenResponse:"Open Response in New Window"}}),define("preview/jsonSchema",[],function(){return{validate:function(e,t){return this._validate(e,t,!1)},checkPropertyChange:function(e,t,n){return this._validate(e,t,n||"property")},_validate:function(e,t,n){function i(e,t,a,o){function l(e){s.push({property:a,message:e})}function p(e,t){if(e){
if(!("string"!=typeof e||"any"==e||("null"==e?null===t:typeof t==e)||t instanceof Array&&"array"==e||"integer"==e&&t%1==0))return[{property:a,message:typeof t+" value found, but a "+e+" is required"}];if(e instanceof Array){for(var n=[],r=0;r<e.length&&(n=p(e[r],t)).length;r++);if(n.length)return n}else if("object"==typeof e){var o=s;s=[],i(t,e,a);var l=s;return s=o,l}}return[]}var c;if(a+=a?"number"==typeof o?"["+o+"]":void 0===o?"":"."+o:o,("object"!=typeof t||t instanceof Array)&&(a||"function"!=typeof t))return"function"==typeof t?e instanceof t||l("is not an instance of the class/constructor "+t.name):t&&l("Invalid schema/property definition "+t),null;if(n&&t.readonly&&l("is a readonly field, it can not be changed"),t.extends&&i(e,t.extends,a,o),void 0===e)t.optional||l("is missing and it is not optional");else if(s=s.concat(p(t.type,e)),t.disallow&&!p(t.disallow,e).length&&l(" disallowed value was matched"),null!==e){if(e instanceof Array){if(t.items)if(t.items instanceof Array)for(o=0,c=e.length;o<c;o++)s.concat(i(e[o],t.items[o],a,o));else for(o=0,c=e.length;o<c;o++)s.concat(i(e[o],t.items,a,o));t.minItems&&e.length<t.minItems&&l("There must be a minimum of "+t.minItems+" in the array"),t.maxItems&&e.length>t.maxItems&&l("There must be a maximum of "+t.maxItems+" in the array")}else t.properties&&s.concat(r(e,t.properties,a,t.additionalProperties));if(t.pattern&&"string"==typeof e&&!e.match(t.pattern)&&l("does not match the regex pattern "+t.pattern),t.maxLength&&"string"==typeof e&&e.length>t.maxLength&&l("may only be "+t.maxLength+" characters long"),t.minLength&&"string"==typeof e&&e.length<t.minLength&&l("must be at least "+t.minLength+" characters long"),void 0!==typeof t.minimum&&typeof e==typeof t.minimum&&t.minimum>e&&l("must have a minimum value of "+t.minimum),void 0!==typeof t.maximum&&typeof e==typeof t.maximum&&t.maximum<e&&l("must have a maximum value of "+t.maximum),t.enum){var u=t.enum;c=u.length;for(var h,d=0;d<c;d++)if(u[d]===e){h=1;break}h||l("does not have a value in the enumeration "+u.join(", "))}"number"==typeof t.maxDecimal&&e.toString().match(new RegExp("\\.[0-9]{"+(t.maxDecimal+1)+",}"))&&l("may only have "+t.maxDecimal+" digits of decimal places")}return null}function r(e,t,r,a){if("object"==typeof t){("object"!=typeof e||e instanceof Array)&&s.push({property:r,message:"an object is required"});for(var o in t)if(t.hasOwnProperty(o)&&("_"!=o.charAt(0)||"_"!=o.charAt(1))){var l=e[o],p=t[o];i(l,p,r,o)}}for(o in e){!e.hasOwnProperty(o)||"_"==o.charAt(0)&&"_"==o.charAt(1)||!t||t[o]||!1!==a||s.push({property:r,message:typeof l+"The property "+o+" is not defined in the schema and the schema does not allow additional properties"});var c=t&&t[o]&&t[o].requires;!c||c in e||s.push({property:r,message:"the presence of the property "+o+" requires that "+c+" also be present"}),l=e[o],!t||"object"!=typeof t||o in t||i(l,a,r,o),!n&&l&&l.$schema&&(s=s.concat(i(l,l.$schema,r,o)))}return s}var s=[];return t&&i(e,t,"",n||""),!n&&e&&e.$schema&&i(e,e.$schema,"",""),{valid:!s.length,errors:s}}}}),define("preview/ref",["../core/lib"],function(e){return{resolveJson:function(t,n){function i(f,m,g,v,y){var b,T,C=s in f?f[s]:g;void 0!==C&&(C=(a+C).replace(u,"$2$3"));var w=y||f;if(void 0!==C){if(o&&(f.__id=C),!n.schemas||f instanceof Array||!(T=C.match(/^(.+\/)[^\.\[]*$/))||(v=n.schemas[T[1]]),l[C]&&f instanceof Array==l[C]instanceof Array)w=l[C],delete w.$ref,b=!0;else{var x=v&&v.prototype;x&&(d.prototype=x,w=new d)}l[C]=w,p&&(p[C]=n.time)}var S=v&&v.properties,L=f.length;for(var R in f){if(R==L)break;if(f.hasOwnProperty(R)){T=f[R];var I=S&&S[R];if(I&&"date-time"==I.format&&"string"==typeof T)T=e.fromISOString(T);else if("object"==typeof T&&T&&!(T instanceof Date))if(r=T.$ref){delete f[R];var M=r.replace(/(#)([^\.\[])/,"$1.$2").match(/(^([^\[]*\/)?[^#\.\[]*)#?([\.\[].*)?/);if((r="$"==M[1]||"this"==M[1]||""==M[1]?t:l[(a+M[1]).replace(u,"$2$3")])&&M[3]&&M[3].replace(/(\[([^\]]+)\])|(\.?([^\.\[]+))/g,function(e,t,n,i,s){r=r&&r[n?n.replace(/[\"\'\\]/,""):s]}),r)T=r;else if(m)T=i(T,!1,T.$ref,I),T._loadObject=n.loader;else{var B;B||c.push(w),B=!0}}else m||(T=i(T,c==f,C&&h(C,R),I,w!=f&&"object"==typeof w[R]&&w[R]));if(f[R]=T,w!=f&&!w.__isDirty){var E=w[R];w[R]=T,!b||T===E||w._loadObject||T instanceof Date&&E instanceof Date&&T.getTime()==E.getTime()||"function"==typeof T&&"function"==typeof E&&T.toString()==E.toString()||!l.onUpdate||l.onUpdate(w,R,E,T)}}}if(b){for(R in w)if(!w.__isDirty&&w.hasOwnProperty(R)&&!f.hasOwnProperty(R)&&"__id"!=R&&"__clientId"!=R&&!(w instanceof Array&&isNaN(R)))for(l.onUpdate&&"_loadObject"!=R&&"_idAttr"!=R&&l.onUpdate(w,R,w[R],void 0),delete w[R];w instanceof Array&&w.length&&void 0===w[w.length-1];)w.length--}else l.onLoad&&l.onLoad(w);return w}n=n||{};var r,s=n.idAttribute||"id",a=n.idPrefix||"",o=n.assignAbsoluteIds,l=n.index||{},p=n.timeStamps,c=[],u=/^(.*\/)?(\w+:\/\/)|[^\/\.]+\/\.\.\/|^.*\/(\/)/,h=this._addProp,d=function(){};return t&&"object"==typeof t&&(t=i(t,!1,n.defaultId),i(c,!1)),t},_addProp:function(e,t){return e+(e.match(/#/)?1==e.length?"":".":"#")+t}}}),define("preview/harSchema",[],function(){function e(){}var t=/^(\d{4})(-)?(\d\d)(-)?(\d\d)(T)?(\d\d)(:)?(\d\d)(:)?(\d\d)(\.\d+)?(Z|([+-])(\d\d)(:)?(\d\d))/,n={logType:{id:"logType",description:"HTTP Archive structure.",type:"object",properties:{log:{type:"object",properties:{version:{type:"string"},creator:{$ref:"creatorType"},browser:{$ref:"browserType"},pages:{type:"array",optional:!0,items:{$ref:"pageType"}},entries:{type:"array",items:{$ref:"entryType"}},comment:{type:"string",optional:!0}}}}}},i={creatorType:{id:"creatorType",description:"Name and version info of the log creator app.",type:"object",properties:{name:{type:"string"},version:{type:"string"},comment:{type:"string",optional:!0}}}},r={browserType:{id:"browserType",description:"Name and version info of used browser.",type:"object",optional:!0,properties:{name:{type:"string"},version:{type:"string"},comment:{type:"string",optional:!0}}}},s={pageType:{id:"pageType",description:"Exported web page",optional:!0,properties:{startedDateTime:{type:"string",format:"date-time",pattern:t},id:{type:"string",unique:!0},title:{type:"string"},pageTimings:{$ref:"pageTimingsType"},comment:{type:"string",optional:!0}}}},a={pageTimingsType:{id:"pageTimingsType",description:"Timing info about page load",properties:{onContentLoad:{type:"number",optional:!0,min:-1},onLoad:{type:"number",optional:!0,min:-1},comment:{type:"string",optional:!0}}}},o={entryType:{id:"entryType",description:"Request and Response related info",optional:!0,properties:{pageref:{type:"string",optional:!0},startedDateTime:{type:"string",format:"date-time",pattern:t},time:{type:"number",min:0},request:{$ref:"requestType"},response:{$ref:"responseType"},cache:{$ref:"cacheType"},timings:{$ref:"timingsType"},serverIPAddress:{type:"string",optional:!0},connection:{type:"string",optional:!0},comment:{type:"string",optional:!0}}}},l={requestType:{id:"requestType",description:"Monitored request",properties:{method:{type:"string"},url:{type:"string"},httpVersion:{type:"string"},cookies:{type:"array",items:{$ref:"cookieType"}},headers:{type:"array",items:{$ref:"recordType"}},queryString:{type:"array",items:{$ref:"recordType"}},postData:{$ref:"postDataType"},headersSize:{type:"integer"},bodySize:{type:"integer"},comment:{type:"string",optional:!0}}}},p={recordType:{id:"recordType",description:"Helper name-value pair structure.",properties:{name:{type:"string"},value:{type:"string"},comment:{type:"string",optional:!0}}}},c={responseType:{id:"responseType",description:"Monitored Response.",properties:{status:{type:"integer"},statusText:{type:"string"},httpVersion:{type:"string"},cookies:{type:"array",items:{$ref:"cookieType"}},headers:{type:"array",items:{$ref:"recordType"}},content:{$ref:"contentType"},redirectURL:{type:"string"},headersSize:{type:"integer"},bodySize:{type:"integer"},comment:{type:"string",optional:!0}}}},u={postDataType:{id:"postDataType",description:"Posted data info.",optional:!0,properties:{mimeType:{type:"string"},text:{type:"string",optional:!0},params:{type:"array",optional:!0,properties:{name:{type:"string"},value:{type:"string",optional:!0},fileName:{type:"string",optional:!0},contentType:{type:"string",optional:!0},comment:{type:"string",optional:!0}}},comment:{type:"string",optional:!0}}}},h={contentType:{id:"contentType",description:"Response content",properties:{size:{type:"integer"},compression:{type:"integer",optional:!0},mimeType:{type:"string"},text:{type:"string",optional:!0},encoding:{type:"string",optional:!0},comment:{type:"string",optional:!0}}}},d={cacheType:{id:"cacheType",description:"Info about a response coming from the cache.",properties:{beforeRequest:{$ref:"cacheEntryType"},afterRequest:{$ref:"cacheEntryType"},comment:{type:"string",optional:!0}}}},f={cacheEntryType:{id:"cacheEntryType",optional:!0,description:"Info about cache entry.",properties:{expires:{type:"string",optional:"true"},lastAccess:{type:"string"},eTag:{type:"string"},hitCount:{type:"integer"},comment:{type:"string",optional:!0}}}},m={timingsType:{id:"timingsType",description:"Info about request-response timing.",properties:{dns:{type:"number",optional:!0,min:-1},connect:{type:"number",optional:!0,min:-1},blocked:{type:"number",optional:!0,min:-1},send:{type:"number",min:-1},wait:{type:"number",min:-1},receive:{type:"number",min:-1},ssl:{type:"number",optional:!0,min:-1},comment:{type:"string",optional:!0}}}};e.prototype={registerType:function(){for(var e=this,t=0;t<arguments.length;t+=1)!function(e,t){for(var n in t)t.hasOwnProperty(n)&&"prototype"!==n&&(e[n]=t[n])}(e,arguments[t])}};var g=new e;return g.registerType(n,i,r,s,a,o,l,p,c,u,h,d,f,m),g}),define("core/cookies",["./string"],function(e){function t(){var e=window.location.pathname;if(!window.location.pathname.match(/\/$/)){var t=e.split("/");t.length-=1,e=t.join("/")+"/"}return e}return{getCookie:function(t){for(var n=document.cookie.split(";"),i=0;i<n.length;i++){var r=n[i].split("=");if(e.trim(r[0])===t)return r[1].length?unescape(e.trim(r[1])):null}},setCookie:function(e,n,i,r,s,a){var o=new Date;o.setTime(o.getTime()),i&&(i=1e3*i*60*60*24),r="string"==typeof r?r:t();var l=new Date(o.getTime()+i);document.cookie=e+"="+escape(n)+(i?";expires="+l.toGMTString():"")+(r?";path="+r:"")+(s?";domain="+s:"")+(a?";secure":"")},removeCookie:function(e,n,i){this.getCookie(e)&&(n="string"==typeof n?n:t(),document.cookie=e+"="+(n?";path="+n:"")+(i?";domain="+i:"")+";expires=Thu, 01-Jan-1970 00:00:01 GMT")},toggleCookie:function(e){var t=this.getBooleanCookie(e);this.setCookie(e,!t)},getBooleanCookie:function(e){var t=this.getCookie(e);return!(!t||"false"===t)},setBooleanCookie:function(e,t){this.setCookie(e,t?"true":"false")}}}),define("nls/harModel",{root:{validationType:"HAR Validation",validationSumTimeError:"Sum of request timings doesn't correspond to the total value: %S (request.time: %S vs. sum: %S), request#: %S, parent page: %S",validationNegativeTimeError:"Negative time is not allowed: %S, request#: %S, parent page: %S"}}),define("preview/harModel",["../core/lib","./jsonSchema","./ref","./harSchema","../core/cookies","../core/trace","i18n!../nls/harModel"],function(e,t,n,i,r,s,a){function o(){this.input=null}function l(e,t){return"number"==typeof e?e:"number"==typeof t?t:-1}function p(){var e={};for(var t in this)"toJSON"!==t&&(e[t]=this[t]);return this.text?(e.text=Array.prototype.map.call(this.text,function(e){var t=e.charCodeAt(0);if(t>=32&&t<127||10===t||13===t)return e.charAt(0);for(var n=t.toString(16).toUpperCase();n.length<4;)n="0"+n;return"\\u"+n}).join(""),e):e}return o.prototype={append:function(t){function n(t){t.sort(function(t,n){return e.parseISO8601(t.startedDateTime)-e.parseISO8601(n.startedDateTime)})}if(!t)return void s.error("HarModel.append; Trying to append null input!");if(t.log.pages&&n(t.log.pages),t.log.entries&&n(t.log.entries),this.input){if(!t.log.pages)return s.error("Import of additional data without a page is not yet supported."),null;for(var i=0;i<t.log.pages.length;i++)this.importPage(t.log.pages[i],t.log.entries)}else this.input=e.cloneJSON(t);return this.input},getPages:function(){return this.input&&this.input.log.pages?this.input.log.pages:[]},getFirstPage:function(){var e=this.getPages();return e.length>0?e[0]:null},getPageEntries:function(e){return o.getPageEntries(this.input,e)},getAllEntries:function(e){return this.input?this.input.log.entries:[]},getParentPage:function(e){return o.getParentPage(this.input,e)},importPage:function(e,t){var n=this.getUniquePageID(e.id),i=e.id;e.id=n,this.input.log.pages.push(e);for(var r=0;r<t.length;r++){var s=t[r];s.pageref===i&&(s.pageref=n,this.input.log.entries.push(s))}},getUniquePageID:function(e){for(var t=this.input.log.pages,n={},i=0;i<t.length;i++)n[t[i].id]=!0;if(!n[e])return e;for(var r=1;;){var s=e+r;if(!n[s])return s;r++}},toJSON:function(e){if(e||(e=this.input),!e)return"";for(var t=this.input.log.entries,n=0;n<t.length;n++){var i=t[n];i.response.content.text&&(i.response.content.toJSON=p)}return JSON.stringify(this.input,null,"\t").replace(/\\\\u/g,"\\u")}},o.parse=function(e,r){var a=e;try{"string"==typeof e&&(a=jQuery.parseJSON(e))}catch(e){throw s.exception("HarModel.parse; EXCEPTION",e),{errors:[{message:"Failed to parse JSON",property:"JSON evaluation"}]}}if(!r)return a;var o=n.resolveJson(i),l=t.validate(a,o.logType);if(l.valid)return this.validateRequestTimings(a),a;throw l},o.getPageEntries=function(e,t){var n=[],i=e.log.entries;if(!i)return n;for(var r=0;r<i.length;r++){var s=i[r];s.pageref||t||n.push(s),t&&s.pageref===t.id&&n.push(s)}return n},o.getParentPage=function(e,t){var n=e.log.pages;if(!n)return null;for(var i=0;i<n.length;i++)if(n[i].id===t.pageref)return n[i];return null},o.validateRequestTimings=function(t){for(var n=[],i=t.log.entries,r=0;r<i.length;r++){var s=i[r],o=s.timings;if(o.blocked<-1||o.connect<-1||o.dns<-1||o.receive<-1||o.send<-1||o.wait<-1){var l=e.formatString(a.validationNegativeTimeError,s.request.url,r,s.pageref);n.push({input:t,file:s,message:l,property:a.validationType})}}if(n.length)throw{errors:n,input:t}},o.isCachedEntry=function(e){return 304===e.response.status||!(l(e.response._transferSize)>0)&&(0===Math.max(0,e.response.bodySize)&&e.response.content&&e.response.content.size>0)},o.getEntrySize=function(e){return o.getEntryTransferredSize(e)},o.getEntryUncompressedSize=function(e){var t=l(e.response.content.size);if(t>-1)return t;var n=l(e.response._transferSize);if(n>-1)return n;var i=l(e.response.bodySize);return i>-1?i:-1},o.getEntryTransferredSize=function(e){var t=l(e.response._transferSize);if(t>-1)return t;var n=l(e.response.bodySize);return n>-1?n:-1},o}),define("nls/requestBody",{root:{RequestVersion:"Request Version",ResponseVersion:"Response Version",RequestHeaders:"Request Headers",ResponseHeaders:"Response Headers",RequestCookies:"Request Cookies",ResponseCookies:"Response Cookies",URLParameters:"Params",Headers:"Headers",Post:"Post",Put:"Put",Get:"Get",Cookies:"Cookies",Response:"Response",Highlighted:"Highlighted",Image:"Img (from HAR)",ImageTitle:"Uses image payload data from the HAR",ExternalImage:"Img (from URL)",ExternalImageTitle:"Creates an IMG tag whose src is the request URL",Cache:"Cache",HTML:"HTML",JSON:"JSON",XML:"XML",DataURL:"Data URL"}}),define("domplate/tabView",["../domplate/domplate","../core/lib","../core/trace"],function(e,t,n){function i(e){this.id=e,this.tabs=[],this.listeners=[],this.tabBarVisibility=!0}var r=e.domplate,s=e.A,a=e.DIV,o=e.TABLE,l=e.TAG,p=e.TBODY,c=e.TD,u=e.TR,h=r({tag:o({class:"tabView",cellpadding:0,cellspacing:0,_repObject:"$tabView"},p(u({class:"tabViewRow"},c({class:"tabViewCol",valign:"top"},l("$tabList",{tabView:"$tabView"}))))),tabList:a({class:"tabViewBody",onclick:"$onClickTab"},a({class:"$tabView.id\\Bar tabBar"}),a({class:"$tabView.id\\Bodies tabBodies"})),tabHeaderTag:s({class:"$tab.id\\Tab tab",title:"$tab|getTitle",view:"$tab.id",_repObject:"$tab"},"$tab.label"),tabBodyTag:a({class:"tab$tab.id\\Body tabBody",_repObject:"$tab"}),hideTab:function(e){return!1},onClickTab:function(e){var n=t.fixEvent(e);this.getTabView(n.target).onClickTab(n)},getTabView:function(e){return t.getAncestorByClass(e,"tabView").repObject},getTitle:function(e){return e.title||""}});return i.prototype={appendTab:function(e){return this.tabs.push(e),e.tabView=this,e},removeTab:function(e){for(var t=0;t<this.tabs.length;t++){if(this.tabs[t].id===e){this.tabs.splice(t,1);break}}},getTab:function(e){for(var t=0;t<this.tabs.length;t++){var n=this.tabs[t];if(n.id===e)return n}},selectTabByName:function(e){var n=t.getElementByClass(this.element,e+"Tab");n&&this.selectTab(n)},showTabBar:function(e){this.element?e?this.element.removeAttribute("hideTabBar"):this.element.setAttribute("hideTabBar","true"):this.tabBarVisibility=e},addListener:function(e){this.listeners.push(e)},removeListener:function(e){t.remove(this.listeners,e)},onClickTab:function(e){var n=t.getAncestorByClass(e.target,"tab");n&&this.selectTab(n)},selectTab:function(e){if(t.hasClass(e,"tab")&&(!t.hasClass(e,"selected")||!e._updated)){var i=e.getAttribute("view");if(i){var r=t.getAncestorByClass(e,"tabViewBody");r.selectedTab&&(r.selectedTab.removeAttribute("selected"),r.selectedBody.removeAttribute("selected"),t.removeClass(r.selectedTab,"selected"),t.removeClass(r.selectedBody,"selected"));var s=t.getElementByClass(r,"tab"+i+"Body");s||n.error("TabView.selectTab; Missing tab body",e),r.selectedTab=e,r.selectedBody=s,r.selectedTab.setAttribute("selected","true"),r.selectedBody.setAttribute("selected","true"),t.setClass(r.selectedBody,"selected"),t.setClass(r.selectedTab,"selected"),this.updateTabBody(r,i)}}},updateTabBody:function(e,t){var n=e.selectedTab.repObject;if(!n._body._updated){n._body._updated=!0,n.bodyTag&&n.bodyTag.replace({tab:n},n._body),n&&n.onUpdateBody&&n.onUpdateBody(this,n._body);for(var i=0;i<this.listeners.length;i++){var r=this.listeners[i];r.onUpdateBody&&r.onUpdateBody(this,n._body)}}},render:function(e){this.element=h.tag.replace({tabView:this},e,h),t.setClass(this.element,this.id),this.showTabBar(this.tabBarVisibility);for(var i=0;i<this.tabs.length;i++){var r=this.tabs[i],s=r.tabHeaderTag?r.tabHeaderTag:h.tabHeaderTag,a=r.tabBodyTag?r.tabBodyTag:h.tabBodyTag;try{r._header=s.append({tab:r},t.$(e,"tabBar")),r._body=a.append({tab:r},t.$(e,"tabBodies"))}catch(e){n.exception("TabView.appendTab; Exception ",e)}}return this.element}},i.Tab=function(){},i.Tab.prototype={invalidate:function(){this._updated=!1},select:function(){this.tabView.selectTabByName(this.id)}},i}),define("domplate/domTree",["./domplate","../core/lib","../core/trace"],function(e,t,n){function i(e){this.input=e}function r(e){if("string"==typeof e)return!1;try{for(var t in e)return!0}catch(e){}return!1}function s(e){this.input=e}function a(e){this.input=e}function o(e){try{return e.toString()}catch(e){return""}}function l(e){var t=o(e),n=/\[object (.*?)\]/,i=n.exec(t);return i?i[1]:t}var p=e.domplate,c=e.DIV,u=e.FOR,h=e.SPAN,d=e.TABLE,f=e.TAG,m=e.TBODY,g=e.TD,v=e.TR;i.prototype=p({tag:d({class:"domTable",cellpadding:0,cellspacing:0,onclick:"$onClick"},m(u("member","$object|memberIterator",f("$member|getRowTag",{member:"$member"})))),rowTag:v({class:"memberRow $member.open $member.type\\Row $member|hasChildren",$hasChildren:"$member|hasChildren",_repObject:"$member",level:"$member.level"},g({class:"memberLabelCell",style:"padding-left: $member.indent\\px"},h({class:"memberLabel $member.type\\Label"},"$member.name")),g({class:"memberValueCell"},f("$member.tag",{object:"$member|getValue"}))),loop:u("member","$members",f("$member|getRowTag",{member:"$member"})),hasChildren:function(e){return e.hasChildren?"hasChildren":""},memberIterator:function(e){return($.isXMLDoc(e)?new a(e):new s(e)).getMembers(e)},getValue:function(e){return e.value},getRowTag:function(e){return this.rowTag},onClick:function(e){var n=t.fixEvent(e);if(t.isLeftClick(n)){var i=t.getAncestorByClass(n.target,"memberRow");t.getAncestorByClass(n.target,"memberLabel")&&t.hasClass(i,"hasChildren")&&this.toggleRow(i)}},toggleRow:function(e,n){if(e){var i=parseInt(e.getAttribute("level"),10);if(!n||!t.hasClass(e,"opened"))if(t.hasClass(e,"opened")){t.removeClass(e,"opened");for(var r=e.parentNode,o=e.nextSibling;o&&!(parseInt(o.getAttribute("level"),10)<=i);o=e.nextSibling)r.removeChild(o)}else{t.setClass(e,"opened");var l=e.repObject;if(l){if(!l.hasChildren)return;var p=$.isXMLDoc(l.value)?new a(l.value):new s(l.value),c=p.getMembers(l.value,i+1);c&&this.loop.insertRows({members:c},e)}}}},append:function(e){this.element=this.tag.append({object:this.input},e,this),this.element.repObject=this;var n=t.isArray(this.input)&&this.input.length>2,i=this.element.firstChild.firstChild;i&&!n&&this.toggleRow(i)},expandRow:function(e){var t=this.getRow(e);return this.toggleRow(t,!0),t},getRow:function(e){if(this.element){for(var n=t.getElementsByClass(this.element,"memberRow"),i=0;i<n.length;i++){var r=n[i];if(r.repObject.value===e)return r}return null}}}),i.createMember=function(e,t,n,r,s){return{name:t,value:n,type:e,rowClass:"memberRow-"+e,open:"",level:s,indent:16*s,hasChildren:r,tag:i.Reps.getRep(n).tag}};var y=c({class:"objectBox objectBox-$className"});s.prototype.getMembers=function(e,t){t||(t=0);var n=[];for(var r in e){var s=e[r];"function"!=typeof s&&n.push(i.createMember("dom",r,s,this.hasChildren(s),t))}return n},s.prototype.hasChildren=function(e){return r(e)&&"object"==typeof e},a.prototype.getMembers=function(e,t){t||(t=0);var n=a.nodeAttributes(e).map(function(e){return i.createMember("dom","@"+e.name,e.value,!1,t)}),r=a.nodeChildElements(e).map(function(e){var n=this.hasChildren(e);return i.createMember("dom",e.tagName,n?e:e.firstChild.nodeValue,n,t)},this),s=n;return 0===r.length&&e.firstChild&&s.push(i.createMember("dom","value",e.firstChild.nodeValue,!1,t)),s.concat(r)},a.prototype.hasChildren=function(e){return a.hasChildren(e)},a.hasChildren=function(e){var t=a.nodeAttributes(e),n=a.nodeChildElements(e);return t.length>0||n.length>0},a.nodeChildElements=function(e,t){t="number"===t?t:null;for(var n=[],i=e.firstChild;i;){if(Node.ELEMENT_NODE===i.nodeType&&(n.push(i),null!==t&&n.length>=t))return n;i=i.nextSibling}return n},a.nodeAttributes=function(e,t){t="number"===t?t:null;var n=[];if(!e.attributes)return n;for(var i=e.attributes.length;--i>=0;)if(n.push(e.attributes[i]),null!==t&&n.length>=t)return n;return n},i.Reps={reps:[],registerRep:function(){this.reps.push.apply(this.reps,arguments)},getRep:function(e){var t=typeof e;"object"===t&&e instanceof String&&(t="string");for(var r=0;r<this.reps.length;++r){var s=this.reps[r];try{if(s.supportsObject(e,t))return s}catch(e){n.exception("domTree.getRep; ",e)}}return i.Rep}},i.Rep=p({tag:y("$object|getTitle"),className:"object",getTitle:function(e){return l(e)},getTooltip:function(e){return null},supportsObject:function(e,t){return!1}}),i.Reps.Null=p(i.Rep,{tag:y("null"),className:"null",supportsObject:function(e,t){return null===e}}),i.Reps.Number=p(i.Rep,{tag:y("$object"),className:"number",supportsObject:function(e,t){return"boolean"===t||"number"===t}}),i.Reps.String=p(i.Rep,{tag:y("$object"),className:"string",supportsObject:function(e,t){return"string"===t}}),i.Reps.Arr=p(i.Rep,{tag:y("$object|getTitle"),className:"array",supportsObject:function(e,n){return t.isArray(e)},getTitle:function(e){return"Array ["+e.length+"]"}});var b=p(i.prototype,{createMember:function(e,t,n,r){var s=i.createMember(e,t,n,!1,r);return 0===r&&(s.name="",s.type="tableCell"),s}});return i.Reps.Tree=p(i.Rep,{tag:y(f("$object|getTag",{object:"$object|getRoot"})),className:"tree",getTag:function(e){return b.tag},getRoot:function(e){return[e]},supportsObject:function(e,t){return"object"===t}}),i.Reps.registerRep(i.Reps.Null,i.Reps.Number,i.Reps.String,i.Reps.Arr),i}),define("core/dragdrop",["./object","./events"],function(e,t){function n(n,i){this.element=n,this.handle=n,this.callbacks=i,this.cursorStartPos=null,this.cursorLastPos=null,this.dragging=!1,this.onDragStart=e.bind(this.onDragStart,this),this.onDragOver=e.bind(this.onDragOver,this),this.onDrop=e.bind(this.onDrop,this),t.addEventListener(this.element,"mousedown",this.onDragStart,!1),this.active=!0}function i(e,t){this.x=e,this.y=t,this.Add=function(e){var t=new i(this.x,this.y);return null!==e&&void 0!==e&&(isNaN(e.x)||(t.x+=e.x),isNaN(e.y)||(t.y+=e.y)),t},this.Subtract=function(e){var t=new i(this.x,this.y);return null!==e&&void 0!==e&&(isNaN(e.x)||(t.x-=e.x),isNaN(e.y)||(t.y-=e.y)),t},this.Bound=function(e,t){return this.Max(e).Min(t)},this.Check=function(){var e=new i(this.x,this.y);return isNaN(e.x)&&(e.x=0),isNaN(e.y)&&(e.y=0),e},this.Apply=function(e){"string"==typeof e&&(e=document.getElementById(e)),e&&(isNaN(this.x)||(e.style.left=this.x+"px"),isNaN(this.y)||(e.style.top=this.y+"px"))}}function r(e){return isNaN(window.scrollX)?new i(e.clientX+document.documentElement.scrollLeft+document.body.scrollLeft,e.clientY+document.documentElement.scrollTop+document.body.scrollTop):new i(e.clientX+window.scrollX,e.clientY+window.scrollY)}var s={onDragStart:function(e){var n=t.fixEvent(e);this.dragging||(this.callbacks.onDragStart&&this.callbacks.onDragStart(this),this.dragging=!0,this.cursorStartPos=r(n),this.cursorLastPos=this.cursorStartPos,t.addEventListener(this.element.ownerDocument,"mousemove",this.onDragOver,!1),t.addEventListener(this.element.ownerDocument,"mouseup",this.onDrop,!1),t.cancelEvent(n))},onDragOver:function(e){if(this.dragging){var n=t.fixEvent(e);t.cancelEvent(n);var i=r(n);i=i.Subtract(this.cursorStartPos),this.cursorLastPos.x===i.x&&this.cursorLastPos.y===i.y||"function"==typeof this.callbacks.onDragOver&&(this.callbacks.onDragOver(i,this),this.cursorLastPos=i)}},onDrop:function(e){if(this.dragging){var n=t.fixEvent(e);t.cancelEvent(n),this.dragStop()}},dragStop:function(){this.dragging&&(t.removeEventListener(this.element.ownerDocument,"mousemove",this.onDragOver,!1),t.removeEventListener(this.element.ownerDocument,"mouseup",this.onDrop,!1),this.cursorStartPos=null,this.cursorLastPos=null,null!==this.callbacks.onDrop&&this.callbacks.onDrop(this),this.dragging=!1)},destroy:function(){t.removeEventListener(this.element,"mousedown",this.onDragStart,!1),this.active=!1,this.dragging&&this.dragStop()}};n.prototype=s;var a={};return a.Tracker=n,a}),define("preview/requestBody",["../domplate/domplate","i18n!../nls/requestBody","../core/lib","../core/cookies","../domplate/tabView","../domplate/domTree","../core/dragdrop"],function(e,t,n,i,r,s,a){function o(){}function l(e){this.file=e}function p(e){this.file=e}function c(e){this.file=e}function u(e){this.file=e}function h(e){this.file=e}function d(e){this.file=e}function f(e){var n=e.request.method;n=n.charAt(0).toUpperCase()+n.slice(1).toLowerCase(),this.file=e,this.id=n,this.label=t[n]}function m(e){this.file=e}function g(e){this.file=e}function v(e){this.file=e}function y(e){this.file=e}function b(e){this.file=e}function T(e){this.file=e}var C=e.domplate,w=e.A,x=e.CODE,S=e.DIV,L=e.FOR,R=e.IFRAME,I=e.PRE,M=e.TABLE,B=e.TBODY,E=e.TD,k=e.TR;return o.tabTypes=[l,d,f,u,h,b,T,p,c,g,v,y],o.prototype=C({render:function(e,t){var n=new r("requestBody");o.tabTypes.forEach(function(e){e.canShowFile(t)&&n.appendTab(new e(t))});var i=n.render(e);return n.tabs.length>0&&n.selectTabByName(n.tabs[0].id),i}}),o.canShowFile=function(e){return o.tabTypes.some(function(t){return t.canShowFile(e)})},o.canDecode=function(e){return!e||"base64"===e&&"undefined"!=typeof atob},o.decode=function(e,t){return"base64"===t?atob(e):e},l.prototype=C(r.Tab.prototype,{id:"Headers",label:t.Headers,bodyTag:S(S(w({class:"netInfoRequestURL"})),M({class:"netInfoHeadersText netInfoText netInfoHeadersTable",cellpadding:0,cellspacing:0},B(k({class:"netInfoResponseVersionTitle"},E({colspan:2},S({class:"netInfoHeadersGroup"},t.ResponseVersion))),k({class:"netInfoResponseHeadersTitle"},E({colspan:2},S({class:"netInfoHeadersGroup"},t.ResponseHeaders))),k({class:"netInfoRequestVersionTitle"},E({colspan:2},S({class:"netInfoHeadersGroup"},t.RequestVersion))),k({class:"netInfoRequestHeadersTitle"},E({colspan:2},S({class:"netInfoHeadersGroup"},t.RequestHeaders)))))),headerDataTag:L("param","$headers",k(E({class:"netInfoParamName"},"$param.name"),E({class:"netInfoParamValue"},I("$param|getParamValue")))),getParamValue:function(e){return n.wrapText(e.value,!0)},onUpdateBody:function(e,t){var i=this.file.request.url;if(i){var r=$(t).find("a")[0];r.setAttribute("href",i),r.appendChild(document.createTextNode(n.cropString(i,128)))}var s={name:"",value:this.file.response.httpVersion};this.insertHeaderRows(t,[s],"Headers","ResponseVersion"),this.insertHeaderRows(t,this.file.response.headers||[],"Headers","ResponseHeaders");var a={name:"",value:this.file.request.httpVersion};this.insertHeaderRows(t,[a],"Headers","RequestVersion"),this.insertHeaderRows(t,this.file.request.headers||[],"Headers","RequestHeaders")},insertHeaderRows:function(e,t,i,r){var s=n.getElementByClass(e,"netInfo"+i+"Table"),a=n.getElementByClass(s,"netInfo"+r+"Title");t.length?(this.headerDataTag.insertRows({headers:t},a||e),n.removeClass(a,"collapsed")):n.setClass(a,"collapsed")}}),l.canShowFile=function(e){return!0},p.prototype=C(r.Tab.prototype,{id:"Image",label:t.Image,title:t.ImageTitle,bodyTag:S({class:"netInfoImageText netInfoText"}),onUpdateBody:function(e,t){function i(e){return"data:"+n.extractMimeType(e.mimeType)+";base64,"+e.text}var r=n.getElementByClass(t,"netInfoImageText");n.clearNode(r);var s=9===document.documentMode,a=10===document.documentMode;s||a?function(e,t){var n=e.response.content,r=/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/;if(n.text.match(r)){var s=i(n);t.innerHTML="<img src="+s+">"}}(this.file,r):function(e,n){var r=t.ownerDocument.createElement("img"),s=e.response.content;r.src=i(s),n.appendChild(r)}(this.file,r)}}),p.isFileImage=function(e){var t=e.response.content;if(!t)return!1;var i=n.extractMimeType(t.mimeType||"");return n.startsWith(i,"image/")},p.canShowFile=function(e){var t=e.response.content;return p.isFileImage(e)&&t.text&&"base64"===t.encoding},c.prototype=C(r.Tab.prototype,{id:"ExternalImage",label:t.ExternalImage,title:t.ExternalImageTitle,bodyTag:S({class:"netInfoExternalImageText netInfoText"}),onUpdateBody:function(e,t){var i=n.getElementByClass(t,"netInfoExternalImageText");n.clearNode(i);var r=t.ownerDocument.createElement("img");r.src=this.file.request.url,i.appendChild(r)}}),c.canShowFile=function(e){return p.isFileImage(e)},u.prototype=C(r.Tab.prototype,{id:"Response",label:t.Response,bodyTag:S({class:"netInfoResponseText netInfoText"},I()),onUpdateBody:function(e,t){var i=n.getElementByClass(t,"netInfoResponseText"),r=i.firstChild;n.clearNode(r);var s=this.file.response.content.text;n.insertWrappedText(s,r)}}),u.canShowFile=function(e){return e.response.content.text&&e.response.content.text.length>0},h.prototype=C(r.Tab.prototype,{id:"Highlighted",label:t.Highlighted,bodyTag:S({class:"netInfoHighlightedText netInfoText"},I(x("class","javascript"))),onUpdateBody:function(e,t){var i=n.getElementByClass(t,"netInfoHighlightedText"),r=i.firstChild.firstChild;n.clearNode(r);var s=this.file.response.content,a=s.text,l=n.extractMimeType(s.mimeType),p=h.shouldHighlightAs(l);if(p){r.className=p,a=o.decode(a,s.encoding),r.appendChild(document.createTextNode(a)),hljs.highlightBlock(r);var c=r;r.classList.contains("hljs")&&c.setAttribute("highlighted",!0)}else n.insertWrappedText(a,pre)}}),h.canShowFile=function(e){var t=e.response.content;if(!t||!t.text)return!1;if(!o.canDecode(t.encoding))return!1;var i=n.extractMimeType(t.mimeType||"");return null!==h.shouldHighlightAs(i)},h.shouldHighlightAs=function(e){var t={javascript:["application/javascript","text/javascript","application/x-javascript","text/ecmascript","application/ecmascript","application/json"],css:["text/css"],
html:["text/html","application/xhtml+xml"]};for(var n in t)if(t[n].indexOf(e)>-1)return n;return T.isXmlMimeType(e)?"xml":null},d.prototype=C(l.prototype,{id:"Params",label:t.URLParameters,bodyTag:M({class:"netInfoParamsText netInfoText netInfoParamsTable",cellpadding:0,cellspacing:0},B()),onUpdateBody:function(e,t){if(this.file.request.queryString){var i=n.getElementByClass(t,"netInfoParamsText");this.insertHeaderRows(i,this.file.request.queryString,"Params")}}}),d.canShowFile=function(e){return e.request.queryString&&e.request.queryString.length},f.prototype=C(l.prototype,{bodyTag:S({class:"netInfo$tab.id\\Text netInfoText"},M({class:"netInfo$tab.id\\Table",cellpadding:0,cellspacing:0},B())),onUpdateBody:function(e,t){var i=this.file.request.postData;if(i){var r=n.getElementByClass(t,"netInfo"+this.id+"Text");n.isArray(i.params)&&"application/x-www-form-urlencoded"===i.mimeType?this.insertHeaderRows(r,i.params,this.id):n.insertWrappedText(i.text,r)}}}),f.canShowFile=function(e){var t=e.request.postData;if(!t)return!1;var i=!n.isArray(t.params)||0===t.params.length,r=!t.text;return!(i&&r)||["PUT","POST"].indexOf(e.request.method)>-1},m.prototype=C(l.prototype,{id:"Cookies",label:t.Cookies,bodyTag:S({class:"netInfoCookiesText netInfoText"},M({class:"netInfoCookiesTable",cellpadding:0,cellspacing:0},B(k({class:"netInfoResponseCookiesTitle"},E({colspan:2},S({class:"netInfoCookiesGroup"},t.ResponseCookies))),k({class:"netInfoRequestCookiesTitle"},E({colspan:2},S({class:"netInfoCookiesGroup"},t.RequestCookies)))))),onUpdateBody:function(e,t){var i=n.getElementByClass(t,"netInfoParamsText"),r=this.file;r.response.cookies&&this.insertHeaderRows(i,r.response.cookies,"Cookies","ResponseCookies"),r.request.cookies&&this.insertHeaderRows(i,r.request.cookies,"Cookies","RequestCookies")}}),g.prototype=C(l.prototype,{id:"Cache",label:t.Cache,bodyTag:S({class:"netInfoCacheText netInfoText"},M({class:"netInfoCacheTable",cellpadding:0,cellspacing:0},B())),onUpdateBody:function(e,t){if(this.file.cache&&this.file.cache.afterRequest){var n=this.file.cache.afterRequest,i=[];for(var r in n)i.push({name:r,value:n[r]});this.insertHeaderRows(t,i,"Cache")}}}),g.canShowFile=function(e){return!!e.cache&&!!e.cache.afterRequest},v.prototype=C(r.Tab.prototype,{id:"HTML",label:t.HTML,bodyTag:S({class:"netInfoHtmlText netInfoText"},R({class:"netInfoHtmlPreview",onload:"$onLoad"}),S({class:"htmlPreviewResizer"})),onUpdateBody:function(e,t){this.preview=n.getElementByClass(t,"netInfoHtmlPreview");var r=parseInt(i.getCookie("htmlPreviewHeight"),10);isNaN(r)||(this.preview.style.height=r+"px");var s=n.getElementByClass(t,"htmlPreviewResizer");this.resizer=new a.Tracker(s,{onDragStart:n.bind(this.onDragStart,this),onDragOver:n.bind(this.onDragOver,this),onDrop:n.bind(this.onDrop,this)})},onLoad:function(e){var t=n.fixEvent(e),i=n.getAncestorByClass(t.target,"tabHTMLBody").repObject;i.preview.contentWindow.document.body.innerHTML=i.file.response.content.text},onDragStart:function(e){n.getBody(this.preview.ownerDocument).setAttribute("hResizing","true"),this.startHeight=this.preview.clientHeight},onDragOver:function(e,t){var n=this.startHeight+e.y;this.preview.style.height=n+"px",i.setCookie("htmlPreviewHeight",n)},onDrop:function(e){n.getBody(this.preview.ownerDocument).removeAttribute("hResizing")}}),v.canShowFile=function(e){var t=e.response.content;if(!t||!t.text)return!1;var i=t.mimeType||"",r=e.mimeType||"";return n.startsWith(i,"text/html")||n.startsWith(r,"application/xhtml+xml")},y.prototype=C(r.Tab.prototype,{id:"DataURL",label:t.DataURL,bodyTag:S({class:"netInfoDataURLText netInfoText"}),onUpdateBody:function(e,t){var i=n.getElementByClass(t,"netInfoDataURLText"),r=this.file.request.url;if(0===r.indexOf("data:image")){var s=t.ownerDocument.createElement("img");s.src=r,i.appendChild(s)}else n.insertWrappedText(unescape(r),i)}}),y.canShowFile=function(e){return 0===e.request.url.indexOf("data:")},b.prototype=C(r.Tab.prototype,{id:"JSON",label:t.JSON,bodyTag:S({class:"netInfoJsonText netInfoText"}),onUpdateBody:function(e,t){n.clearNode(t.firstChild);var i=this.file.response.content;try{var r=o.decode(i.text,i.encoding),a=JSON.parse(r);new s(a).append(t)}catch(e){t.innerHTML=String(e)}}}),b.canShowFile=function(e){var t=e.response.content;return!(!t||!t.text)&&(!!o.canDecode(t.encoding)&&["application/json"].indexOf(n.extractMimeType(t.mimeType||""))>-1)},T.prototype=C(r.Tab.prototype,{id:"XML",label:t.XML,bodyTag:S({class:"netInfoXmlText netInfoText"}),onUpdateBody:function(e,t){n.clearNode(t.firstChild);var i=this.file.response.content;try{var r=o.decode(i.text,i.encoding),a=$.parseXML(r);new s(a).append(t)}catch(e){t.innerHTML=String(e)}}}),T.isXmlMimeType=function(e){return e=n.extractMimeType(e),["text/xml","application/xml","image/svg+xml","application/atom+xml","application/xslt+xml","application/mathml+xml","application/rss+xml"].indexOf(e)>-1},T.canShowFile=function(e){var t=e.response.content;if(!t||!t.text)return!1;if(!o.canDecode(t.encoding))return!1;var i=n.extractMimeType(t.mimeType||"");return T.isXmlMimeType(i)},o}),define("domplate/infoTip",["./domplate","../core/lib","../core/trace"],function(e,t,n){var i=e.domplate,r=e.DIV,s=t.extend({listeners:[],maxWidth:100,maxHeight:80,infoTipMargin:10,infoTipWindowPadding:25,tags:i({infoTipTag:r({class:"infoTip"})}),initialize:function(){var e=$("body");return e.bind("mouseover",t.bind(this.onMouseMove,this)),e.bind("mouseout",t.bind(this.onMouseOut,this)),e.bind("mousemove",t.bind(this.onMouseMove,this)),this.infoTip=this.tags.infoTipTag.append({},t.getBody(document))},showInfoTip:function(e,n,i,r,s,a){var o=t.getOverflowParent(n),l=i+(o?o.scrollLeft:0);if(t.dispatch2(this.listeners,"showInfoTip",[e,n,l,r,s,a])){var p=e.ownerDocument.documentElement,c=p.clientWidth,u=p.clientHeight;i+e.offsetWidth+this.infoTipMargin>c-this.infoTipWindowPadding?(e.style.left="auto",e.style.right=c-i+this.infoTipMargin+"px"):(e.style.left=i+this.infoTipMargin+"px",e.style.right="auto"),r+e.offsetHeight+this.infoTipMargin>u?(e.style.top=Math.max(0,u-(e.offsetHeight+this.infoTipMargin))+"px",e.style.bottom="auto"):(e.style.top=r+this.infoTipMargin+"px",e.style.bottom="auto"),e.setAttribute("active","true")}else this.hideInfoTip(e)},hideInfoTip:function(e){e&&e.removeAttribute("active")},onMouseOut:function(e){e.relatedTarget||this.hideInfoTip(this.infoTip)},onMouseMove:function(e){this.infoTip.setAttribute("multiline",!1);var t=e.clientX,n=e.clientY;this.showInfoTip(this.infoTip,e.target,t,n,e.rangeParent,e.rangeOffset)},populateTimingInfoTip:function(e,t){return this.tags.colorTag.replace({rgbValue:t},e),!0},addListener:function(e){this.listeners.push(e)},removeListener:function(e){t.remove(this.listeners,e)}});return s.initialize(),s}),define("domplate/popupMenu",["./domplate","../core/lib","../core/trace"],function(e,t,n){function i(e){if(!e.element){e.getItems&&(e.items=e.getItems()),"-"===e.items[0]&&e.items.shift(),"-"===e.items[e.items.length-1]&&e.items.pop();var n=t.getBody(document);e.element=h.tag.append({object:e},n,h)}t.append(this,e),"string"==typeof this.element?(this.id=this.element,this.element=$(this.id)):this.id&&(this.element.id=this.id),this.elementStyle=this.element.style,this.isVisible=!1,this.handleMouseDown=t.bind(this.handleMouseDown,this),this.handleMouseOver=t.bind(this.handleMouseOver,this),this.handleMouseOut=t.bind(this.handleMouseOut,this),this.handleWindowMouseDown=t.bind(this.handleWindowMouseDown,this)}var r=e.domplate,s=e.A,a=e.DIV,o=e.FOR,l=e.SPAN,p=e.TAG,c={controllers:[],controllerContext:{label:"controller context"},initialize:function(e){this.controllers=[],this.controllerContext=e||this.controllerContext},shutdown:function(){this.removeControllers()},addController:function(){for(var e,n=0;e=arguments[n];n++){var i=e[2];e[2]=t.bind(i,this),e[3]=i,this.controllers.push(e),t.addEventListener.apply(this,e)}},removeController:function(){for(var e,n=0;e=arguments[n];n++)for(var i,r=0;i=this.controllers[r];r++)e[0]===i[0]&&e[1]===i[1]&&e[2]===i[3]&&t.removeEventListener.apply(this,i)},removeControllers:function(){for(var e,n=0;e=this.controllers[n];n++)t.removeEventListener.apply(this,e)}},u={class:"$item.className",type:"$item.type",value:"$item.value",_command:"$item.command"};t.isIE6&&(u.href="javascript:void(0)");var h=r({tag:a({class:"popupMenu popupMenuShadow"},a({class:"popupMenuContent popupMenuShadowContent"},o("item","$object.items|memberIterator",p("$item.tag",{item:"$item"})))),itemTag:s(u,"$item.label"),checkBoxTag:s(t.extend(u,{checked:"$item.checked"}),"$item.label"),radioButtonTag:s(t.extend(u,{selected:"$item.selected"}),"$item.label"),groupTag:s(t.extend(u,{child:"$item.child"}),"$item.label"),shortcutTag:s(u,"$item.label",l({class:"popupMenuShortcutKey"},"$item.key")),separatorTag:l({class:"popupMenuSeparator"}),memberIterator:function(e){for(var n=[],i=0,r=e.length;i<r;i++){var s=e[i];if("string"!=typeof s||0!==s.indexOf("-")){s=t.extend(s,{}),s.type=s.type||"",s.value=s.value||"";var a=s.type;s.tag=this.itemTag;var o=s.className||"";o+="popupMenuOption ","checkbox"===a?(o+="popupMenuCheckBox ",s.tag=this.checkBoxTag):"radio"===a?(o+="popupMenuRadioButton ",s.tag=this.radioButtonTag):"group"===a?(o+="popupMenuGroup ",s.tag=this.groupTag):"shortcut"===a&&(o+="popupMenuShortcut ",s.tag=this.shortcutTag),s.checked?o+="popupMenuChecked ":s.selected&&(o+="popupMenuRadioSelected "),s.disabled&&(o+="popupMenuDisabled "),s.className=o,s.label=s.label,n.push(s)}else n.push({tag:this.separatorTag})}return n}}),d={};return i.prototype=t.extend(c,{initialize:function(){c.initialize.call(this),this.addController([this.element,"mousedown",this.handleMouseDown],[this.element,"mouseover",this.handleMouseOver])},destroy:function(){this.hide(),this.parentMenu&&(this.parentMenu.childMenu=null),this.element.parentNode.removeChild(this.element),this.element=null,this.elementStyle=null,this.parentMenu=null,this.parentTarget=null},shutdown:function(){c.shutdown.call(this)},showPopup:function(e){var n=t.isIE6?1:-4,i=t.getElementBox(e),r={top:0,left:0};this.show(i.left+n-r.left,i.top+i.height-5-r.top)},show:function(e,n){if(this.initialize(),!this.isVisible){if(e=e||0,n=n||0,this.parentMenu){var i=this.parentMenu.childMenu;i&&i!==this&&i.destroy(),this.parentMenu.childMenu=this}else t.addEventListener(document,"mousedown",this.handleWindowMouseDown);this.elementStyle.display="block",this.elementStyle.visibility="hidden";var r=t.getWindowSize();e=Math.min(e,r.width-this.element.clientWidth-10),e=Math.max(e,0),n=Math.min(n,r.height-this.element.clientHeight-10),n=Math.max(n,0),this.elementStyle.left=e+"px",this.elementStyle.top=n+"px",this.elementStyle.visibility="visible",this.isVisible=!0,t.isFunction(this.onShow)&&this.onShow.apply(this,arguments)}},hide:function(){this.clearHideTimeout(),this.clearShowChildTimeout(),this.isVisible&&(this.elementStyle.display="none",this.childMenu&&(this.childMenu.destroy(),this.childMenu=null),this.parentTarget&&t.removeClass(this.parentTarget,"popupMenuGroupSelected"),this.isVisible=!1,this.shutdown(),t.isFunction(this.onHide)&&this.onHide.apply(this,arguments))},showChildMenu:function(e){var n=e.getAttribute("child"),r=this;this.showChildTimeout=window.setTimeout(function(){var s=t.getElementBox(e),a=d.hasOwnProperty(n)?d[n]:{element:$(n)},o=new i(t.extend(a,{parentMenu:r,parentTarget:e})),l=t.isIE6?-1:-6;o.show(s.left+s.width+l,s.top-6),t.setClass(e,"popupMenuGroupSelected")},350)},clearHideTimeout:function(){this.hideTimeout&&(window.clearTimeout(this.hideTimeout),delete this.hideTimeout)},clearShowChildTimeout:function(){this.showChildTimeout&&(window.clearTimeout(this.showChildTimeout),this.showChildTimeout=null)},handleMouseDown:function(e){t.cancelEvent(e,!0);for(var n=this;n.parentMenu;)n=n.parentMenu;var i=e.target||e.srcElement;if(!(i=t.getAncestorByClass(i,"popupMenuOption"))||t.hasClass(i,"popupMenuGroup"))return!1;if(i&&!t.hasClass(i,"popupMenuDisabled")){var r=i.getAttribute("type");if("checkbox"===r){var s=i.getAttribute("value"),a=t.hasClass(i,"popupMenuChecked");a?(t.removeClass(i,"popupMenuChecked"),i.setAttribute("checked","")):(t.setClass(i,"popupMenuChecked"),i.setAttribute("checked","true")),t.isFunction(this.onCheck)&&this.onCheck.call(this,i,s,!a)}if("radiobutton"===r){for(var o=t.getElementsByClass(i.parentNode,"popupMenuRadioSelected"),l=i.getAttribute("group"),p=0,c=o.length;p<c;p++){var u=o[p];u.getAttribute("group")===l&&(t.removeClass(u,"popupMenuRadioSelected"),u.setAttribute("selected",""))}t.setClass(i,"popupMenuRadioSelected"),i.setAttribute("selected","true")}var h=null,d=i.command;t.isFunction(d)?h=d:"string"==typeof d&&(h=this[d]);var f=!0;h&&(f=!1!==h.call(this,i)),f&&n.hide()}return!1},handleWindowMouseDown:function(e){var n=e.target||e.srcElement;(n=t.getAncestorByClass(n,"popupMenu"))||(t.removeEventListener(document,"mousedown",this.handleWindowMouseDown),this.destroy())},handleMouseOver:function(e){this.clearHideTimeout(),this.clearShowChildTimeout();var n=e.target||e.srcElement;if(n=t.getAncestorByClass(n,"popupMenuOption")){var i=this.childMenu;i&&(t.removeClass(i.parentTarget,"popupMenuGroupSelected"),i.parentTarget!==n&&i.isVisible&&(i.clearHideTimeout(),i.hideTimeout=window.setTimeout(function(){i.destroy()},300))),t.hasClass(n,"popupMenuGroup")&&this.showChildMenu(n)}}}),t.append(i,{register:function(e){d[e.id]=e},check:function(e){t.setClass(e,"popupMenuChecked"),e.setAttribute("checked","true")},uncheck:function(e){t.removeClass(e,"popupMenuChecked"),e.setAttribute("checked","")},disable:function(e){t.setClass(e,"popupMenuDisabled")},enable:function(e){t.removeClass(e,"popupMenuDisabled")}}),i}),define("preview/EntryTimeInfoTip",["../domplate/domplate","../core/lib","i18n!../nls/requestList","./harModel"],function(e,t,n,i){var r=e.domplate,s=e.DIV,a=e.FOR,o=e.SPAN,l=e.TABLE,p=e.TBODY,c=e.TD,u=e.TR,h=r({tableTag:l({class:"timeInfoTip"},p()),timingsTag:a("time","$timings",u({class:"timeInfoTipRow",$collapsed:"$time|hideBar"},c({class:"$time|getBarClass timeInfoTipBar",$loaded:"$time.loaded",$fromCache:"$time.fromCache"}),c({class:"timeInfoTipCell startTime"},"$time.start|formatStartTime"),c({class:"timeInfoTipCell elapsedTime"},"$time.elapsed|formatTime"),c("$time|getLabel"))),startTimeTag:u(c(),c("$startTime.time|formatStartTime"),c({class:"timeInfoTipStartLabel",colspan:2},"$startTime|getLabel")),separatorTag:u({},c({class:"timeInfoTipSeparator",colspan:4,height:"10px"},o("$label"))),eventsTag:a("event","$events",u({class:"timeInfoTipEventRow"},c({class:"timeInfoTipBar",align:"center"},s({class:"$event|getPageTimingClass timeInfoTipEventBar"})),c("$event.start|formatStartTime"),c({colspan:2},"$event|getTimingLabel"))),hideBar:function(e){return!e.elapsed&&"request.phase.Blocking"===e.bar},getBarClass:function(e){return"net"+e.bar.substr(e.bar.lastIndexOf(".")+1)+"Bar"},getPageTimingClass:function(e){return e.classes?e.classes:""},formatTime:function(e){return t.formatTime(e.toFixed(2))},formatStartTime:function(e){var n=e>0,i=t.formatTime(Math.abs(e.toFixed(2)));return e?(n>0?"+":"-")+i:i},getLabel:function(e){return n[e.bar]},getTimingLabel:function(e){return e.bar},render:function(e,r,s){var a=e.input,o=r.repObject,l=i.getParentPage(a,o),p=l?t.parseISO8601(l.startedDateTime):null,c=t.parseISO8601(o.startedDateTime),u=h.tableTag.replace({},s),d={};d.time=p?c-p:c-r.phase.startTime,d.bar="request.Started",this.startTimeTag.insertRows({startTime:d},u.firstChild),this.separatorTag.insertRows({label:n["request.phases.label"]},u.firstChild);var f=0,m=[],g=o.timings.blocked,v=o.timings.dns,y=(o.timings.ssl,o.timings.connect),b=o.timings.send,T=o.timings.wait,C=o.timings.receive;if(g>=0&&m.push({bar:"request.phase.Blocking",elapsed:g,start:f}),v>=0&&m.push({bar:"request.phase.Resolving",elapsed:v,start:f+=g<0?0:g}),y>=0&&m.push({bar:"request.phase.Connecting",elapsed:y,start:f+=v<0?0:v}),b>=0&&m.push({bar:"request.phase.Sending",elapsed:b,start:f+=y<0?0:y}),T>=0&&m.push({bar:"request.phase.Waiting",elapsed:T,start:f+=b<0?0:b}),C>=0&&m.push({bar:"request.phase.Receiving",elapsed:C,start:f+=T<0?0:T,loaded:o.loaded,fromCache:i.isCachedEntry(o)}),this.timingsTag.insertRows({timings:m},u.firstChild),!l)return!0;for(var w=[],x=0;x<r.phase.pageTimings.length;x++){var S=r.phase.pageTimings[x];w.push({bar:S.description?S.description:S.name,start:p+S.time-c,classes:S.classes,time:S.time})}return w.length&&(w.sort(function(e,t){var n=e.time-t.time;return n<0?-1:n>0?1:0}),this.separatorTag.insertRows({label:n["request.timings.label"]},u.firstChild),this.eventsTag.insertRows({events:w},u.firstChild)),!0}});return h}),define("preview/EntrySizeInfoTip",["../domplate/domplate","../core/lib","i18n!../nls/requestList","./harModel","../core/cookies"],function(e,t,n,i){var r=e.domplate,s=e.DIV;return r({tag:s(s({class:"sizeInfoTip"},"$file|getSize"),s({class:"sizeInfoTip",style:"display: $file|getCachedDisplayStyle"},"$file|getCached")),zippedTag:s(s({class:"sizeInfoTip"},"$file|getBodySize"),s({class:"sizeInfoTip"},"$file|getContentSize"),s({class:"sizeInfoTip",style:"display: $file|getCachedDisplayStyle"},"$file|getCached")),getSize:function(e){var r=i.getEntryTransferredSize(e);return r<0?n.unknownSize:t.formatString(n.tooltipSize,t.formatSize(r),t.formatNumber(r))},getBodySize:function(e){var r=i.getEntryTransferredSize(e);return r<0?n.unknownSize:t.formatString(n.tooltipZippedSize,t.formatSize(r),t.formatNumber(r))},getContentSize:function(e){var r=i.getEntryUncompressedSize(e);return r<0?n.unknownSize:t.formatString(n.tooltipUnzippedSize,t.formatSize(r),t.formatNumber(r))},getCached:function(e){return i.isCachedEntry(e)?n.resourceFromCache:""},getCachedDisplayStyle:function(e){return i.isCachedEntry(e)?"block":"none"},render:function(e,t,n){var r=t.repObject;return i.getEntryUncompressedSize(r)===i.getEntryTransferredSize(r)?this.tag.replace({file:r},n):this.zippedTag.replace({file:r},n)}})}),define("preview/requestList",["../domplate/domplate","../core/lib","i18n!../nls/requestList","./harModel","../core/cookies","./requestBody","../domplate/infoTip","../domplate/popupMenu","./EntryTimeInfoTip","./EntrySizeInfoTip"],function(e,t,n,i,r,s,a,o,l,p){function c(e){this.input=e,this.pageTimings=[],this.addPageTiming({name:"onContentLoad",classes:"netContentLoadBar",description:n.ContentLoad}),this.addPageTiming({name:"onLoad",classes:"netWindowLoadBar",description:n.WindowLoad}),this.addPageTiming({name:"_firstPaint",classes:"netFirstPaintBar",description:n["paint.event.FP"]}),this.addPageTiming({name:"_firstContentfulPaint",classes:"netFirstContentfulPaintBar",description:n["paint.event.FCP"]}),a.addListener(this)}function u(e){this.files=[],this.pageTimings=[],this.addFile(e)}var h=e.domplate,d=e.DIV,f=e.FOR,m=e.SPAN,g=e.TABLE,v=e.TBODY,y=e.TD,b=e.TR;return c.columns=["index","url","status","type","domain","serverIPAddress","connection","size","uncompressedSize","timeline"],c.defaultColumns=["url","status","size","uncompressedSize","timeline"],c.getVisibleColumns=function(){var e=r.getCookie("previewCols");if(e)return e=e.replace(/\+/g," "),e=unescape(e),e.split(" ");if(!e){var n=document.getElementById("content");if(n&&(e=n.getAttribute("previewCols")))return e.split(" ")}return t.cloneArray(c.defaultColumns)},c.setVisibleColumns=function(e,t){e||(e=c.getVisibleColumns()),e.join&&(e=e.join(" "));var n=document.getElementById("content");n&&n.setAttribute("previewCols",e),t||r.setCookie("previewCols",e)},c.setVisibleColumns(),c.prototype=h({tableTag:g({class:"netTable",cellpadding:0,cellspacing:0,onclick:"$onClick",_repObject:"$requestList"},v(b({class:"netSizerRow"},y({class:"netIndexCol netCol"}),y({class:"netHrefCol netCol",width:"20%"}),y({class:"netStatusCol netCol",width:"7%"}),y({class:"netTypeCol netCol",width:"7%"}),y({class:"netDomainCol netCol",width:"7%"}),y({class:"netServerIPAddressCol netCol",width:"7%"}),y({class:"netConnectionCol netCol",width:"7%"}),y({class:"netSizeCol netCol",width:"7%"}),y({class:"netUncompressedSizeCol netCol",width:"7%"}),y({class:"netTimeCol netCol",width:"100%"}),y({class:"netOptionsCol netCol",width:"15px"})))),fileTag:f("file","$files",b({class:"netRow loaded",$isExpandable:"$file|isExpandable",$responseError:"$file|isError",$responseRedirect:"$file|isRedirect",$fromCache:"$file|isFromCache"},y({class:"netIndexCol netCol"},d({class:"netIndexLabel netLabel"},"$file|getIndex")),y({class:"netHrefCol netCol"},d({class:"netHrefLabel netLabel",style:"margin-left: $file|getIndent\\px"},"$file|getHref"),d({class:"netFullHrefLabel netHrefLabel netLabel",style:"margin-left: $file|getIndent\\px"},"$file|getFullHref")),y({class:"netStatusCol netCol"},d({class:"netStatusLabel netLabel",title:"$file|getStatus"},"$file|getStatus")),y({class:"netTypeCol netCol"},d({class:"netTypeLabel netLabel",title:"$file|getType"},"$file|getType")),y({class:"netDomainCol netCol",title:"$file|getDomain"},d({class:"netDomainLabel netLabel"},"$file|getDomain")),y({class:"netServerIPAddressCol netCol"},d({class:"netServerIPAddressLabel netLabel",title:"$file|getServerIPAddress"},"$file|getServerIPAddress")),y({class:"netConnectionCol netCol"},d({class:"netConnectionLabel netLabel",title:"$file|getConnection"},"$file|getConnection")),y({class:"netSizeCol netCol"},d({class:"netSizeLabel netLabel"},"$file|getCompressedSize")),y({class:"netUncompressedSizeCol netCol"},d({class:"netSizeLabel netLabel"},"$file|getUncompressedSize")),y({class:"netTimeCol netCol"},d({class:"netTimelineBar"},"&nbsp;",d({class:"netBlockingBar netBar"}),d({class:"netResolvingBar netBar"}),d({class:"netConnectingBar netBar"}),d({class:"netSendingBar netBar"}),d({class:"netWaitingBar netBar"}),d({class:"netReceivingBar netBar"},m({class:"netTimeLabel"},"$file|getElapsedTime")))),y({class:"netOptionsCol netCol"},d({class:"netOptionsLabel netLabel",onclick:"$onOpenOptions"})))),headTag:b({class:"netHeadRow"},y({class:"netHeadCol",colspan:9},d({class:"netHeadLabel"},"$doc.rootFile.href"))),netInfoTag:b({class:"netInfoRow"},y({class:"netInfoCol",colspan:9})),summaryTag:b({class:"netRow netSummaryRow"},y({class:"netIndexCol netCol"}),y({class:"netHrefCol netCol"},d({class:"netCountLabel netSummaryLabel"},"-")),y({class:"netStatusCol netCol"}),y({class:"netTypeCol netCol"}),y({class:"netDomainCol netCol"}),y({class:"netServerIPAddressCol netCol"}),y({class:"netConnectionCol netCol"}),y({class:"netTotalSizeCol netSizeCol netCol"},d({class:"netTotalSizeLabel netSummaryLabel"},"0KB")),y({class:"netTotalUncompressedSizeCol netUncompressedSizeCol netCol"},d({class:"netTotalUncompressedSizeLabel netSummaryLabel"},"0KB")),y({class:"netTotalTimeCol netTimeCol netCol"},d({class:"",style:"width: 100%"},d({class:"netCacheSizeLabel netSummaryLabel"},"(",m("0KB"),m(" "+n.summaryFromCache),")"),d({class:"netUncompressedSizeLabel netSummaryLabel"},"(",m("0KB"),m(" "+n.uncompressed),")"),d({class:"netTimeBar"},m({class:"netTotalTimeLabel netSummaryLabel"},"0ms")))),y({class:"netOptionsCol netCol"})),getIndex:function(e){return e.index+1},getIndent:function(e){return 0},isError:function(e){var t=Math.floor(e.response.status/100);return 4===t||5===t||0===t},isRedirect:function(e){return!1},isFromCache:function(e){return e.cache&&e.cache.afterRequest||i.isCachedEntry(e)},getHref:function(e){var n=t.getFileName(this.getFullHref(e));return unescape(e.request.method+" "+n)},getFullHref:function(e){return unescape(e.request.url)},getStatus:function(e){return 0===e.response.status&&e.response._error?e.response._error:(e.response.status>0?e.response.status+" ":"")+e.response.statusText},getType:function(e){return e.response.content.mimeType},getDomain:function(e){return t.getPrettyDomain(e.request.url)},getServerIPAddress:function(e){return e.serverIPAddress||""},getConnection:function(e){return e.connection||""},getUncompressedSize:function(e){var t=i.getEntryUncompressedSize(e);return this.formatSize(t)},getCompressedSize:function(e){var t=i.getEntryTransferredSize(e);return this.formatSize(t)},isExpandable:function(e){return s.canShowFile(e)},formatSize:function(e){return t.formatSize(e)},getElapsedTime:function(e){var n=Math.round(10*e.time)/10;return t.formatTime(n)},onClick:function(e){var n=t.fixEvent(e);if(t.isLeftClick(e)){var i=t.getAncestorByClass(n.target,"netRow");i&&(this.toggleHeadersRow(i),t.cancelEvent(e))}else t.isControlClick(e)&&window.open(e.target.innerText||e.target.textContent)},toggleHeadersRow:function(e){if(t.hasClass(e,"isExpandable")){var n,i=e.repObject;if(t.toggleClass(e,"opened"),t.hasClass(e,"opened")){n=this.netInfoTag.insertRows({},e)[0],n.repObject=i;(new s).render(n.firstChild,i)}else n=e.nextSibling,e.parentNode.removeChild(n)}},onOpenOptions:function(e){var n=t.fixEvent(e);if(t.cancelEvent(e),t.isLeftClick(e)){var i=n.target,r=t.getAncestorByClass(i,"netRow"),s=this.getMenuItems(r);if(s.length){new o({id:"requestContextMenu",items:s}).showPopup(i)}}},getMenuItems:function(e){var i=e.repObject,r=e.phase,s=r.files[0]===i&&this.phases[0]===r,a=[{label:n.menuBreakTimeline,type:"checkbox",disabled:s,checked:r.files[0]===i&&!s,command:t.bind(this.breakLayout,this,e)},"-",{label:n.menuOpenRequest,command:t.bind(this.openRequest,this,i)},{label:n.menuOpenResponse,disabled:!i.response.content.text,command:t.bind(this.openResponse,this,i)}];return t.dispatch(this.listeners,"getMenuItems",[a,this.input,i]),a},openRequest:function(e,t){window.open(e.request.url)},openResponse:function(e,t){var n=e.response.content.text,i=e.response.content.mimeType,r=e.response.content.encoding,s="data:"+(i||"")+";"+(r||"")+","+n;window.open(s)},breakLayout:function(e,n){var r=e.repObject,s=e.phase,a=s.files[0]===r;e.breakLayout=!a,e.setAttribute("breakLayout",e.breakLayout?"true":"false");var o=t.getAncestorByClass(e,"netTable"),l=i.getParentPage(this.input,r);this.updateLayout(o,l)},updateLayout:function(e,n){var s=i.getPageEntries(this.input,n);this.table=e;var a=this.table.firstChild,o=this.firstRow=a.firstChild.nextSibling;this.phases=[];var l=parseInt(r.getCookie("phaseInterval"));isNaN(l)&&(l=4e3);var p=null,c=n?t.parseISO8601(n.startedDateTime):null,u=n&&n.pageTimings?n.pageTimings.onLoad:-1;u>0&&(u+=c);for(var h=0;h<s.length;h++){var d=s[h];t.hasClass(o,"netInfoRow")&&(o=o.nextSibling),o.repObject=d,c||(c=t.parseISO8601(d.startedDateTime));var f=t.parseISO8601(d.startedDateTime),m=p?t.parseISO8601(p.getLastStartTime()):0,g=p?p.endTime:0,v=!1;l>=0&&(v=f>u&&f-m>=l&&f+d.time>=g+l),"boolean"==typeof o.breakLayout?!p||o.breakLayout?p=this.startPhase(d):p.addFile(d):!p||v?p=this.startPhase(d):p.addFile(d),this.phases[0]!==p&&o.setAttribute("breakLayout",p.files[0]===d?"true":"false"),("number"!=typeof p.startTime||p.startTime>f)&&(p.startTime=f),("number"!=typeof p.endTime||p.endTime<f+d.time)&&(p.endTime=f+d.time),o=o.nextSibling}this.updateTimeStamps(n),this.updateTimeline(n),this.updateSummaries(n)},startPhase:function(e){var t=new u(e);return this.phases.push(t),t},calculateFileTimes:function(e,n,i){if(i!==n.phase&&(i=n.phase,this.phaseStartTime=i.startTime,this.phaseEndTime=i.endTime,this.phaseElapsed=this.phaseEndTime-i.startTime),!n.timings)return i;var r=n.timings.blocked<0?0:n.timings.blocked,s=r+(n.timings.dns<0?0:n.timings.dns),a=s+(n.timings.connect<0?0:n.timings.connect),o=a+(n.timings.send<0?0:n.timings.send),l=o+(n.timings.wait<0?0:n.timings.wait),p=l+(n.timings.receive<0?0:n.timings.receive),c=t.parseISO8601(n.startedDateTime);return this.barOffset=((c-this.phaseStartTime)/this.phaseElapsed*100).toFixed(3),this.barBlockingWidth=(r/this.phaseElapsed*100).toFixed(3),this.barResolvingWidth=(s/this.phaseElapsed*100).toFixed(3),this.barConnectingWidth=(a/this.phaseElapsed*100).toFixed(3),this.barSendingWidth=(o/this.phaseElapsed*100).toFixed(3),this.barWaitingWidth=(l/this.phaseElapsed*100).toFixed(3),this.barReceivingWidth=(p/this.phaseElapsed*100).toFixed(3),this.calculatePageTimings(e,n,i),i},calculatePageTimings:function(e,n,i){if(e)for(var r=t.parseISO8601(e.startedDateTime),s=0;s<i.pageTimings.length;s++){var a=i.pageTimings[s].time;if(a>0){var o=r+a-i.startTime,l=(o/this.phaseElapsed*100).toFixed(3);i.pageTimings[s].offset=l}}},updateTimeline:function(e){for(var n,i=this.firstRow;i;i=i.nextSibling){var r=i.repObject;if(r&&!t.hasClass(i,"netInfoRow")){n=this.calculateFileTimes(e,r,n),i.phase=r.phase,delete r.phase;var s=t.getElementByClass(i,"netTimelineBar"),a=s.children[0],o=a.nextSibling,l=o.nextSibling,p=l.nextSibling,c=p.nextSibling,u=c.nextSibling;a.style.left=l.style.left=o.style.left=p.style.left=c.style.left=u.style.left=this.barOffset+"%",a.style.width=this.barBlockingWidth+"%",o.style.width=this.barResolvingWidth+"%",l.style.width=this.barConnectingWidth+"%",p.style.width=this.barSendingWidth+"%",c.style.width=this.barWaitingWidth+"%",u.style.width=this.barReceivingWidth+"%";for(var h=t.getElementsByClass(s,"netPageTimingBar"),d=0;d<h.length;d++)h[d].parentNode.removeChild(h[d]);for(var f=0;f<n.pageTimings.length;f++){var m=n.pageTimings[f];if(m.offset){var g=s.ownerDocument.createElement("DIV");s.appendChild(g),m.classes&&t.setClass(g,m.classes),t.setClass(g,"netPageTimingBar netBar"),g.style.left=m.offset+"%",g.style.display="block",m.offset=null}}}}},updateTimeStamps:function(e){if(e){var n,i=[],r=this.pageTimings;e.pageTimings&&Object.keys(e.pageTimings).forEach(function(t){var n=e.pageTimings[t];if("number"==typeof n){for(var s={label:t,time:n,classes:"",comment:t},a=0;a<r.length;a++)if(r[a].name===t){s.classes=r[a].classes,s.comment=r[a].description;break}i.push(s)}});var s=e.pageTimings?e.pageTimings._timeStamps:[];s&&i.push.apply(i,s);var a=this.phases;for(n=0;n<a.length;n++)for(var o=a[n],l=a[n+1],p=0;p<i.length;p++){var c=i[p],u=c.time;if(u){var h=t.parseISO8601(e.startedDateTime);u+=h,(!l||u<l.startTime)&&(0===n||u>=o.startTime)&&(o.startTime>u&&(o.startTime=u),o.endTime<u&&(o.endTime=u),o.pageTimings.push({classes:c.classes?c.classes:"netTimeStampBar",name:c.label,description:c.comment,time:c.time}))}}}},updateSummaries:function(e){for(var n=this.phases,i=0,r=0,s=0,a=0,o=0,l=0;l<n.length;++l){var p=n[l];p.invalidPhase=!1;var c=this.summarizePhase(p);i+=c.fileCount,r=c.totalTransferredSize<0?-1:r+c.totalTransferredSize,s=c.totalUncompressedSize<0?-1:s+c.totalUncompressedSize,a=c.cachedSize<0?-1:a+c.cachedSize,o+=c.totalTime}var u=this.summaryRow;if(u){t.getElementByClass(u,"netCountLabel").firstChild.nodeValue=this.formatRequestCount(i);var h=t.getElementByClass(u,"netTotalSizeLabel");h.setAttribute("totalSize",r),h.firstChild.nodeValue=t.formatSize(r);var d=t.getElementByClass(u,"netTotalUncompressedSizeLabel");d.setAttribute("totalUncompressedSize",s),d.firstChild.nodeValue=t.formatSize(s);var f=t.getElementByClass(u,"netUncompressedSizeLabel");f.setAttribute("collapsed",0===s);f.childNodes[1].firstChild.nodeValue=t.formatSize(s);var m=t.getElementByClass(u,"netCacheSizeLabel");m.setAttribute("collapsed",a<=0),m.childNodes[1].firstChild.nodeValue=t.formatSize(a);var g=t.getElementByClass(u,"netTotalTimeLabel"),v=t.formatTime(o.toFixed(2));e&&e.pageTimings.onLoad>0&&(v+=" (onload: "+t.formatTime(e.pageTimings.onLoad.toFixed(2))+")"),g.innerHTML=v}},formatRequestCount:function(e){return e+" "+(1===e?n.request:n.requests)},summarizePhase:function(e){for(var n=0,r=0,s=0,a=0,o=0,l=0,p=0;p<e.files.length;p++){var c=e.files[p],u=t.parseISO8601(c.startedDateTime);++a;var h=i.getEntryTransferredSize(c),d=i.getEntryUncompressedSize(c);r=h<0?-1:r+h,s=d<0?-1:s+d,i.isCachedEntry(c)&&(n=d<0?-1:n+d),(!o||u<o)&&(o=u);var f=u+c.time;f>l&&(l=f)}return{cachedSize:n,totalUncompressedSize:s,totalTransferredSize:r,totalTime:l-o,fileCount:a}},showInfoTip:function(e,n,i,r){var s=t.getAncestorByClass(n,"netTable");if(s&&s.repObject===this){var a=t.getAncestorByClass(n,"netRow");if(a){var o;if(t.getAncestorByClass(n,"netBar"))return e.setAttribute("multiline",!0),o=a.repObject.startedDateTime+"-nettime",this.infoTipURL=o,this.populateTimeInfoTip(e,a)
;if(t.hasClass(n,"netSizeLabel"))return o=a.repObject.startedDateTime+"-netsize",this.infoTipURL=o,this.populateSizeInfoTip(e,a)}}},populateTimeInfoTip:function(e,t){return l.render(this,t,e),!0},populateSizeInfoTip:function(e,t){return p.render(this,t,e),!0},render:function(e,t){var n=i.getPageEntries(this.input,t);return n.length?this.append(e,t,n):null},append:function(e,n,i){this.table||(this.table=this.tableTag.replace({requestList:this},e,this)),this.summaryRow||(this.summaryRow=this.summaryTag.insertRows({},this.table.firstChild)[0]);var r=this.table.firstChild,s=r.lastChild.previousSibling,a=i.map(function(e,n){return t.extend(e,{index:n})}),o=this.fileTag.insertRows({files:a},s,this);return this.updateLayout(this.table,n),o[0]},addPageTiming:function(e){this.pageTimings.push(e)}}),u.prototype={addFile:function(e){this.files.push(e),e.phase=this},getLastStartTime:function(){return this.files[this.files.length-1].startedDateTime}},c}),define("nls/pageList",{root:{"column.label.index":"Index","column.label.url":"URL","column.label.status":"Status","column.label.type":"Type","column.label.domain":"Domain","column.label.serverIPAddress":"Server IP Address","column.label.connection":"Connection","column.label.size":"Compressed Size","column.label.uncompressedSize":"Uncompressed Size","column.label.timeline":"Timeline","action.label.Reset":"Reset"}}),define("preview/pageList",["../domplate/domplate","../core/lib","../core/trace","../core/cookies","./requestList","i18n!../nls/pageList","../domplate/popupMenu"],function(e,t,n,i,r,s,a){function o(e){this.input=e,this.listeners=[]}var l=e.domplate,p=e.DIV,c=e.FOR,u=e.SPAN,h=e.TABLE,d=e.TAG,f=e.TBODY,m=e.TD,g=e.TR;return o.prototype=l({tableTag:h({class:"pageTable",cellpadding:0,cellspacing:0,onclick:"$onClick",_repObject:"$input"},f(d("$rowTag",{groups:"$input.log.pages"}))),rowTag:c("group","$groups",g({class:"pageRow",_repObject:"$group"},m({class:"groupName pageCol",width:"1%"},u({class:"pageName"},"$group|getPageTitle")),m({class:"netOptionsCol netCol",width:"15px"},p({class:"netOptionsLabel netLabel",onclick:"$onOpenOptions"})))),bodyTag:g({class:"pageInfoRow",style:"height:auto;"},m({class:"pageInfoCol",colspan:2})),getPageTitle:function(e){return t.cropString(e.title,100)},getPageID:function(e){return"["+e.id+"]"},onClick:function(e){var n=t.fixEvent(e);if(t.isLeftClick(e)){var i=t.getAncestorByClass(n.target,"pageRow");i&&(this.toggleRow(i),t.cancelEvent(e))}},toggleRow:function(e,n){if(!t.hasClass(e,"opened")||!n){var i;if(t.toggleClass(e,"opened"),t.hasClass(e,"opened")){i=this.bodyTag.insertRows({},e)[0];for(var r=this.createRequestList(),s=o.prototype.pageTimings,a=0;a<s.length;a++)r.addPageTiming(s[a]);r.render(i.firstChild,e.repObject)}else i=e.nextSibling,e.parentNode.removeChild(i)}},expandAll:function(e){for(var n=e.firstChild.firstChild;n;)t.hasClass(n,"pageRow")&&this.toggleRow(n,!0),n=n.nextSibling},getPageRow:function(e){for(var n=this.element.parentNode,i=t.getElementsByClass(n,"pageRow"),r=0;r<i.length;r++){var s=i[r];if(s.repObject===e)return s}},togglePage:function(e){var t=this.getPageRow(e);this.toggleRow(t)},expandPage:function(e){var t=this.getPageRow(e);this.toggleRow(t,!0)},collapsePage:function(e){var n=this.getPageRow(e);t.hasClass(n,"opened")&&this.toggleRow(n)},onOpenOptions:function(e){var n=t.fixEvent(e);if(t.cancelEvent(e),t.isLeftClick(e)){var i=n.target,r=t.getAncestorByClass(i,"pageRow"),s=this.getMenuItems(r.repObject);new a({id:"requestContextMenu",items:s}).showPopup(i)}},getMenuItems:function(e){for(var n,i=r.getVisibleColumns().join(),a=0,o=[],l=0;l<r.columns.length;l++){var p=r.columns[l],c=i.indexOf(p)>-1;o.push({label:s["column.label."+p],type:"checkbox",checked:c,command:t.bindFixed(this.onToggleColumn,this,p)}),c&&(n=l,a++)}return 1===a&&(o[n].disabled=!0),o.push("-"),o.push({label:s["action.label.Reset"],command:t.bindFixed(this.updateColumns,this)}),o},onToggleColumn:function(e){var n=r.getVisibleColumns();t.remove(n,e)||n.push(e),this.updateColumns(n)},updateColumns:function(e){e||(e=r.defaultColumns),r.setVisibleColumns(e)},createRequestList:function(){var e=new r(this.input);return e.listeners=this.listeners,e},append:function(e,n){n=n||{expand:!0},this.createRequestList().render(e,null);var i=this.input.log.pages;if(i&&i.length){var r=this.tableTag.append({input:this.input},e,this),s=t.getElementsByClass(r,"pageRow"),a=t.getElementsByClass(e,"pageTable");1===s.length&&1===a.length&&this.toggleRow(s[0]);(n.expand||t.getURLParameter("expand"))&&this.expandAll(r)}},render:function(e,t){this.append(e,t)},addListener:function(e){this.listeners.push(e)},removeListener:function(e){t.remove(this.listeners,e)}}),o.prototype.pageTimings=[],o}),define("preview/harModelLoader",["../core/url"],function(e){return{getLoadOptions:function(t){var n=e.getURLParameter("baseUrl",t);n&&"/"!==n[n.length-1]&&(n+="/");var i=e.getURLParameter("callback",t),r=e.getURLParameter("path",t),s=e.getURLParameters("path",t),a=e.getURLParameters("inputUrl",t).concat(e.getHashParameters("inputUrl",t)),o=s.map(function(e){return n?n+e:e});o=o.concat(a);var l=e.getURLParameters("har",t),p=e.getURLParameters("harp",t).concat(e.getHashParameters("harp",t));return n&&(l=l.map(function(e){return n+e}),p=p.map(function(e){return n+e})),{callbackName:i,baseUrl:n,urls:o,inputUrls:a,hars:l,harps:p,filePath:r}},run:function(e,t,n){var i=this.getLoadOptions(window.location.href);if(n&&n.hasAttribute("data-har")){var r="true"===n.getAttribute("data-validate"),s="true"===n.getAttribute("data-expand"),a=function(t){e.call(this,t,{validate:r,expand:s})};return this.loadArchives([n.getAttribute("data-har")],[],i.callbackName,a,t)}return i.hars.length>0||i.harps.length>0?this.loadArchives(i.hars,i.harps,i.callbackName,e,t):(i.baseUrl||i.inputUrls.length>0)&&i.urls.length>0?this.loadArchives([],i.urls,i.callbackName,e,t):i.filePath?this.loadArchives([i.filePath],[],i.callbackName,e,t):void 0},loadArchives:function(e,t,n,i,r,s){function a(){s&&s()}function o(){if(e.length+t.length===0)return void a();setTimeout(function(){c.loadArchives(e,t,n,i,r,s)},300)}e=e||[],t=t||[];var l=!1,p=e.shift();if(p||(l=!0,p=t.shift()),!p)return a(),!1;n||(n="onInputData");var c=this,u={url:p,context:this,dataType:"json",beforeSend:function(e,t){e.url=t.url},success:function(){i&&i.apply(this,arguments),o()},error:function(){r&&r.apply(this,arguments),o()}};return l&&(u.dataType="jsonp",u.jsonp="callback",u.jsonpCallback=n),this.ajax(u),!0},ajax:function(e){$.ajax(e)},load:function(e,t,n,i,r,s){function a(t){e.appendPreview&&e.appendPreview(t),r&&r.call(e,t)}function o(t,n,i){e.onLoadError&&e.onLoadError(t,n,i),s&&s.call(e,t,n,i)}var l=[],p=[];return n?p.push(t):l.push(t),this.loadArchives(l,p,i,a,o)}}}),define("preview/validationError",["../domplate/domplate","../core/lib","../core/trace","../domplate/popupMenu"],function(e,t,n,i){var r=e.domplate,s=e.DIV,a=e.FOR,o=e.SPAN,l=e.TABLE,p=e.TBODY,c=e.TD;return r({errorTable:l({class:"errorTable",cellpadding:3,cellspacing:0},p(a("error","$errors",(0,e.TR)({class:"errorRow",_repObject:"$error"},c({class:"errorProperty"},o("$error.property")),c({class:"errorOptions",$hasTarget:"$error|hasTarget"},s({class:"errorOptionsTarget",onclick:"$onOpenOptions"},"&nbsp;")),c("&nbsp;"),c({class:"errorMessage"},o("$error.message")))))),hasTarget:function(e){return e.input&&e.file},onOpenOptions:function(e){var n=t.fixEvent(e);if(t.cancelEvent(e),t.isLeftClick(e)){var r=n.target,s=t.getAncestorByClass(r,"errorRow"),a=s.repObject;if(a&&a.input&&a.file){var o=this.getMenuItems(a.input,a.file);o.length&&new i({id:"requestContextMenu",items:o}).showPopup(r)}}},getMenuItems:function(e,n){var i=[];return t.dispatch(this.listeners,"getMenuItems",[i,e,n]),i},listeners:[],addListener:function(e){this.listeners.push(e)},removeListener:function(e){t.remove(this.listeners,e)},appendError:function(e,t){e.errors&&this.errorTable.append(e,t)}})}),define("harPreview",["./preview/requestList","./preview/pageList","./preview/harModel","./preview/harModelLoader","./core/lib","./core/trace","./preview/validationError"],function(e,t,n,i,r,s,a){function o(){this.id="harPreview",this.model=new n}var l=document.getElementById("content");o.prototype={initialize:function(e){var t=r.bind(this.appendPreview,this),n=r.bind(this.onError,this);i.run(t,n,e)},appendPreview:function(e,i){i=i||{validate:!0,expand:!1};try{"false"===r.getURLParameter("validate")&&(i.validate=!1);var o=n.parse(e,i.validate);this.model.append(o);new t(o).render(l,i),r.fireEvent(l,"onPreviewHARLoaded")}catch(e){s.exception("HarPreview.appendPreview; EXCEPTION ",e),a.appendError(e,l)}},onError:function(e,t,n){s.log("HarPreview; Load error ",e,t,n)},loadHar:function(e,t){return t=t||{},i.load(this,e,t.jsonp,t.jsonpCallback,t.success,t.ajaxError)},loadArchives:function(e,t,n,r,s,a){var o=this;return i.loadArchives(e,t,n,function(e){o.appendPreview(e),r&&r.apply(this,arguments)},s,a)},setPreviewColumns:function(t,n){e.setVisibleColumns(t,n)}};var p=l.repObject=new o;r.fireEvent(l,"onPreviewPreInit"),p.initialize(l),r.fireEvent(l,"onPreviewInit"),s.log("HarPreview; initialized OK")});