/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.TextUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MockWebConnection
implements WebConnection {
    private static final Log LOG = LogFactory.getLog(MockWebConnection.class);
    private final Map<String, IOException> throwableMap_ = new HashMap<String, IOException>();
    private final Map<String, RawResponseData> responseMap_ = new HashMap<String, RawResponseData>();
    private RawResponseData defaultResponse_;
    private WebRequest lastRequest_;
    private int requestCount_;
    private final List<URL> requestedUrls_ = Collections.synchronizedList(new ArrayList());

    @Override
    public WebResponse getResponse(WebRequest request) throws IOException {
        RawResponseData rawResponse = this.getRawResponse(request);
        return new WebResponse(rawResponse.asWebResponseData(), request, 0L);
    }

    public RawResponseData getRawResponse(WebRequest request) throws IOException {
        URL url = request.getUrl();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting response for " + url.toExternalForm()));
        }
        this.lastRequest_ = request;
        ++this.requestCount_;
        this.requestedUrls_.add(url);
        String urlString = url.toExternalForm();
        IOException throwable = this.throwableMap_.get(urlString);
        if (throwable != null) {
            throw throwable;
        }
        RawResponseData rawResponse = this.responseMap_.get(urlString);
        if (rawResponse == null) {
            int queryStart = urlString.lastIndexOf(63);
            if (queryStart > -1) {
                urlString = urlString.substring(0, queryStart);
                rawResponse = this.responseMap_.get(urlString);
            }
            if (rawResponse == null && (rawResponse = this.defaultResponse_) == null) {
                throw new IllegalStateException("No response specified that can handle URL " + request.getHttpMethod() + " [" + urlString + "]");
            }
        }
        return rawResponse;
    }

    public List<URL> getRequestedUrls() {
        return Collections.unmodifiableList(this.requestedUrls_);
    }

    public List<String> getRequestedUrls(URL relativeTo) {
        String baseUrl = relativeTo.toString();
        ArrayList<String> response = new ArrayList<String>();
        for (URL url : this.requestedUrls_) {
            String s = url.toString();
            if (s.startsWith(baseUrl)) {
                s = s.substring(baseUrl.length());
            }
            response.add(s);
        }
        return Collections.unmodifiableList(response);
    }

    public HttpMethod getLastMethod() {
        return this.lastRequest_.getHttpMethod();
    }

    public List<NameValuePair> getLastParameters() {
        return this.lastRequest_.getRequestParameters();
    }

    public void setResponse(URL url, String content, int statusCode, String statusMessage, String contentType, List<NameValuePair> headers) {
        this.setResponse(url, content, statusCode, statusMessage, contentType, StandardCharsets.ISO_8859_1, headers);
    }

    public void setResponse(URL url, String content, int statusCode, String statusMessage, String contentType, Charset charset, List<NameValuePair> headers) {
        RawResponseData responseEntry = MockWebConnection.buildRawResponseData(content, charset, statusCode, statusMessage, contentType, headers);
        this.responseMap_.put(url.toExternalForm(), responseEntry);
    }

    public void setThrowable(URL url, IOException throwable) {
        this.throwableMap_.put(url.toExternalForm(), throwable);
    }

    public void setResponse(URL url, byte[] content, int statusCode, String statusMessage, String contentType, List<NameValuePair> headers) {
        RawResponseData responseEntry = MockWebConnection.buildRawResponseData(content, statusCode, statusMessage, contentType, headers);
        this.responseMap_.put(url.toExternalForm(), responseEntry);
    }

    private static RawResponseData buildRawResponseData(byte[] content, int statusCode, String statusMessage, String contentType, List<NameValuePair> headers) {
        return new RawResponseData(content, statusCode, statusMessage, contentType, headers);
    }

    private static RawResponseData buildRawResponseData(String content, Charset charset, int statusCode, String statusMessage, String contentType, List<NameValuePair> headers) {
        if (charset == null) {
            charset = StandardCharsets.ISO_8859_1;
        }
        return new RawResponseData(content, charset, statusCode, statusMessage, contentType, headers);
    }

    public void setResponse(URL url, String content) {
        this.setResponse(url, content, 200, "OK", "text/html", null);
    }

    public void setResponse(URL url, String content, String contentType) {
        this.setResponse(url, content, 200, "OK", contentType, null);
    }

    public void setResponse(URL url, String content, String contentType, Charset charset) {
        this.setResponse(url, content, 200, "OK", contentType, charset, null);
    }

    public void setResponseAsGenericHtml(URL url, String title) {
        String content = "<html><head><title>" + title + "</title></head><body></body></html>";
        this.setResponse(url, content);
    }

    public void setDefaultResponse(String content, int statusCode, String statusMessage, String contentType) {
        this.defaultResponse_ = MockWebConnection.buildRawResponseData(content, null, statusCode, statusMessage, contentType, null);
    }

    public void setDefaultResponse(byte[] content, int statusCode, String statusMessage, String contentType) {
        this.defaultResponse_ = MockWebConnection.buildRawResponseData(content, statusCode, statusMessage, contentType, null);
    }

    public void setDefaultResponse(String content) {
        this.setDefaultResponse(content, 200, "OK", "text/html");
    }

    public void setDefaultResponse(String content, String contentType) {
        this.setDefaultResponse(content, 200, "OK", contentType, null);
    }

    public void setDefaultResponse(String content, String contentType, Charset charset) {
        this.setDefaultResponse(content, 200, "OK", contentType, charset, null);
    }

    public void setDefaultResponse(String content, int statusCode, String statusMessage, String contentType, List<NameValuePair> headers) {
        this.defaultResponse_ = MockWebConnection.buildRawResponseData(content, null, statusCode, statusMessage, contentType, headers);
    }

    public void setDefaultResponse(String content, int statusCode, String statusMessage, String contentType, Charset charset, List<NameValuePair> headers) {
        this.defaultResponse_ = MockWebConnection.buildRawResponseData(content, charset, statusCode, statusMessage, contentType, headers);
    }

    public Map<String, String> getLastAdditionalHeaders() {
        return this.lastRequest_.getAdditionalHeaders();
    }

    public WebRequest getLastWebRequest() {
        return this.lastRequest_;
    }

    public int getRequestCount() {
        return this.requestCount_;
    }

    public boolean hasResponse(URL url) {
        return this.responseMap_.containsKey(url.toExternalForm());
    }

    @Override
    public void close() {
    }

    public static class RawResponseData {
        private final List<NameValuePair> headers_;
        private final byte[] byteContent_;
        private final String stringContent_;
        private final int statusCode_;
        private final String statusMessage_;
        private Charset charset_;

        RawResponseData(byte[] byteContent, int statusCode, String statusMessage, String contentType, List<NameValuePair> headers) {
            this.byteContent_ = byteContent;
            this.stringContent_ = null;
            this.statusCode_ = statusCode;
            this.statusMessage_ = statusMessage;
            this.headers_ = RawResponseData.compileHeaders(headers, contentType);
        }

        RawResponseData(String stringContent, Charset charset, int statusCode, String statusMessage, String contentType, List<NameValuePair> headers) {
            this.byteContent_ = null;
            this.charset_ = charset;
            this.stringContent_ = stringContent;
            this.statusCode_ = statusCode;
            this.statusMessage_ = statusMessage;
            this.headers_ = RawResponseData.compileHeaders(headers, contentType);
        }

        private static List<NameValuePair> compileHeaders(List<NameValuePair> headers, String contentType) {
            ArrayList<NameValuePair> compiledHeaders = new ArrayList<NameValuePair>();
            if (headers != null) {
                compiledHeaders.addAll(headers);
            }
            if (contentType != null) {
                compiledHeaders.add(new NameValuePair("Content-Type", contentType));
            }
            return compiledHeaders;
        }

        WebResponseData asWebResponseData() {
            byte[] content = this.byteContent_ != null ? this.byteContent_ : (this.stringContent_ == null ? new byte[]{} : TextUtils.stringToByteArray(this.stringContent_, this.charset_));
            return new WebResponseData(content, this.statusCode_, this.statusMessage_, this.headers_);
        }

        public List<NameValuePair> getHeaders() {
            return this.headers_;
        }

        public byte[] getByteContent() {
            return this.byteContent_;
        }

        public String getStringContent() {
            return this.stringContent_;
        }

        public int getStatusCode() {
            return this.statusCode_;
        }

        public String getStatusMessage() {
            return this.statusMessage_;
        }

        public Charset getCharset() {
            return this.charset_;
        }
    }
}

