/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxStaticFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.URLSearchParams;
import com.gargoylesoftware.htmlunit.javascript.host.file.File;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.net.MalformedURLException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class URL
extends SimpleScriptable {
    private java.net.URL url_;

    public URL() {
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public URL(String url, Object base) {
        String baseStr = null;
        if (!Undefined.isUndefined((Object)base)) {
            baseStr = Context.toString((Object)base);
        }
        try {
            if (StringUtils.isBlank((CharSequence)baseStr)) {
                this.url_ = UrlUtils.toUrlUnsafe(url);
            } else {
                java.net.URL baseUrl = UrlUtils.toUrlUnsafe(baseStr);
                this.url_ = new java.net.URL(baseUrl, url);
            }
            this.checkRemoveRedundantPort();
        }
        catch (MalformedURLException e) {
            throw ScriptRuntime.typeError((String)e.toString());
        }
    }

    @JsxStaticFunction
    public static String createObjectURL(Object fileOrBlob) {
        if (fileOrBlob instanceof File) {
            File file = (File)fileOrBlob;
            return file.getFile().toURI().normalize().toString();
        }
        return null;
    }

    @JsxStaticFunction
    public static void revokeObjectURL(Object objectURL) {
    }

    @JsxGetter
    public String getHash() {
        if (this.url_ == null) {
            return null;
        }
        String ref = this.url_.getRef();
        return ref == null ? "" : "#" + ref;
    }

    @JsxSetter
    public void setHash(String fragment) throws MalformedURLException {
        if (this.url_ == null) {
            return;
        }
        this.url_ = UrlUtils.getUrlWithNewRef(this.url_, StringUtils.isEmpty((CharSequence)fragment) ? null : fragment);
    }

    @JsxGetter
    public String getHost() {
        if (this.url_ == null) {
            return null;
        }
        int port = this.url_.getPort();
        return this.url_.getHost() + (String)(port > 0 ? ":" + port : "");
    }

    @JsxSetter
    public void setHost(String host) throws MalformedURLException {
        if (this.url_ == null) {
            return;
        }
        String newHost = StringUtils.substringBefore((String)host, (int)58);
        if (StringUtils.isEmpty((CharSequence)newHost)) {
            return;
        }
        try {
            int ip = Integer.parseInt(newHost);
            StringBuilder ipString = new StringBuilder();
            ipString.insert(0, Integer.toString(ip % 256));
            ipString.insert(0, '.');
            ipString.insert(0, Integer.toString((ip /= 256) % 256));
            ipString.insert(0, '.');
            ipString.insert(0, Integer.toString((ip /= 256) % 256));
            ipString.insert(0, '.');
            ipString.insert(0, Integer.toString((ip /= 256) % 256));
            newHost = ipString.toString();
        }
        catch (Exception ip) {
            // empty catch block
        }
        this.url_ = UrlUtils.getUrlWithNewHost(this.url_, newHost);
        String newPort = StringUtils.substringAfter((String)host, (int)58);
        if (StringUtils.isNotBlank((CharSequence)newHost)) {
            try {
                this.url_ = UrlUtils.getUrlWithNewHostAndPort(this.url_, newHost, Integer.parseInt(newPort));
            }
            catch (Exception exception) {}
        } else {
            this.url_ = UrlUtils.getUrlWithNewHost(this.url_, newHost);
        }
        this.checkRemoveRedundantPort();
    }

    private void checkRemoveRedundantPort() throws MalformedURLException {
        if ("https".equals(this.url_.getProtocol()) && this.url_.getPort() == 443 || "http".equals(this.url_.getProtocol()) && this.url_.getPort() == 80) {
            this.url_ = UrlUtils.getUrlWithNewPort(this.url_, -1);
        }
    }

    @JsxGetter
    public String getHostname() {
        if (this.url_ == null) {
            return null;
        }
        return UrlUtils.encodeAnchor(this.url_.getHost());
    }

    @JsxSetter
    public void setHostname(String hostname) throws MalformedURLException {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHOR_HOSTNAME_IGNORE_BLANK)) {
            if (!StringUtils.isBlank((CharSequence)hostname)) {
                this.url_ = UrlUtils.getUrlWithNewHost(this.url_, hostname);
            }
        } else if (!StringUtils.isEmpty((CharSequence)hostname)) {
            this.url_ = UrlUtils.getUrlWithNewHost(this.url_, hostname);
        }
    }

    @JsxGetter
    public String getHref() {
        if (this.url_ == null) {
            return null;
        }
        return this.jsToString();
    }

    @JsxSetter
    public void setHref(String href) throws MalformedURLException {
        if (this.url_ == null) {
            return;
        }
        this.url_ = UrlUtils.toUrlUnsafe(href);
        this.checkRemoveRedundantPort();
    }

    @JsxGetter
    public Object getOrigin() {
        if (this.url_ == null) {
            return null;
        }
        return this.url_.getProtocol() + "://" + this.url_.getHost();
    }

    @JsxGetter
    public URLSearchParams getSearchParams() {
        if (this.url_ == null) {
            return null;
        }
        return new URLSearchParams(this.url_.getQuery());
    }

    @JsxGetter
    public String getPassword() {
        if (this.url_ == null) {
            return null;
        }
        String userInfo = this.url_.getUserInfo();
        int idx = userInfo == null ? -1 : userInfo.indexOf(58);
        return idx == -1 ? "" : userInfo.substring(idx + 1);
    }

    @JsxSetter
    public void setPassword(String password) throws MalformedURLException {
        if (this.url_ == null) {
            return;
        }
        this.url_ = UrlUtils.getUrlWithNewUserPassword(this.url_, password.isEmpty() ? null : password);
    }

    @JsxGetter
    public String getPathname() {
        if (this.url_ == null) {
            return null;
        }
        String path = this.url_.getPath();
        return path.isEmpty() ? "/" : path;
    }

    @JsxSetter
    public void setPathname(String path) throws MalformedURLException {
        if (this.url_ == null) {
            return;
        }
        this.url_ = UrlUtils.getUrlWithNewPath(this.url_, (String)(path.startsWith("/") ? path : "/" + path));
    }

    @JsxGetter
    public String getPort() {
        if (this.url_ == null) {
            return null;
        }
        int port = this.url_.getPort();
        return port == -1 ? "" : Integer.toString(port);
    }

    @JsxSetter
    public void setPort(String port) throws MalformedURLException {
        if (this.url_ == null) {
            return;
        }
        int portInt = port.isEmpty() ? -1 : Integer.parseInt(port);
        this.url_ = UrlUtils.getUrlWithNewPort(this.url_, portInt);
        this.checkRemoveRedundantPort();
    }

    @JsxGetter
    public String getProtocol() {
        if (this.url_ == null) {
            return null;
        }
        String protocol = this.url_.getProtocol();
        return protocol.isEmpty() ? "" : protocol + ":";
    }

    @JsxSetter
    public void setProtocol(String protocol) throws MalformedURLException {
        if (this.url_ == null || protocol.isEmpty() || !UrlUtils.isValidScheme(protocol)) {
            return;
        }
        try {
            this.url_ = UrlUtils.getUrlWithNewProtocol(this.url_, protocol);
            this.checkRemoveRedundantPort();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @JsxGetter
    public String getSearch() {
        if (this.url_ == null) {
            return null;
        }
        String search = this.url_.getQuery();
        return search == null ? "" : "?" + search;
    }

    @JsxSetter
    public void setSearch(String search) throws MalformedURLException {
        if (this.url_ == null) {
            return;
        }
        String query = search == null || "?".equals(search) || "".equals(search) ? null : (search.charAt(0) == '?' ? search.substring(1) : search);
        this.url_ = UrlUtils.getUrlWithNewQuery(this.url_, query);
    }

    @JsxGetter
    public String getUsername() {
        if (this.url_ == null) {
            return null;
        }
        String userInfo = this.url_.getUserInfo();
        if (userInfo == null) {
            return "";
        }
        return StringUtils.substringBefore((String)userInfo, (int)58);
    }

    @JsxSetter
    public void setUsername(String username) throws MalformedURLException {
        if (this.url_ == null) {
            return;
        }
        this.url_ = UrlUtils.getUrlWithNewUserName(this.url_, username.isEmpty() ? null : username);
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (this.url_ == null) {
            return super.getDefaultValue(hint);
        }
        if (StringUtils.isEmpty((CharSequence)this.url_.getPath())) {
            return this.url_.toExternalForm() + "/";
        }
        return this.url_.toExternalForm();
    }

    @JsxFunction
    public String toJSON() {
        return this.jsToString();
    }

    @JsxFunction(functionName="toString")
    public String jsToString() {
        if (StringUtils.isEmpty((CharSequence)this.url_.getPath())) {
            try {
                return UrlUtils.getUrlWithNewPath(this.url_, "/").toExternalForm();
            }
            catch (MalformedURLException e) {
                return this.url_.toExternalForm();
            }
        }
        return this.url_.toExternalForm();
    }
}

