/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.css.dom.CSSCharsetRuleImpl;
import com.gargoylesoftware.css.dom.CSSFontFaceRuleImpl;
import com.gargoylesoftware.css.dom.CSSImportRuleImpl;
import com.gargoylesoftware.css.dom.CSSMediaRuleImpl;
import com.gargoylesoftware.css.dom.CSSPageRuleImpl;
import com.gargoylesoftware.css.dom.CSSStyleRuleImpl;
import com.gargoylesoftware.css.dom.CSSUnknownRuleImpl;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSFontFaceRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSImportRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSKeyframesRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSMediaRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass
public class CSSRule
extends SimpleScriptable {
    private static final Log LOG = LogFactory.getLog(CSSRule.class);
    @JsxConstant(value={SupportedBrowser.IE})
    public static final short UNKNOWN_RULE = 0;
    @JsxConstant
    public static final short STYLE_RULE = 1;
    @JsxConstant
    public static final short CHARSET_RULE = 2;
    @JsxConstant
    public static final short IMPORT_RULE = 3;
    @JsxConstant
    public static final short MEDIA_RULE = 4;
    @JsxConstant
    public static final short FONT_FACE_RULE = 5;
    @JsxConstant
    public static final short PAGE_RULE = 6;
    @JsxConstant
    public static final short KEYFRAMES_RULE = 7;
    @JsxConstant
    public static final short KEYFRAME_RULE = 8;
    @JsxConstant
    public static final short NAMESPACE_RULE = 10;
    @JsxConstant(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public static final short COUNTER_STYLE_RULE = 11;
    @JsxConstant(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public static final short SUPPORTS_RULE = 12;
    @JsxConstant(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public static final short FONT_FEATURE_VALUES_RULE = 14;
    @JsxConstant(value={SupportedBrowser.IE})
    public static final short VIEWPORT_RULE = 15;
    private final CSSStyleSheet stylesheet_;
    private final AbstractCSSRuleImpl rule_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public CSSRule() {
        this.stylesheet_ = null;
        this.rule_ = null;
    }

    public static CSSRule create(CSSStyleSheet stylesheet, AbstractCSSRuleImpl rule) {
        if (rule instanceof CSSStyleRuleImpl) {
            return new CSSStyleRule(stylesheet, (CSSStyleRuleImpl)rule);
        }
        if (rule instanceof CSSImportRuleImpl) {
            return new CSSImportRule(stylesheet, (CSSImportRuleImpl)rule);
        }
        if (rule instanceof CSSMediaRuleImpl) {
            return new CSSMediaRule(stylesheet, (CSSMediaRuleImpl)rule);
        }
        if (rule instanceof CSSFontFaceRuleImpl) {
            return new CSSFontFaceRule(stylesheet, (CSSFontFaceRuleImpl)rule);
        }
        if (rule instanceof CSSUnknownRuleImpl) {
            CSSUnknownRuleImpl unknownRule = (CSSUnknownRuleImpl)rule;
            if (unknownRule.getCssText().startsWith("@keyframes")) {
                return new CSSKeyframesRule(stylesheet, (CSSUnknownRuleImpl)rule);
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Unknown CSSRule " + rule.getClass().getName() + " is not yet supported; rule content: '" + rule.getCssText() + "'"));
            }
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("CSSRule " + rule.getClass().getName() + " is not yet supported; rule content: '" + rule.getCssText() + "'"));
        }
        return null;
    }

    protected CSSRule(CSSStyleSheet stylesheet, AbstractCSSRuleImpl rule) {
        this.stylesheet_ = stylesheet;
        this.rule_ = rule;
        this.setParentScope((Scriptable)stylesheet);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @JsxGetter
    public short getType() {
        if (this.rule_ instanceof CSSCharsetRuleImpl) {
            return 2;
        }
        if (this.rule_ instanceof CSSFontFaceRuleImpl) {
            return 5;
        }
        if (this.rule_ instanceof CSSImportRuleImpl) {
            return 3;
        }
        if (this.rule_ instanceof CSSMediaRuleImpl) {
            return 4;
        }
        if (this.rule_ instanceof CSSPageRuleImpl) {
            return 6;
        }
        if (this.rule_ instanceof CSSStyleRuleImpl) {
            return 1;
        }
        if (this.rule_ instanceof CSSUnknownRuleImpl) {
            return 0;
        }
        return 0;
    }

    @JsxGetter
    public String getCssText() {
        return this.rule_.getCssText();
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF78, SupportedBrowser.IE})
    public void setCssText(String cssText) {
        this.rule_.setCssText(cssText);
    }

    @JsxGetter
    public CSSStyleSheet getParentStyleSheet() {
        return this.stylesheet_;
    }

    @JsxGetter
    public CSSRule getParentRule() {
        AbstractCSSRuleImpl parentRule = this.rule_.getParentRule();
        if (parentRule != null) {
            return CSSRule.create(this.stylesheet_, parentRule);
        }
        return null;
    }

    public AbstractCSSRuleImpl getRule() {
        return this.rule_;
    }
}

