/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import com.gargoylesoftware.htmlunit.util.WebConnectionWrapper;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.ContextFactory;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebuggingWebConnection
extends WebConnectionWrapper {
    private static final Log LOG = LogFactory.getLog(DebuggingWebConnection.class);
    private static final Pattern ESCAPE_QUOTE_PATTERN = Pattern.compile("'");
    private int counter_;
    private final WebConnection wrappedWebConnection_;
    private final File javaScriptFile_;
    private final File reportFolder_;
    private boolean uncompressJavaScript_ = true;

    public DebuggingWebConnection(WebConnection webConnection, String dirName) throws IOException {
        super(webConnection);
        this.wrappedWebConnection_ = webConnection;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        this.reportFolder_ = new File(tmpDir, dirName);
        if (this.reportFolder_.exists()) {
            FileUtils.forceDelete((File)this.reportFolder_);
        }
        FileUtils.forceMkdir((File)this.reportFolder_);
        this.javaScriptFile_ = new File(this.reportFolder_, "hu.js");
        this.createOverview();
    }

    @Override
    public WebResponse getResponse(WebRequest request) throws IOException {
        WebResponse response = this.wrappedWebConnection_.getResponse(request);
        if (this.isUncompressJavaScript() && DebuggingWebConnection.isJavaScript(response.getContentType())) {
            response = this.uncompressJavaScript(response);
        }
        this.saveResponse(response, request);
        return response;
    }

    protected WebResponse uncompressJavaScript(WebResponse response) {
        WebRequest request = response.getWebRequest();
        final String scriptName = request.getUrl().toString();
        final String scriptSource = response.getContentAsString();
        ContextFactory factory = new ContextFactory();
        ContextAction<Object> action = new ContextAction<Object>(){

            public Object run(Context cx) {
                cx.setOptimizationLevel(-1);
                Script script = cx.compileString(scriptSource, scriptName, 0, null);
                return cx.decompileScript(script, 4);
            }
        };
        try {
            String decompileScript = (String)factory.call((ContextAction)action);
            ArrayList<NameValuePair> responseHeaders = new ArrayList<NameValuePair>(response.getResponseHeaders());
            for (int i = responseHeaders.size() - 1; i >= 0; --i) {
                if (!"content-encoding".equalsIgnoreCase(((NameValuePair)responseHeaders.get(i)).getName())) continue;
                responseHeaders.remove(i);
            }
            WebResponseData wrd = new WebResponseData(decompileScript.getBytes(), response.getStatusCode(), response.getStatusMessage(), responseHeaders);
            return new WebResponse(wrd, response.getWebRequest().getUrl(), response.getWebRequest().getHttpMethod(), response.getLoadTime());
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to decompress JavaScript response. Delivering as it.", (Throwable)e);
            return response;
        }
    }

    public void addMark(String mark) throws IOException {
        if (mark != null) {
            mark = mark.replace("\"", "\\\"");
        }
        this.appendToJSFile("tab[tab.length] = \"" + mark + "\";\n");
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("--- " + mark + " ---"));
        }
    }

    protected void saveResponse(WebResponse response, WebRequest request) throws IOException {
        ++this.counter_;
        String extension = DebuggingWebConnection.chooseExtension(response.getContentType());
        File file = this.createFile(request.getUrl(), extension);
        int length = 0;
        try (InputStream input = response.getContentAsStream();){
            try (OutputStream fos2 = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                length = IOUtils.copy((InputStream)input, (OutputStream)fos2);
            }
            catch (EOFException fos2) {
                // empty catch block
            }
        }
        URL url = response.getWebRequest().getUrl();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Created file " + file.getAbsolutePath() + " for response " + this.counter_ + ": " + url));
        }
        StringBuilder bduiler = new StringBuilder();
        bduiler.append("tab[tab.length] = {code: " + response.getStatusCode() + ", ").append("fileName: '" + file.getName() + "', ").append("contentType: '" + response.getContentType() + "', ").append("method: '" + request.getHttpMethod().name() + "', ");
        if (request.getHttpMethod() == HttpMethod.POST && request.getEncodingType() == FormEncodingType.URL_ENCODED) {
            bduiler.append("postParameters: " + DebuggingWebConnection.nameValueListToJsMap(request.getRequestParameters()) + ", ");
        }
        bduiler.append("url: '" + DebuggingWebConnection.escapeJSString(url.toString()) + "', ").append("loadTime: " + response.getLoadTime() + ", ").append("responseSize: " + length + ", ").append("responseHeaders: " + DebuggingWebConnection.nameValueListToJsMap(response.getResponseHeaders())).append("};\n");
        this.appendToJSFile(bduiler.toString());
    }

    static String escapeJSString(String string) {
        return ESCAPE_QUOTE_PATTERN.matcher(string).replaceAll("\\\\'");
    }

    static String chooseExtension(String contentType) {
        if (DebuggingWebConnection.isJavaScript(contentType)) {
            return ".js";
        }
        if ("text/html".equals(contentType)) {
            return ".html";
        }
        if ("text/css".equals(contentType)) {
            return ".css";
        }
        if ("text/xml".equals(contentType)) {
            return ".xml";
        }
        if ("image/gif".equals(contentType)) {
            return ".gif";
        }
        return ".txt";
    }

    static boolean isJavaScript(String contentType) {
        return contentType.contains("javascript") || contentType.contains("ecmascript") || contentType.startsWith("text/") && contentType.endsWith("js");
    }

    public boolean isUncompressJavaScript() {
        return this.uncompressJavaScript_;
    }

    public void setUncompressJavaScript(boolean decompress) {
        this.uncompressJavaScript_ = decompress;
    }

    private void appendToJSFile(String str) throws IOException {
        try (BufferedWriter jsFileWriter = Files.newBufferedWriter(this.javaScriptFile_.toPath(), StandardCharsets.UTF_8, StandardOpenOption.APPEND);){
            jsFileWriter.write(str);
        }
    }

    private File createFile(URL url, String extension) throws IOException {
        Object name = url.getPath().replaceFirst("/$", "").replaceAll(".*/", "");
        name = org.apache.commons.lang3.StringUtils.substringBefore((String)name, (String)"?");
        name = org.apache.commons.lang3.StringUtils.substringBefore((String)name, (String)";");
        name = org.apache.commons.lang3.StringUtils.substring((String)name, (int)0, (int)30);
        if (!((String)(name = StringUtils.sanitizeForFileName((String)name))).endsWith(extension)) {
            name = (String)name + extension;
        }
        int counter = 0;
        Object fileName;
        File f;
        while (!(f = new File(this.reportFolder_, (String)(fileName = counter != 0 ? org.apache.commons.lang3.StringUtils.substringBeforeLast((String)name, (String)".") + "_" + counter + "." + org.apache.commons.lang3.StringUtils.substringAfterLast((String)name, (String)".") : name))).createNewFile()) {
            ++counter;
        }
        return f;
    }

    static String nameValueListToJsMap(List<NameValuePair> headers) {
        if (headers == null || headers.isEmpty()) {
            return "{}";
        }
        StringBuilder bduiler = new StringBuilder("{");
        for (NameValuePair header : headers) {
            bduiler.append("'" + header.getName() + "': '" + DebuggingWebConnection.escapeJSString(header.getValue()) + "', ");
        }
        bduiler.delete(bduiler.length() - 2, bduiler.length());
        bduiler.append('}');
        return bduiler.toString();
    }

    private void createOverview() throws IOException {
        FileUtils.writeStringToFile((File)this.javaScriptFile_, (String)"var tab = [];\n", (Charset)StandardCharsets.ISO_8859_1);
        URL indexResource = DebuggingWebConnection.class.getResource("DebuggingWebConnection.index.html");
        if (indexResource == null) {
            throw new RuntimeException("Missing dependency DebuggingWebConnection.index.html");
        }
        File summary = new File(this.reportFolder_, "index.html");
        FileUtils.copyURLToFile((URL)indexResource, (File)summary);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Summary will be in " + summary.getAbsolutePath()));
        }
    }

    File getReportFolder() {
        return this.reportFolder_;
    }
}

