/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

public class SynchronizingCounter {
    private int count;

    public SynchronizingCounter() {
        this(0);
    }

    public SynchronizingCounter(int initialValue) {
        this.count = initialValue;
    }

    public synchronized int add(int delta) {
        this.count += delta;
        this.check(this.count);
        return this.count;
    }

    public synchronized void awaitZero() throws InterruptedException {
        while (this.count != 0) {
            this.wait();
        }
    }

    public synchronized void awaitZero(long timeout) throws InterruptedException {
        long wakeUpTime = System.currentTimeMillis() + timeout;
        while (this.count != 0 && System.currentTimeMillis() < wakeUpTime) {
            this.wait(timeout);
        }
    }

    protected synchronized void check(int value) {
        if (value == 0) {
            this.notifyAll();
        }
    }

    public synchronized int decrement() {
        return this.add(-1);
    }

    public synchronized int get() {
        return this.count;
    }

    public synchronized int increment() {
        return this.add(1);
    }

    public synchronized void set(int value) {
        this.count = value;
        this.check(value);
    }
}

