/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent;

import com.sun.management.OperatingSystemMXBean;
import com.xceptance.common.lang.ThreadUtils;
import com.xceptance.common.util.ProcessUtils;
import com.xceptance.xlt.agent.JvmResourceUsageData;
import com.xceptance.xlt.api.engine.DataManager;
import com.xceptance.xlt.api.engine.GlobalClock;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.SessionImpl;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.util.Precision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmResourceUsageDataGenerator
extends Thread {
    public static final String RESULT_DIRECTORY_NAME = "Agent-JVM-Monitor";
    private static final String[] KNOWN_FULL_GC_NAMES = new String[]{"MarkSweepCompact", "ConcurrentMarkSweep", "PS MarkSweep", "G1 Old Generation"};
    private static final String[] KNOWN_MINOR_GC_NAMES = new String[]{"Copy", "ParNew", "PS Scavenge", "G1 Young Generation"};
    private static final Logger log = LoggerFactory.getLogger(JvmResourceUsageDataGenerator.class);
    private static final int DEFAULT_LOG_INTERVAL = 10000;
    private final int cpuCount;
    private long lastCpuTime;
    private long lastFullGcTime;
    private long lastFullGcCount;
    private long lastMinorGcTime;
    private long lastMinorGcCount;
    private Map<Long, Long> lastThreadCpuTimes = new HashMap<Long, Long>();
    private long lastUptime;
    private final long logInterval = XltProperties.getInstance().getProperty("com.xceptance.xlt.agent.monitoring.samplingInterval", 10000);
    private final DataManager dataManager;
    private final boolean sunApiAvailable;
    private long uptime;
    private final JvmResourceUsageData usageData;

    public JvmResourceUsageDataGenerator(String name, String hostName, int port, long startOfLoggingPeriod, long endOfLoggingPeriod) {
        SessionImpl session = (SessionImpl)Session.getCurrent();
        session.setAgentID(name);
        session.setUserName(RESULT_DIRECTORY_NAME);
        session.setLoadTest(true);
        this.setName(session.getUserID());
        String jvmName = "Agent-" + name + "-" + hostName + "-" + port;
        this.usageData = new JvmResourceUsageData(jvmName);
        this.cpuCount = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
        this.sunApiAvailable = this.checkIfClassImplementsInterface(ManagementFactory.getOperatingSystemMXBean().getClass(), "com.sun.management.OperatingSystemMXBean");
        this.dataManager = session.getDataManager();
        this.dataManager.setStartOfLoggingPeriod(startOfLoggingPeriod);
        this.dataManager.setEndOfLoggingPeriod(endOfLoggingPeriod);
    }

    @Override
    public void run() {
        log.debug("JVM resource usage monitoring thread started.");
        while (true) {
            ThreadUtils.sleep(this.logInterval);
            this.updateStats(this.usageData);
            this.dataManager.logDataRecord(this.usageData);
        }
    }

    private boolean checkIfClassImplementsInterface(Class<?> cls, String interfaceName) {
        for (Class<?> iface : cls.getInterfaces()) {
            if (!iface.getName().equals(interfaceName) && !this.checkIfClassImplementsInterface(iface, interfaceName)) continue;
            return true;
        }
        return false;
    }

    private long getProcessCpuTime() {
        long cpuTime = 0L;
        HashMap<Long, Long> newThreadCpuTimes = new HashMap<Long, Long>();
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        for (long id : threadMxBean.getAllThreadIds()) {
            long newValue = threadMxBean.getThreadCpuTime(id);
            if (newValue == -1L) continue;
            newThreadCpuTimes.put(id, newValue);
            Long last = this.lastThreadCpuTimes.get(id);
            if (last == null) {
                cpuTime += newValue;
                continue;
            }
            cpuTime += newValue - last;
        }
        this.lastThreadCpuTimes = newThreadCpuTimes;
        return this.lastCpuTime + cpuTime;
    }

    private void setCpuStats(JvmResourceUsageData usageData) {
        double totalCpuUsage;
        long newCpuTime = 0L;
        java.lang.management.OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
        newCpuTime = this.sunApiAvailable ? ((OperatingSystemMXBean)osMxBean).getProcessCpuTime() : this.getProcessCpuTime();
        if (newCpuTime >= this.lastCpuTime) {
            long diffCpuTime = (newCpuTime - this.lastCpuTime) / 1000000L;
            long diffTime = this.uptime - this.lastUptime;
            double usage = (double)diffCpuTime * 100.0 / (double)diffTime / (double)this.cpuCount;
            usage = Precision.round((double)usage, (int)2);
            usage = this.limitUsageValue(usage);
            usageData.setCpuUsage(usage);
            this.lastCpuTime = newCpuTime;
        }
        if (this.sunApiAvailable) {
            totalCpuUsage = ((OperatingSystemMXBean)osMxBean).getSystemCpuLoad() * 100.0;
            totalCpuUsage = Precision.round((double)totalCpuUsage, (int)2);
            totalCpuUsage = this.limitUsageValue(totalCpuUsage);
        } else {
            totalCpuUsage = 0.0;
        }
        usageData.setTotalCpuUsage(totalCpuUsage);
    }

    private void setGarbageCollectionStats(JvmResourceUsageData usageData) {
        for (GarbageCollectorMXBean gcMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long gcCountDiff;
            long gcTimeDiff;
            String gcName = gcMXBean.getName();
            long gcCount = gcMXBean.getCollectionCount();
            long gcTime = gcMXBean.getCollectionTime();
            double gcPercentage = 0.0;
            if (ArrayUtils.contains((Object[])KNOWN_MINOR_GC_NAMES, (Object)gcName)) {
                gcTimeDiff = gcTime - this.lastMinorGcTime;
                gcCountDiff = gcCount - this.lastMinorGcCount;
                gcPercentage = (double)gcTimeDiff * 100.0 / (double)(this.uptime - this.lastUptime) / (double)this.cpuCount;
                gcPercentage = Precision.round((double)gcPercentage, (int)2);
                gcPercentage = this.limitUsageValue(gcPercentage);
                usageData.setMinorGcCount(gcCount);
                usageData.setMinorGcTime(gcTime);
                usageData.setMinorGcCpuUsage(gcPercentage);
                usageData.setMinorGcTimeDiff((int)gcTimeDiff);
                usageData.setMinorGcCountDiff((int)gcCountDiff);
                this.lastMinorGcTime = gcTime;
                this.lastMinorGcCount = gcCount;
                continue;
            }
            if (ArrayUtils.contains((Object[])KNOWN_FULL_GC_NAMES, (Object)gcName)) {
                gcTimeDiff = gcTime - this.lastFullGcTime;
                gcCountDiff = gcCount - this.lastFullGcCount;
                gcPercentage = (double)gcTimeDiff * 100.0 / (double)(this.uptime - this.lastUptime) / (double)this.cpuCount;
                gcPercentage = Precision.round((double)gcPercentage, (int)2);
                gcPercentage = this.limitUsageValue(gcPercentage);
                usageData.setFullGcCount(gcCount);
                usageData.setFullGcTime(gcTime);
                usageData.setFullGcCpuUsage(gcPercentage);
                usageData.setFullGcTimeDiff((int)gcTimeDiff);
                usageData.setFullGcCountDiff((int)gcCountDiff);
                this.lastFullGcTime = gcTime;
                this.lastFullGcCount = gcCount;
                continue;
            }
            log.debug("Don't know how to handle statistics of GC: " + gcName);
        }
    }

    private void setHeapMemoryStats(JvmResourceUsageData usageDate) {
        Runtime runtime = Runtime.getRuntime();
        long totalHeap = runtime.totalMemory();
        long usedHeap = totalHeap - runtime.freeMemory();
        double heapUsage = (double)usedHeap * 100.0 / (double)totalHeap;
        heapUsage = Precision.round((double)heapUsage, (int)2);
        usageDate.setTotalHeapSize(totalHeap);
        usageDate.setUsedHeapSize(usedHeap);
        usageDate.setHeapUsage(heapUsage);
    }

    private void setNumberOfThreads(JvmResourceUsageData usageData) {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        long[] threadIds = threadMxBean.getAllThreadIds();
        ThreadInfo[] threadInfos = threadMxBean.getThreadInfo(threadIds);
        int runnable = 0;
        int blocked = 0;
        int waiting = 0;
        for (ThreadInfo threadInfo : threadInfos) {
            if (threadInfo == null) continue;
            Thread.State threadState = threadInfo.getThreadState();
            if (threadState == Thread.State.RUNNABLE) {
                ++runnable;
                continue;
            }
            if (threadState == Thread.State.BLOCKED) {
                ++blocked;
                continue;
            }
            if (threadState != Thread.State.TIMED_WAITING && threadState != Thread.State.WAITING) continue;
            ++waiting;
        }
        usageData.setRunnableThreadCount(runnable);
        usageData.setBlockedThreadCount(blocked);
        usageData.setWaitingThreadCount(waiting);
    }

    private void setPhysicalMemoryStats(JvmResourceUsageData usageData) {
        long totalMem = 0L;
        long usedMem = 0L;
        double memUsage = 0.0;
        java.lang.management.OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
        if (this.sunApiAvailable) {
            usedMem = ((OperatingSystemMXBean)osMxBean).getCommittedVirtualMemorySize();
            totalMem = ((OperatingSystemMXBean)osMxBean).getTotalPhysicalMemorySize();
            memUsage = (double)usedMem * 100.0 / (double)totalMem;
            memUsage = Precision.round((double)memUsage, (int)2);
        } else {
            usedMem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getCommitted() + ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getCommitted();
        }
        usageData.setCommittedMemorySize(usedMem);
        usageData.setMemoryUsage(memUsage);
    }

    private void updateStats(JvmResourceUsageData usageData) {
        this.uptime = ProcessUtils.getUptime();
        usageData.setTime(GlobalClock.getInstance().getTime());
        this.setHeapMemoryStats(usageData);
        this.setPhysicalMemoryStats(usageData);
        this.setCpuStats(usageData);
        this.setNumberOfThreads(usageData);
        this.setGarbageCollectionStats(usageData);
        this.lastUptime = this.uptime;
    }

    private double limitUsageValue(double usage) {
        usage = Math.min(usage, 100.0);
        usage = Math.max(usage, 0.0);
        return usage;
    }
}

