/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.engine;

import com.xceptance.common.lang.ParseNumbers;
import com.xceptance.common.util.CsvUtils;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.GlobalClock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractData
implements Data {
    private long time = GlobalClock.getInstance().getTime();
    private final String typeCode;
    private String name;
    private String transactionName;
    private String agentName;

    public AbstractData(String typeCode) {
        this(null, typeCode);
    }

    public AbstractData(String name, String typeCode) {
        this.name = name;
        this.typeCode = typeCode;
    }

    @Override
    public final void fromCSV(String s) {
        String[] fields = CsvUtils.decode(s, ',');
        this.parseValues(fields);
    }

    @Override
    public String getAgentName() {
        return this.agentName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public String getTransactionName() {
        return this.transactionName;
    }

    @Override
    public String getTypeCode() {
        return this.typeCode;
    }

    @Override
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setTime() {
        this.time = GlobalClock.getInstance().getTime();
    }

    @Override
    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }

    @Override
    public final String toCSV() {
        List<String> fieldList = this.addValues();
        String[] fields = fieldList.toArray(new String[fieldList.size()]);
        return CsvUtils.encode(fields, ',');
    }

    protected List<String> addValues() {
        ArrayList<String> fields = new ArrayList<String>(20);
        fields.add(this.typeCode);
        fields.add(this.name);
        fields.add(Long.toString(this.time));
        return fields;
    }

    protected int getMinNoCSVElements() {
        return 3;
    }

    protected void parseValues(String[] values) {
        if (values.length < this.getMinNoCSVElements()) {
            throw new IllegalArgumentException(String.format("Expected at least %d fields, but got only %d -> %s", this.getMinNoCSVElements(), values.length, Arrays.toString(values)));
        }
        if (values[0].equals(this.typeCode)) {
            this.name = values[1];
            this.time = ParseNumbers.parseLong(values[2]);
            if (this.time <= 0L) {
                throw new IllegalArgumentException("Invalid value for the 'time' attribute.");
            }
        } else {
            throw new IllegalArgumentException("Cannot recreate the object state. The read type code '" + values[0] + "' does not match the expected type code '" + this.typeCode + "'.");
        }
    }
}

