/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.engine;

import com.xceptance.common.lang.ParseNumbers;
import com.xceptance.xlt.api.engine.AbstractData;
import com.xceptance.xlt.api.engine.GlobalClock;
import java.util.List;

public abstract class TimerData
extends AbstractData {
    private long runTime;
    private boolean failed;

    public TimerData(String typeCode) {
        super(typeCode);
    }

    public TimerData(String name, String typeCode) {
        super(name, typeCode);
    }

    public long getEndTime() {
        return this.getTime() + this.runTime;
    }

    public long getRunTime() {
        return this.runTime;
    }

    public boolean hasFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public void setRunTime() {
        this.runTime = GlobalClock.getInstance().getTime() - this.getTime();
    }

    public void setRunTime(long runTime) {
        this.runTime = runTime;
    }

    @Override
    protected List<String> addValues() {
        List<String> fields = super.addValues();
        fields.add(Long.toString(this.runTime));
        fields.add(Boolean.toString(this.failed));
        return fields;
    }

    @Override
    protected void parseValues(String[] values) {
        super.parseValues(values);
        this.runTime = ParseNumbers.parseLong(values[3]);
        this.failed = Boolean.valueOf(values[4]);
        if (this.runTime < 0L) {
            throw new IllegalArgumentException("Invalid value for the 'runtime' attribute.");
        }
    }

    @Override
    protected int getMinNoCSVElements() {
        return 5;
    }
}

