/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.htmlunit;

import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.xceptance.common.util.RegExUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class LightWeightPage {
    private final WebResponse response;
    private final String name;
    private final Charset charset;

    public LightWeightPage(WebResponse webResponse, String timerName) {
        this.response = webResponse;
        this.name = timerName;
        this.charset = this.determineContentCharset();
    }

    public String getContent() {
        return this.response.getContentAsString(this.getCharset());
    }

    public int getHttpResponseCode() {
        return this.response.getStatusCode();
    }

    public WebResponse getWebResponse() {
        return this.response;
    }

    public String getTimerName() {
        return this.name;
    }

    public String getContentCharset() {
        return this.charset.name();
    }

    public Charset getCharset() {
        return this.charset;
    }

    private Charset determineContentCharset() {
        if (this.response != null) {
            String charsetName = this.getCharsetNameFromContentTypeHeader(this.response);
            if (StringUtils.isBlank((CharSequence)charsetName)) {
                String content = this.response.getContentAsString(StandardCharsets.ISO_8859_1);
                if (StringUtils.isNotBlank((CharSequence)content) && StringUtils.isBlank((CharSequence)(charsetName = RegExUtils.getFirstMatch(content, "<\\?xml\\s[^>]*?encoding=\"([^\"]+)", 1))) && StringUtils.isBlank((CharSequence)(charsetName = RegExUtils.getFirstMatch(content, "<meta\\s[^>]*?content=\"[^\"]*?charset=([^\";]+)", 1)))) {
                    charsetName = RegExUtils.getFirstMatch(content, "<meta\\s+charset=\"([^\"]+)", 1);
                }
                if (StringUtils.isBlank((CharSequence)charsetName)) {
                    WebRequest request = this.response.getWebRequest();
                    String string = charsetName = request != null ? request.getCharset().name() : null;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)charsetName) && Charset.isSupported(charsetName = charsetName.trim())) {
                return Charset.forName(charsetName);
            }
        }
        return StandardCharsets.ISO_8859_1;
    }

    private String getCharsetNameFromContentTypeHeader(WebResponse response) {
        String contentType = response.getResponseHeaderValue("content-type");
        if (contentType == null) {
            return null;
        }
        return StringUtils.substringBetween((String)(contentType + ";"), (String)"charset=", (String)";");
    }
}

