/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.report.external;

import com.xceptance.common.util.CsvUtils;
import com.xceptance.xlt.api.report.external.AbstractLineParser;
import com.xceptance.xlt.api.report.external.ValueSet;

public class PlainDataTableCsvParser
extends AbstractLineParser {
    private static final String PROP_FIELD_SEPARATOR = "parser.csv.separator";
    private char fieldSeparator = '\u0000';

    @Override
    public ValueSet parse(String line) {
        String[] csv = CsvUtils.decode(line, this.getFieldSeparator());
        ValueSet dp = new ValueSet(-1L);
        for (int i = 0; i < csv.length; ++i) {
            String name = this.getName(i);
            if (this.getValueNames() == null || !this.getValueNames().contains(name)) continue;
            dp.addValue(name, this.parseValue(csv[i]));
        }
        return dp;
    }

    private Object parseValue(String valueString) {
        Object value;
        try {
            value = Integer.valueOf(valueString);
        }
        catch (NumberFormatException e) {
            try {
                value = Double.valueOf(valueString);
            }
            catch (NumberFormatException e2) {
                value = valueString;
            }
        }
        return value;
    }

    protected String getName(int i) {
        return String.valueOf(i);
    }

    protected char getFieldSeparator() {
        if (this.fieldSeparator == '\u0000') {
            if (this.getProperties() == null) {
                throw new IllegalStateException("Properties have not been set! Set them first.");
            }
            String separatorProp = this.getProperties().getProperty(PROP_FIELD_SEPARATOR, ",");
            this.fieldSeparator = (char)(separatorProp.length() == 0 ? 44 : (int)separatorProp.charAt(0));
        }
        return this.fieldSeparator;
    }
}

