/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.util;

import com.gargoylesoftware.htmlunit.WebResponse;
import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.util.AbstractResponseProcessor;
import com.xceptance.xlt.api.util.XltLogger;
import java.util.regex.Pattern;

public class ResponseContentProcessor
extends AbstractResponseProcessor {
    private final Pattern contentPattern;
    private final String replacement;
    private final Pattern urlPattern;

    public ResponseContentProcessor(String contentPattern, String replacement) {
        this(contentPattern, replacement, null);
    }

    public ResponseContentProcessor(String contentPattern, String replacement, String urlPattern) {
        ParameterCheckUtils.isNotNull(contentPattern, "contentPattern");
        ParameterCheckUtils.isNotNull(replacement, "replacement");
        this.contentPattern = RegExUtils.getPattern(contentPattern);
        this.replacement = replacement;
        this.urlPattern = urlPattern != null ? RegExUtils.getPattern(urlPattern) : null;
    }

    public ResponseContentProcessor(Pattern contentPattern, String replacement) {
        this(contentPattern, replacement, null);
    }

    public ResponseContentProcessor(Pattern contentPattern, String replacement, Pattern urlPattern) {
        ParameterCheckUtils.isNotNull(contentPattern, "contentPattern");
        ParameterCheckUtils.isNotNull(replacement, "replacement");
        this.urlPattern = urlPattern;
        this.contentPattern = contentPattern;
        this.replacement = replacement;
    }

    @Override
    public WebResponse processResponse(WebResponse webResponse) {
        String newContent;
        String content;
        String urlString = webResponse.getWebRequest().getUrl().toString();
        if ((this.urlPattern == null || this.urlPattern.matcher(urlString).find()) && (content = webResponse.getContentAsString()) != null && !(newContent = this.contentPattern.matcher(content).replaceAll(this.replacement)).equals(content)) {
            if (XltLogger.runTimeLogger.isDebugEnabled()) {
                XltLogger.runTimeLogger.debug("Content replacement applied for URL: " + urlString);
            }
            webResponse = this.createWebResponse(webResponse, newContent);
        }
        return webResponse;
    }
}

