/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.util;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.util.XltLogger;
import java.net.URI;
import java.net.URISyntaxException;

public class URLUtils {
    public static String makeLinkAbsolute(String baseUrl, String url) {
        try {
            return URLUtils.makeLinkAbsolute(new URI(baseUrl), url);
        }
        catch (URISyntaxException e1) {
            return null;
        }
    }

    public static String makeLinkAbsolute(URI baseURI, String url) {
        ParameterCheckUtils.isNotNull(baseURI, "baseURI");
        if (url == null) {
            return null;
        }
        String trimmedURL = url.trim();
        if (trimmedURL.length() == 0) {
            return url;
        }
        if (RegExUtils.isMatching(trimmedURL.toLowerCase(), "^(javascript|mailto):")) {
            return null;
        }
        String quotedURL = trimmedURL.replace(' ', '+');
        try {
            URI fixedBaseURI = URLUtils.fixPath(baseURI);
            return fixedBaseURI.resolve(quotedURL).normalize().toASCIIString();
        }
        catch (Exception e) {
            String errMsg = String.format("Cannot make link '%s' absolute using base URL '%s'.", url, baseURI.toASCIIString());
            XltLogger.runTimeLogger.error(errMsg);
            return null;
        }
    }

    private static URI fixPath(URI uri) throws URISyntaxException {
        String path = uri.getPath();
        if (path == null || path.length() == 0) {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), "/", uri.getQuery(), uri.getFragment());
        }
        return uri;
    }
}

