/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.util;

import com.google.common.hash.Hashing;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltProperties;
import java.util.Random;

public class XltRandom {
    private static final ThreadLocal<InternalRandom> random = new ThreadLocal<InternalRandom>(){

        @Override
        protected InternalRandom initialValue() {
            return new InternalRandom(XltRandom.getInitValue());
        }
    };

    public static void setSeed(long seed) {
        random.get().setSeed(seed);
    }

    public static long getSeed() {
        return random.get().getSeed();
    }

    public static void reseed() {
        random.get().reseed();
    }

    public static boolean nextBoolean() {
        return random.get().nextBoolean();
    }

    public static boolean nextBoolean(int trueCaseProbability) {
        if (trueCaseProbability <= 0) {
            return false;
        }
        if (trueCaseProbability >= 100) {
            return true;
        }
        int v = random.get().nextInt(101);
        return v <= trueCaseProbability;
    }

    public static void nextBytes(byte[] bytes) {
        random.get().nextBytes(bytes);
    }

    public static double nextDouble() {
        return random.get().nextDouble();
    }

    public static float nextFloat() {
        return random.get().nextFloat();
    }

    public static double nextGaussian() {
        return random.get().nextGaussian();
    }

    public static int nextInt() {
        return random.get().nextInt();
    }

    public static int nextInt(int n) {
        return n != 0 ? random.get().nextInt(n) : 0;
    }

    public static long nextLong() {
        return random.get().nextLong();
    }

    public static Random getRandom() {
        return random.get();
    }

    public static int getRandom(int[] data) {
        if (data == null || data.length == 0) {
            throw new ArrayIndexOutOfBoundsException("No data was given to pick from");
        }
        return data[XltRandom.nextInt(data.length)];
    }

    private static long getInitValue() {
        long initValue = XltProperties.getInstance().getProperty("com.xceptance.xlt.random.initValue", System.currentTimeMillis());
        if (Session.getCurrent().isLoadTest()) {
            String userId = Thread.currentThread().getName();
            long hashCode = Hashing.crc32().hashUnencodedChars((CharSequence)userId).padToLong();
            hashCode *= hashCode;
            initValue += hashCode;
        }
        return initValue;
    }

    public static int nextIntWithDeviation(int base, int deviation) {
        if (deviation == 0) {
            return base;
        }
        if (deviation < 0) {
            deviation = -deviation;
        }
        return XltRandom.nextInt(base - deviation, base + deviation);
    }

    public static int nextInt(int minimum, int maximum) {
        if (minimum > maximum) {
            throw new IllegalArgumentException(String.format("The minimum value (%d) is greater than the maximum value (%d)", minimum, maximum));
        }
        int diff = maximum - minimum;
        if (diff < 0) {
            throw new IllegalArgumentException("The difference of maximum value and minimum value must not be greater than (Integer.MAX_VALUE-1).");
        }
        int randomValue = XltRandom.nextInt(diff + 1);
        return minimum + randomValue;
    }

    private static final class InternalRandom
    extends Random {
        private long seed;

        public InternalRandom(long seed) {
            super(seed);
            this.seed = seed;
        }

        public synchronized long getSeed() {
            return this.seed;
        }

        @Override
        public synchronized void setSeed(long seed) {
            this.seed = seed;
            super.setSeed(seed);
        }

        public synchronized void reseed() {
            this.setSeed(31L * this.seed + 1L);
        }
    }
}

