/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.htmlunit.LightWeightPage;
import com.xceptance.xlt.engine.XltWebClient;
import com.xceptance.xlt.engine.util.LWPageUtilities;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;

public class LightWeightPageImpl
extends LightWeightPage {
    private final URL baseUrl;
    private final Map<String, LightWeightPage> framePages = new HashMap<String, LightWeightPage>();
    private final XltWebClient webClient;
    private LightWeightPageImpl enc = null;
    private String source = null;

    public LightWeightPageImpl(WebResponse webResponse, String timerName, XltWebClient webClient) throws FailingHttpStatusCodeException, IOException {
        super(webResponse, timerName);
        this.webClient = webClient;
        String uncommentedContent = LWPageUtilities.removeHtmlComments(this.getContent());
        this.baseUrl = this.getBaseUrl(uncommentedContent);
        this.loadFrames(uncommentedContent);
    }

    public URL expandUrl(String relativeUrl) {
        return XltWebClient.makeUrlAbsolute(this.baseUrl, relativeUrl);
    }

    public LightWeightPage getFramePageByFrameName(String name) {
        return this.framePages.get(name);
    }

    public Map<String, LightWeightPage> getFramePages() {
        return this.framePages;
    }

    private URL getBaseUrl(String uncommentedContent) throws MalformedURLException {
        String baseUrl;
        URL u;
        URL url = this.getWebResponse().getWebRequest().getUrl();
        List<String> baseUrls = LWPageUtilities.getAllBaseLinks(uncommentedContent);
        if (!baseUrls.isEmpty() && (u = XltWebClient.makeUrlAbsolute(url, baseUrl = baseUrls.get(0))) != null) {
            url = u;
        }
        return url;
    }

    private void loadFrames(String uncommentedContent) throws FailingHttpStatusCodeException, IOException {
        List<String> frameAttributeLists = LWPageUtilities.getAllFrameAttributes(uncommentedContent);
        for (String attributeList : frameAttributeLists) {
            String src = LWPageUtilities.getAttributeValue(attributeList, "src");
            if (!this.accept(src)) continue;
            URL url = this.expandUrl(src);
            String name = LWPageUtilities.getAttributeValue(attributeList, "name");
            if (name == null) {
                name = RandomStringUtils.randomAlphabetic((int)10);
            }
            LightWeightPageImpl framePage = (LightWeightPageImpl)this.webClient.getLightWeightPage(url);
            this.framePages.put(name, framePage);
            framePage.setEnclosingPage(this);
            framePage.setSource(src);
        }
    }

    private void setEnclosingPage(LightWeightPageImpl enclosingPage) {
        this.enc = enclosingPage;
    }

    public LightWeightPage getEnclosingPage() {
        return this.enc;
    }

    private void setSource(String src) {
        this.source = src;
    }

    public String getSource() {
        return this.source;
    }

    private boolean accept(String urlString) {
        if (urlString == null || urlString.length() == 0) {
            return false;
        }
        int idx = urlString.indexOf(58);
        if (idx == -1) {
            return true;
        }
        return RegExUtils.isMatching(urlString, "https?://");
    }
}

