/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.gargoylesoftware.css.dom.CSSStyleSheetImpl;
import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.xceptance.common.collection.ConcurrentLRUCache;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XltCache
extends Cache {
    private static final long serialVersionUID = 8636191853037193204L;
    private static final Logger LOG = LoggerFactory.getLogger(XltCache.class);
    private final ConcurrentLRUCache<String, CSSStyleSheetImpl> cssCache;
    private final AtomicInteger cssHits = new AtomicInteger();
    private final AtomicInteger cssReads = new AtomicInteger();
    private final ConcurrentLRUCache<String, Script> jsCache;
    private final AtomicInteger jsHits = new AtomicInteger();
    private final AtomicInteger jsReads = new AtomicInteger();

    public XltCache(int jsCacheSize, int cssCacheSize) {
        this.cssCache = new ConcurrentLRUCache(cssCacheSize);
        this.jsCache = new ConcurrentLRUCache(jsCacheSize);
        super.setMaxSize(0);
    }

    @Override
    public void cache(String css, CSSStyleSheetImpl styleSheet) {
        this.cssCache.put(css, styleSheet);
    }

    public void cache(String scriptSource, Script script) {
        this.jsCache.put(scriptSource, script);
    }

    @Override
    public boolean cacheIfPossible(WebRequest request, WebResponse response, Object object) {
        boolean storedInCache = false;
        if (this.isCacheable(request, response)) {
            String requestUrl = request.getUrl().toString();
            if (object instanceof CSSStyleSheetImpl) {
                this.cssCache.put(requestUrl, (CSSStyleSheetImpl)object);
                storedInCache = true;
            } else if (object instanceof Script) {
                this.jsCache.put(requestUrl, (Script)object);
                storedInCache = true;
            }
        }
        return storedInCache;
    }

    @Override
    public void clear() {
    }

    public Script getCachedScript(String scriptSource) {
        Script script = this.jsCache.get(scriptSource);
        this.onJSCacheAccess(script != null);
        return script;
    }

    @Override
    public Object getCachedObject(WebRequest request) {
        String requestUrl = request.getUrl().toString();
        CSSStyleSheetImpl cssStyleSheet = this.cssCache.get(requestUrl);
        Script script = this.jsCache.get(requestUrl);
        if (cssStyleSheet != null && script != null) {
            this.cssCache.remove(requestUrl);
            this.jsCache.remove(requestUrl);
        } else {
            if (cssStyleSheet != null) {
                this.onCSSCacheAccess(true);
                return cssStyleSheet;
            }
            if (script != null) {
                this.onJSCacheAccess(true);
                return script;
            }
        }
        this.onCSSCacheAccess(false);
        this.onJSCacheAccess(false);
        return null;
    }

    @Override
    public CSSStyleSheetImpl getCachedStyleSheet(String css) {
        CSSStyleSheetImpl styleSheet = this.cssCache.get(css);
        this.onCSSCacheAccess(styleSheet != null);
        return styleSheet;
    }

    @Override
    public int getMaxSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaxSize(int maxSize) {
        throw new UnsupportedOperationException();
    }

    protected void onCSSCacheAccess(boolean cacheHit) {
        int hits;
        int reads = this.cssReads.incrementAndGet();
        int n = hits = cacheHit ? this.cssHits.incrementAndGet() : this.cssHits.intValue();
        if (reads % 1000 == 0) {
            int size = this.cssCache.size();
            double ratio = (double)hits / (double)reads;
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("CSS cache statistics: size = %d / hits = %d / reads = %d / ratio = %.2f", size, hits, reads, ratio));
            }
        }
    }

    protected void onJSCacheAccess(boolean cacheHit) {
        int hits;
        int reads = this.jsReads.incrementAndGet();
        int n = hits = cacheHit ? this.jsHits.incrementAndGet() : this.jsHits.intValue();
        if (reads % 1000 == 0) {
            int size = this.jsCache.size();
            double ratio = (double)hits / (double)reads;
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("JS cache statistics: size = %d / hits = %d / reads = %d / ratio = %.2f", size, hits, reads, ratio));
            }
        }
    }
}

