/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.xlt.api.engine.scripting.AbstractWebDriverScriptTestCase;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.api.webdriver.XltDriver;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.resultbrowser.RequestHistory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XltEngineWarmUp {
    private static final Logger LOG = LoggerFactory.getLogger(XltEngineWarmUp.class);
    private static boolean alreadyRun;
    private static int serverPort;

    public static synchronized void execute() {
        if (!alreadyRun) {
            alreadyRun = true;
            XltProperties props = XltProperties.getInstance();
            String prefix = "com.xceptance.xltwarmUp.";
            boolean enabled = true;
            int iterations = props.getProperty("com.xceptance.xltwarmUp.iterations", 10);
            LOG.debug("Performing warm-up...");
            Server server = XltEngineWarmUp.createServer();
            try {
                server.start();
            }
            catch (Exception e) {
                LOG.error("Warm-up: Failed to start HTTP server", (Throwable)e);
            }
            serverPort = ((ServerConnector)server.getConnectors()[0]).getLocalPort();
            XltEngineWarmUp.performWarmUp(iterations);
            try {
                server.stop();
            }
            catch (Exception e) {
                LOG.error("Warm-up: Failed to stop HTTP server", (Throwable)e);
            }
        }
    }

    private static Server createServer() {
        Resource resource = Resource.newClassPathResource((String)"/com/xceptance/xlt/engine/warmup/");
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setBaseResource(resource);
        HandlerList handlers = new HandlerList(new Handler[]{resourceHandler, new DefaultHandler()});
        Server server = new Server(0);
        server.setHandler((Handler)handlers);
        return server;
    }

    private static void performWarmUp(int iterations) {
        SessionImpl session = SessionImpl.getCurrent();
        session.getDataManager().setLoggingEnabled(false);
        session.getRequestHistory().setDumpMode(RequestHistory.DumpMode.NEVER);
        for (int i = 0; i < iterations; ++i) {
            LOG.debug("Warm-up iteration #" + i);
            Result result = JUnitCore.runClasses((Class[])new Class[]{WarmUp.class});
            if (result.getFailureCount() <= 0) continue;
            LOG.error("Warm-up: Scenario failed", ((Failure)result.getFailures().get(0)).getException());
        }
        SessionImpl.removeCurrent();
    }

    public static class WarmUp
    extends AbstractWebDriverScriptTestCase {
        public WarmUp() {
            super(new XltDriver(true), "http://localhost:" + serverPort);
        }

        @Test
        public void test() {
            this.startAction("WarmUp");
            this.open("index.html");
            this.assertTitle("Warm-Up");
        }

        @After
        public void cleanUp() {
            this.getWebDriver().quit();
        }
    }
}

