/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.data;

import com.xceptance.common.util.CsvUtils;
import com.xceptance.xlt.api.data.DataSetProvider;
import com.xceptance.xlt.api.data.DataSetProviderException;
import com.xceptance.xlt.api.util.XltProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CsvDataSetProvider
implements DataSetProvider {
    private static final String PROP_PREFIX = "com.xceptance.xlt.data.dataSetProviders.csv.";
    private static final String PROP_COMMENT_MARKER = "com.xceptance.xlt.data.dataSetProviders.csv.lineCommentMarker";
    private static final String PROP_FIELD_SEPARATOR = "com.xceptance.xlt.data.dataSetProviders.csv.separator";
    private static final String PROP_FILE_ENCODING = "com.xceptance.xlt.data.dataSetProviders.csv.encoding";

    @Override
    public List<Map<String, String>> getAllDataSets(File dataFile) throws DataSetProviderException {
        ArrayList<Map<String, String>> arrayList;
        XltProperties props = XltProperties.getInstance();
        String encoding = props.getProperty(PROP_FILE_ENCODING, "UTF-8");
        char fieldSeparator = props.getProperty(PROP_FIELD_SEPARATOR, ",").trim().charAt(0);
        String commentMarker = props.getProperty(PROP_COMMENT_MARKER, "#");
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dataFile), encoding));
        try {
            String line;
            ArrayList<Map<String, String>> dataSets = new ArrayList<Map<String, String>>();
            String[] keys = null;
            int lineNo = 1;
            while ((line = in.readLine()) != null) {
                if (commentMarker.isEmpty() || !line.startsWith(commentMarker)) {
                    String[] dataRecord = CsvUtils.decode(line, fieldSeparator);
                    if (keys == null) {
                        keys = dataRecord;
                    } else {
                        if (keys.length != dataRecord.length) {
                            throw new DataSetProviderException(String.format("Invalid data record in line %d: Expected %d fields, but found %d", lineNo, keys.length, dataRecord.length));
                        }
                        LinkedHashMap<String, String> dataSet = new LinkedHashMap<String, String>();
                        dataSets.add(dataSet);
                        for (int i = 0; i < keys.length; ++i) {
                            dataSet.put(keys[i], dataRecord[i]);
                        }
                    }
                }
                ++lineNo;
            }
            arrayList = dataSets;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new DataSetProviderException("Failed to read data sets from CSV file: " + dataFile, ex);
            }
        }
        in.close();
        return arrayList;
    }
}

