/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.engine.util.TimerUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.utils.URLEncodedUtils;

public abstract class AbstractWebConnection<T, O, I>
implements WebConnection {
    private final WebClient webClient;

    public AbstractWebConnection(WebClient webClient) {
        this.webClient = webClient;
    }

    protected WebClient getWebClient() {
        return this.webClient;
    }

    @Override
    public WebResponse getResponse(WebRequest webRequest) throws IOException {
        this.finalizeRequestHeaders(webRequest);
        try {
            T httpClient = this.createHttpClient(this.webClient, webRequest);
            O request = this.makeRequest(webRequest);
            long startTime = TimerUtils.getTime();
            I response = this.executeRequest(httpClient, request);
            long loadTime = TimerUtils.getTime() - startTime;
            return this.makeWebResponse(response, webRequest, loadTime);
        }
        catch (Throwable t) {
            if (t instanceof ExecutionException) {
                t = t.getCause();
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new XltException("Failed to execute Web request", t);
        }
    }

    protected abstract T createHttpClient(WebClient var1, WebRequest var2) throws Exception;

    private O makeRequest(WebRequest webRequest) throws URISyntaxException {
        Credentials requestCredentials;
        String body;
        O request;
        List<NameValuePair> httpClientPairs;
        List<com.gargoylesoftware.htmlunit.util.NameValuePair> pairs;
        HttpMethod method = webRequest.getHttpMethod();
        Charset charset = webRequest.getCharset();
        URL url = UrlUtils.encodeUrl(webRequest.getUrl(), false, charset);
        URI uri = url.toURI();
        if (method != HttpMethod.POST && method != HttpMethod.PUT && method != HttpMethod.PATCH && method != HttpMethod.DELETE) {
            if (!webRequest.getRequestParameters().isEmpty()) {
                pairs = webRequest.getRequestParameters();
                httpClientPairs = com.gargoylesoftware.htmlunit.util.NameValuePair.toHttpClient(pairs);
                String query = URLEncodedUtils.format(httpClientPairs, (Charset)charset);
                uri = UrlUtils.toURI(url, query);
            }
            request = this.createRequestWithoutBody(uri, webRequest);
        } else if (webRequest.getEncodingType() == FormEncodingType.URL_ENCODED && method == HttpMethod.POST) {
            if (webRequest.getRequestBody() == null) {
                pairs = webRequest.getRequestParameters();
                httpClientPairs = com.gargoylesoftware.htmlunit.util.NameValuePair.toHttpClient(pairs);
                String body2 = URLEncodedUtils.format(httpClientPairs, (Charset)charset);
                request = webRequest.hasHint(WebRequest.HttpHint.IncludeCharsetInContentTypeHeader) ? this.createRequestWithStringBody(uri, webRequest, body2, "application/x-www-form-urlencoded", charset) : this.createRequestWithStringBody(uri, webRequest, body2, "application/x-www-form-urlencoded", null);
            } else {
                body = StringUtils.defaultString((String)webRequest.getRequestBody());
                request = this.createRequestWithStringBody(uri, webRequest, body, "application/x-www-form-urlencoded", charset);
            }
        } else if (webRequest.getEncodingType() == FormEncodingType.TEXT_PLAIN && method == HttpMethod.POST) {
            if (webRequest.getRequestBody() == null) {
                StringBuilder bodyBuilder = new StringBuilder();
                for (com.gargoylesoftware.htmlunit.util.NameValuePair pair : webRequest.getRequestParameters()) {
                    bodyBuilder.append(StringUtils.remove((String)StringUtils.remove((String)pair.getName(), (char)'\r'), (char)'\n')).append("=").append(StringUtils.remove((String)StringUtils.remove((String)pair.getValue(), (char)'\r'), (char)'\n')).append("\r\n");
                }
                body = bodyBuilder.toString();
            } else {
                body = StringUtils.defaultString((String)webRequest.getRequestBody());
            }
            request = this.createRequestWithStringBody(uri, webRequest, body, "text/plain", charset);
        } else {
            request = FormEncodingType.MULTIPART == webRequest.getEncodingType() ? this.createRequestWithMultiPartBody(uri, webRequest) : ((body = webRequest.getRequestBody()) == null ? this.createRequestWithoutBody(uri, webRequest) : this.createRequestWithStringBody(uri, webRequest, body, "text/plain", charset));
        }
        CredentialsProvider credentialsProvider = this.webClient.getCredentialsProvider();
        Credentials requestUrlCredentials = webRequest.getUrlCredentials();
        if (null != requestUrlCredentials && this.webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.URL_AUTH_CREDENTIALS)) {
            URL requestUrl = webRequest.getUrl();
            AuthScope authScope = new AuthScope(requestUrl.getHost(), requestUrl.getPort());
            credentialsProvider.setCredentials(authScope, requestUrlCredentials);
        }
        if (null != (requestCredentials = webRequest.getCredentials())) {
            URL requestUrl = webRequest.getUrl();
            AuthScope authScope = new AuthScope(requestUrl.getHost(), requestUrl.getPort());
            credentialsProvider.setCredentials(authScope, requestCredentials);
        }
        return request;
    }

    protected abstract O createRequestWithoutBody(URI var1, WebRequest var2);

    protected abstract O createRequestWithStringBody(URI var1, WebRequest var2, String var3, String var4, @Nullable Charset var5);

    protected abstract O createRequestWithMultiPartBody(URI var1, WebRequest var2);

    protected abstract I executeRequest(T var1, O var2) throws IOException;

    protected abstract WebResponse makeWebResponse(I var1, WebRequest var2, long var3) throws IOException;

    protected void finalizeRequestHeaders(WebRequest webRequest) {
        Map<String, String> requestHeaders = webRequest.getAdditionalHeaders();
        requestHeaders.putIfAbsent("User-Agent", this.webClient.getBrowserVersion().getUserAgent());
        if (this.webClient.getOptions().isDoNotTrackEnabled()) {
            requestHeaders.putIfAbsent("DNT", "1");
        }
    }
}

