/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.resultbrowser;

import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.xceptance.common.util.ProductInformation;
import com.xceptance.xlt.engine.har.model.HarContent;
import com.xceptance.xlt.engine.har.model.HarCreator;
import com.xceptance.xlt.engine.har.model.HarEntry;
import com.xceptance.xlt.engine.har.model.HarHeader;
import com.xceptance.xlt.engine.har.model.HarLog;
import com.xceptance.xlt.engine.har.model.HarPage;
import com.xceptance.xlt.engine.har.model.HarPageTimings;
import com.xceptance.xlt.engine.har.model.HarParam;
import com.xceptance.xlt.engine.har.model.HarPostData;
import com.xceptance.xlt.engine.har.model.HarRequest;
import com.xceptance.xlt.engine.har.model.HarResponse;
import com.xceptance.xlt.engine.har.model.HarTimings;
import com.xceptance.xlt.engine.resultbrowser.ActionInfo;
import com.xceptance.xlt.engine.resultbrowser.RequestInfo;
import com.xceptance.xlt.engine.resultbrowser.TransactionInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class HarExporter {
    private final TransactionInfo transaction;

    HarExporter(TransactionInfo aTransaction) {
        this.transaction = aTransaction;
    }

    HarLog exportToHAR() {
        ArrayList<HarPage> pages = new ArrayList<HarPage>();
        ArrayList<HarEntry> entries = new ArrayList<HarEntry>();
        for (int pageNo = 0; pageNo < this.transaction.actions.size(); ++pageNo) {
            String pageId = "page_" + pageNo;
            ActionInfo axn = this.transaction.actions.get(pageNo);
            HarPage.Builder pageBuilder = new HarPage.Builder();
            pageBuilder.withTitle(axn.name);
            pageBuilder.withId(pageId);
            long startTime = -1L;
            ActionInfo.PageLoadEventInfo contentLoadEnd = null;
            ActionInfo.PageLoadEventInfo contentLoadStart = null;
            ActionInfo.PageLoadEventInfo domInteractive = null;
            ActionInfo.PageLoadEventInfo loadEnd = null;
            ActionInfo.PageLoadEventInfo firstPaint = null;
            ActionInfo.PageLoadEventInfo firstContentfulPaint = null;
            for (ActionInfo.PageLoadEventInfo e : axn.events) {
                String name = e.name;
                if ("DomContentLoadedEventEnd".equals(name)) {
                    contentLoadEnd = e;
                } else if ("DomContentLoadEventStart".equals(name)) {
                    contentLoadStart = e;
                } else if ("DomInteractive".equals(name)) {
                    domInteractive = e;
                } else if ("LoadEventEnd".equals(name)) {
                    loadEnd = e;
                } else if ("FirstPaint".equals(name)) {
                    firstPaint = e;
                } else if ("FirstContentfulPaint".equals(name)) {
                    firstContentfulPaint = e;
                }
                if (e.startTime <= 0L || startTime >= 0L && e.startTime >= startTime) continue;
                startTime = e.startTime;
            }
            HarPageTimings.Builder timingsBuilder = new HarPageTimings.Builder();
            ActionInfo.PageLoadEventInfo contentLoaded = contentLoadEnd;
            if (contentLoaded == null) {
                contentLoaded = contentLoadStart;
            }
            if (contentLoaded == null) {
                contentLoaded = domInteractive;
            }
            timingsBuilder.withOnContentLoad(contentLoaded != null && contentLoaded.startTime > 0L ? contentLoaded.duration : -1L);
            timingsBuilder.withOnLoad(loadEnd != null && loadEnd.startTime > 0L ? loadEnd.duration : -1L);
            timingsBuilder.withFirstContentfulPaint(firstContentfulPaint != null && firstContentfulPaint.startTime > 0L ? Long.valueOf(firstContentfulPaint.duration) : null);
            timingsBuilder.withFirstPaint(firstPaint != null && firstPaint.startTime > 0L ? Long.valueOf(firstPaint.duration) : null);
            pageBuilder.withPageTimings(timingsBuilder.build());
            for (RequestInfo req : axn.requests) {
                if (startTime < 0L || req.startTime < startTime) {
                    startTime = req.startTime;
                }
                HarEntry.Builder entryBuilder = new HarEntry.Builder();
                entryBuilder.withPageref(pageId);
                entryBuilder.withTime(req.loadTime);
                entryBuilder.withStartedDateTime(new Date(req.startTime));
                entryBuilder.withTimings(this.requestTimings(req.timings));
                entryBuilder.withRequest(this.request(req));
                entryBuilder.withResponse(this.response(req));
                entries.add(entryBuilder.build());
            }
            if (startTime <= -1L) continue;
            pageBuilder.withStartedDateTime(new Date(startTime));
            pages.add(pageBuilder.build());
        }
        return new HarLog("1.2", this.creator(), null, pages, entries, null);
    }

    private HarCreator creator() {
        ProductInformation productInfo = ProductInformation.getProductInformation();
        return new HarCreator(productInfo.getProductName(), null, productInfo.getVersion());
    }

    private HarTimings requestTimings(RequestInfo.TimingInfo timings) {
        HarTimings.Builder builder = new HarTimings.Builder();
        if (timings != null) {
            builder.withBlocked(-1L);
            builder.withReceive(timings.receiveTime);
            builder.withSend(timings.sendTime);
            builder.withWait(timings.serverBusyTime);
            builder.withConnect(Long.valueOf(timings.connectTime));
            builder.withDns(Long.valueOf(timings.dnsTime));
        }
        return builder.build();
    }

    private HarRequest request(RequestInfo request) {
        HarRequest.Builder builder = new HarRequest.Builder();
        List<HarHeader> header = request.requestHeaders.stream().map(h -> new HarHeader(h.getName(), h.getValue(), null)).collect(Collectors.toList());
        String url = StringUtils.substringBefore((String)request.url, (String)"#");
        String query = StringUtils.substringAfter((String)url, (String)"?");
        boolean hasRawBody = StringUtils.isNotEmpty((CharSequence)request.requestBodyRaw);
        String method = StringUtils.defaultString((String)request.requestMethod).toUpperCase();
        builder.withHeaders(header);
        builder.withMethod(method);
        builder.withUrl(url);
        builder.withHttpVersion("HTTP/1.1");
        if (request.timings != null) {
            builder.withBodySize(request.timings.bytesSent);
        }
        if (hasRawBody || !request.requestParameters.isEmpty()) {
            HarPostData.Builder postDataBuilder = new HarPostData.Builder();
            if (hasRawBody) {
                postDataBuilder.withMimeType("text/plain");
                postDataBuilder.withText(request.requestBodyRaw);
            } else {
                postDataBuilder.withMimeType(request.formDataEncoding);
                postDataBuilder.withParams(request.requestParameters.stream().map(p -> new HarParam(p.getName(), p.getValue(), null, null, null)).collect(Collectors.toList()));
            }
            builder.withPostData(postDataBuilder.build());
        }
        try {
            builder.withQueryString(query);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder.build();
    }

    private HarResponse response(RequestInfo request) {
        HarResponse.Builder builder = new HarResponse.Builder();
        builder.withHeaders(request.responseHeaders.stream().map(h -> new HarHeader(h.getName(), h.getValue(), null)).collect(Collectors.toList()));
        builder.withHttpVersion("HTTP/1.1");
        builder.withStatus(request.responseCode);
        builder.withStatusText(StringUtils.substringAfter((String)request.status, (String)"-").trim());
        if (request.timings != null) {
            builder.withBodySize(request.timings.bytesReceived);
        }
        String redirectUrl = null;
        for (NameValuePair header : request.responseHeaders) {
            String headerName = header.getName();
            if (!"Location".equals(headerName)) continue;
            redirectUrl = header.getValue();
            break;
        }
        builder.withRedirectURL(StringUtils.defaultString(redirectUrl));
        builder.withContent(new HarContent.Builder().withMimeType(request.mimeType).build());
        return builder.build();
    }
}

