/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.resultbrowser;

import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.common.xml.DomUtils;
import com.xceptance.xlt.api.htmlunit.LightWeightPage;
import com.xceptance.xlt.engine.LightWeightPageImpl;
import com.xceptance.xlt.engine.XltWebClient;
import com.xceptance.xlt.engine.resultbrowser.PageDOMClone;
import com.xceptance.xlt.engine.resultbrowser.UrlMapping;
import com.xceptance.xlt.engine.util.CssUtils;
import com.xceptance.xlt.engine.util.LWPageUtilities;
import com.xceptance.xlt.engine.util.TimerUtils;
import com.xceptance.xlt.engine.util.URLCleaner;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class PageTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageTransformer.class);
    private final PageDOMClone htmlPage;
    private final LightWeightPage lwPage;
    private final boolean outermostPage;

    PageTransformer(PageDOMClone page, boolean outermost) {
        this.htmlPage = page;
        this.lwPage = null;
        this.outermostPage = outermost;
    }

    PageTransformer(LightWeightPage page) {
        this.lwPage = page;
        this.htmlPage = null;
        this.outermostPage = ((LightWeightPageImpl)page).getEnclosingPage() == null;
    }

    Document transform(UrlMapping mapping) {
        long start = TimerUtils.getTime();
        Document document = this.htmlPage.getDocument();
        this.removeJSHandlerAttrs(document.getElementsByTagName("body").item(0));
        DomUtils.removeElementsByTagName(document, "script");
        DomUtils.removeElementsByTagName(document, "base");
        Element head = (Element)document.getElementsByTagName("head").item(0);
        if (head == null) {
            head = document.createElement("head");
            Element html = document.getDocumentElement();
            if (html == null) {
                html = document.createElement("html");
                document.appendChild(html);
            }
            html.insertBefore(head, html.getFirstChild());
        } else {
            NodeList metaTags = head.getElementsByTagName("meta");
            for (int i = 0; i < metaTags.getLength(); ++i) {
                Element metaTag = (Element)metaTags.item(i);
                NamedNodeMap attributes = metaTag.getAttributes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Attr attribute = (Attr)attributes.item(j);
                    if (!attribute.getName().equalsIgnoreCase("http-equiv") || !attribute.getValue().equalsIgnoreCase("content-type")) continue;
                    metaTag.getParentNode().removeChild(metaTag);
                }
            }
        }
        Element meta = document.createElement("meta");
        meta.setAttribute("http-equiv", "content-type");
        meta.setAttribute("content", this.htmlPage.getResponse().getContentType() + "; charset=utf-8");
        head.insertBefore(meta, head.getFirstChild());
        long urlRewriteStart = TimerUtils.getTime();
        this.rewriteUrls(document, "img", "src", mapping);
        this.rewriteUrls(document, "input", "src", mapping);
        this.rewriteUrls(document, "link", "href", mapping);
        this.rewriteInlineCssUrls(document, mapping);
        long end = TimerUtils.getTime();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Transformation took: " + (end - start) + "ms [URL-Rewriting: " + (end - urlRewriteStart) + "ms].");
        }
        return document;
    }

    private void rewriteUrls(Document document, String tagName, String attributeName, UrlMapping mapping) {
        NodeList nodes = document.getElementsByTagName(tagName);
        String urlPrefix = this.outermostPage ? "cache/" : "";
        Charset charset = this.htmlPage.getResponse().getContentCharset();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String newUrl;
            String attValue;
            URL u;
            Element element = (Element)nodes.item(i);
            Attr attribute = element.getAttributeNode(attributeName);
            if (attribute == null || (u = this.htmlPage.getFullyQualifiedUrl(attValue = attribute.getValue())) == null || (newUrl = mapping.map(UrlUtils.encodeUrl(u, false, charset))) == null) continue;
            attribute.setValue(urlPrefix + newUrl);
        }
    }

    private void rewriteInlineCssUrls(Document doc, UrlMapping mapping) {
        NodeList styleTags = doc.getElementsByTagName("style");
        for (int i = 0; i < styleTags.getLength(); ++i) {
            Element styleTag = (Element)styleTags.item(i);
            styleTag.setTextContent(this.rewriteInlineCssUrls(styleTag.getTextContent(), mapping));
        }
        NodeList childNodes = doc.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            this.rewriteInlineCssUrls(childNodes.item(i), mapping);
        }
    }

    private void rewriteInlineCssUrls(Node node, UrlMapping mapping) {
        Node styleAttrValNode;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (styleAttrValNode = attributes.getNamedItem("style")) != null) {
            styleAttrValNode.setNodeValue(this.rewriteInlineCssUrls(styleAttrValNode.getTextContent(), mapping));
        }
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            this.rewriteInlineCssUrls(childNodes.item(i), mapping);
        }
    }

    private String rewriteInlineCssUrls(String cssContent, UrlMapping mapping) {
        WebResponse response = this.htmlPage.getResponse();
        Charset charset = response.getContentCharset();
        String newContent = cssContent;
        String urlPrefix = this.outermostPage ? "cache/" : "";
        for (String urlString : CssUtils.getUrlStrings(cssContent)) {
            String newUrl;
            URL url = this.htmlPage.getFullyQualifiedUrl(urlString);
            if (url == null || (newUrl = mapping.map(UrlUtils.encodeUrl(url, false, charset))) == null) continue;
            Pattern p = RegExUtils.getPattern("(['\"\\(])\\s*" + RegExUtils.escape(urlString) + "\\s*(['\"\\)])");
            String newUrlPattern = "$1" + urlPrefix + newUrl + "$2";
            newContent = p.matcher(newContent).replaceAll(newUrlPattern);
        }
        return newContent;
    }

    String transformLW(UrlMapping mapping) {
        URL u;
        long start = TimerUtils.getTime();
        String pageContent = this.lwPage.getContent();
        if (pageContent == null || pageContent.length() == 0) {
            return pageContent;
        }
        HashSet<String> urlStrings = new HashSet<String>();
        String uncommentedPageContent = LWPageUtilities.removeHtmlComments(pageContent);
        urlStrings.addAll(LWPageUtilities.getAllLinkLinks(uncommentedPageContent));
        urlStrings.addAll(LWPageUtilities.getAllImageLinks(uncommentedPageContent));
        urlStrings.addAll(LWPageUtilities.getAllImageInputLinks(uncommentedPageContent));
        urlStrings.addAll(LWPageUtilities.getAllScriptLinks(uncommentedPageContent));
        urlStrings.addAll(LWPageUtilities.getAllInlineCssResourceUrls(uncommentedPageContent));
        URL baseURL = this.lwPage.getWebResponse().getWebRequest().getUrl();
        List<String> baseLinks = LWPageUtilities.getAllBaseLinks(uncommentedPageContent);
        if (!baseLinks.isEmpty() && (u = XltWebClient.makeUrlAbsolute(baseURL, baseLinks.get(0))) != null) {
            baseURL = u;
        }
        baseURL = URLCleaner.removeUserInfoIfNecessaryAsURL(baseURL);
        Charset charset = this.lwPage.getCharset();
        String newContent = pageContent;
        newContent = LWPageUtilities.removeAllBaseTags(newContent);
        newContent = LWPageUtilities.removeAllScriptTags(newContent);
        newContent = RegExUtils.replaceAll(newContent, "(?im)<meta [^>]*?http-equiv=\"content-type\".*?>", "");
        newContent = RegExUtils.replaceAll(newContent, "(?im)<head.*?>", "$0\n<meta http-equiv=\"content-type\" content=\"" + this.lwPage.getWebResponse().getContentType() + "; charset=utf-8\" />");
        newContent = this.removeJSHandlerAttrs(newContent);
        String urlPrefix = this.outermostPage ? "cache/" : "";
        long urlRewriteStart = TimerUtils.getTime();
        for (String string : urlStrings) {
            String crcString;
            URL url = XltWebClient.makeUrlAbsolute(baseURL, string);
            if (url == null || (crcString = mapping.map(UrlUtils.encodeUrl(url, false, charset))) == null) continue;
            String pattern = "(['\"\\(])\\s*" + RegExUtils.escape(string) + "\\s*(['\"\\)])";
            String cacheUrlString = urlPrefix + crcString;
            newContent = RegExUtils.replaceAll(newContent, pattern, "$1" + cacheUrlString + "$2");
        }
        for (Map.Entry entry : ((LightWeightPageImpl)this.lwPage).getFramePages().entrySet()) {
            String frameName = (String)entry.getKey();
            LightWeightPageImpl framePage = (LightWeightPageImpl)entry.getValue();
            String cacheUrlString = urlPrefix + frameName + ".html";
            String pattern = "(<i?frame [^>]*?src=\")" + RegExUtils.escape(framePage.getSource()) + "\"";
            newContent = RegExUtils.replaceAll(newContent, pattern, "$1" + cacheUrlString + "\"");
        }
        long end = TimerUtils.getTime();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Transformation took: " + (end - start) + "ms [URL-Rewriting: " + (end - urlRewriteStart) + "ms].");
        }
        return newContent;
    }

    private Collection<String> getAttrNames(NamedNodeMap attrs) {
        HashSet<String> names = new HashSet<String>();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                names.add(attrs.item(i).getNodeName());
            }
        }
        return names;
    }

    private void removeJSHandlerAttrs(Node node) {
        if (node != null) {
            NamedNodeMap attrs = node.getAttributes();
            for (String attName : this.getAttrNames(attrs)) {
                if (!attName.startsWith("on")) continue;
                attrs.removeNamedItem(attName);
            }
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.removeJSHandlerAttrs(children.item(i));
            }
        }
    }

    private String removeJSHandlerAttrs(String htmlContent) {
        if (htmlContent == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(htmlContent.length());
        Matcher m = RegExUtils.getPattern("(?sm)<[^/].*?>").matcher(htmlContent);
        int start = 0;
        while (m.find()) {
            sb.append(htmlContent.substring(start, m.start()));
            sb.append(RegExUtils.replaceAll(m.group(), "\\s+on\\w+\\s*=\\s*\"[^\"]*?\"", ""));
            start = m.end();
        }
        sb.append(htmlContent.substring(Math.min(start, htmlContent.length() - 1), htmlContent.length()));
        return sb.toString();
    }
}

