/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting;

import com.xceptance.xlt.api.util.XltRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MacroProcessor {
    private final Map<String, Macro> macros;
    private final Pattern MACRO_PATTERN = Pattern.compile("^(.+?)\\((.*?)\\)$");

    private MacroProcessor() {
        this.macros = new HashMap<String, Macro>();
        this.macros.put("NOW", new Macro(){

            @Override
            public String execute(String ... arguments) {
                return Long.toString(new Date().getTime());
            }
        });
        this.macros.put("RANDOM.String", new Macro(){

            @Override
            public String execute(String ... arguments) {
                String chars = "abcdefghijklmnopqrstuvwxyz";
                int length = 0;
                if (arguments.length > 0) {
                    try {
                        length = Integer.parseInt(arguments[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (length < 0) {
                    length = 0;
                }
                StringBuilder sb = new StringBuilder(length);
                for (int i = 0; i < length; ++i) {
                    sb.append("abcdefghijklmnopqrstuvwxyz".charAt(XltRandom.nextInt("abcdefghijklmnopqrstuvwxyz".length())));
                }
                return sb.toString();
            }
        });
        this.macros.put("RANDOM.Number", new Macro(){

            @Override
            public String execute(String ... arguments) {
                if (arguments != null && arguments.length > 0) {
                    int arg0 = 0;
                    try {
                        arg0 = Math.max(arg0, Integer.parseInt(arguments[0]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (arguments.length == 2) {
                        int max = 0;
                        try {
                            max = Math.max(arg0, Integer.parseInt(arguments[1]));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        return Integer.toString(XltRandom.nextInt(arg0, max));
                    }
                    if (arguments.length == 1) {
                        return Integer.toString(XltRandom.nextInt(arg0));
                    }
                }
                return "";
            }
        });
    }

    public boolean isMacro(String macroStatement) {
        return this.macros.containsKey(this.getMacroName(macroStatement));
    }

    public String executeMacro(String macroStatement) {
        Macro macro = this.macros.get(this.getMacroName(macroStatement));
        if (macro == null) {
            throw new IllegalArgumentException("Macro statement '" + macroStatement + "' could not be recognized as valid macro");
        }
        return macro.execute(this.getMacroArguments(macroStatement));
    }

    public static MacroProcessor getInstance() {
        return Singleton_Holder._INSTANCE;
    }

    private String getMacroName(String macroStatement) {
        Matcher m = this.MACRO_PATTERN.matcher(macroStatement);
        if (m.matches()) {
            return m.group(1);
        }
        return macroStatement;
    }

    private String[] getMacroArguments(String macroStatement) {
        Matcher m = this.MACRO_PATTERN.matcher(macroStatement);
        if (m.matches()) {
            String[] args = m.group(2).split(",");
            for (int i = 0; i < args.length; ++i) {
                args[i] = args[i].trim();
            }
            return args;
        }
        return new String[0];
    }

    private abstract class Macro {
        private Macro() {
        }

        public abstract String execute(String ... var1);
    }

    private static class Singleton_Holder {
        private static final MacroProcessor _INSTANCE = new MacroProcessor();

        private Singleton_Holder() {
        }
    }
}

