/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.docgen;

import com.xceptance.common.util.AbstractConfiguration;
import com.xceptance.xlt.engine.XltExecutionContext;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ScriptDocGeneratorConfiguration
extends AbstractConfiguration {
    private final Map<String, String> templates;
    private final File templateDir;
    private final File resourceDir;

    public ScriptDocGeneratorConfiguration(Properties commandLineProperties) throws IOException {
        File templateDirectory;
        File configDirectory = XltExecutionContext.getCurrent().getXltConfigDir();
        this.loadProperties(new File(configDirectory, "scriptdocgenerator.properties"));
        if (commandLineProperties != null) {
            this.addProperties(commandLineProperties);
        }
        if (!(templateDirectory = this.getFileProperty("com.xceptance.xlt.scriptdocgenerator.templateDirectory")).isAbsolute()) {
            templateDirectory = new File(configDirectory, templateDirectory.getPath());
        }
        ScriptDocGeneratorConfiguration.isReadableDir(templateDirectory, "Template directory");
        File resourceDirectory = this.getFileProperty("com.xceptance.xlt.scriptdocgenerator.resourceDirectory");
        if (!resourceDirectory.isAbsolute()) {
            resourceDirectory = new File(configDirectory, resourceDirectory.getPath());
        }
        ScriptDocGeneratorConfiguration.isReadableDir(resourceDirectory, "Resource directory");
        this.templateDir = templateDirectory;
        this.resourceDir = resourceDirectory;
        this.templates = this.readTemplateMapping();
    }

    private Map<String, String> readTemplateMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        String prefix = "com.xceptance.xlt.scriptdocgenerator.templates.";
        for (String s : this.getPropertyKeyFragment("com.xceptance.xlt.scriptdocgenerator.templates.")) {
            String prop = "com.xceptance.xlt.scriptdocgenerator.templates." + s;
            File templateFile = this.getFileProperty(prop + ".templateFileName");
            File outputFile = this.getFileProperty(prop + ".outputFileName");
            mapping.put(templateFile.getPath(), outputFile.getPath());
        }
        return mapping;
    }

    public File getTemplateDir() {
        return this.templateDir;
    }

    public File getResourceDir() {
        return this.resourceDir;
    }

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    private static void isReadableDir(File dir, String dirDesc) {
        if (!dir.exists()) {
            throw new IllegalArgumentException(dirDesc + " '" + dir.getAbsolutePath() + "' does not exist.");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dirDesc + " '" + dir.getAbsolutePath() + "' is not a directory.");
        }
        if (!dir.canRead()) {
            throw new IllegalArgumentException(dirDesc + " '" + dir.getAbsolutePath() + "' cannot be read.");
        }
    }
}

