/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.htmlunit;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.xceptance.xlt.engine.scripting.htmlunit.ElementFinder;
import com.xceptance.xlt.engine.scripting.htmlunit.NoSuchElementException;
import com.xceptance.xlt.engine.scripting.htmlunit.OptionFinder;
import com.xceptance.xlt.engine.scripting.htmlunit.WindowFinder;
import java.util.List;
import java.util.regex.Pattern;

public final class HtmlUnitFinder {
    static final Pattern STRATEGY_PATTERN = Pattern.compile("^(\\p{Alpha}+)=(.*)");
    private final ElementFinder finder = new ElementFinder(false);
    private final OptionFinder optionFinder = new OptionFinder();
    private final ElementFinder visibleFinder = new ElementFinder(true);
    private final WindowFinder windowFinder = new WindowFinder();

    public HtmlElement findElement(HtmlPage page, String locator) {
        return this.findElement(page, locator, false);
    }

    public HtmlElement findElement(HtmlPage page, String locator, boolean visibleElementsOnly) {
        return this.getFinder(visibleElementsOnly).find(page, locator);
    }

    public List<HtmlElement> findElements(HtmlPage page, String locator, boolean visibleElementsOnly) {
        return this.getFinder(visibleElementsOnly).findAll(page, locator);
    }

    public List<HtmlElement> findElements(HtmlPage page, String locator) {
        return this.findElements(page, locator, false);
    }

    public HtmlOption findOption(HtmlSelect select, String optionLocator) {
        return this.optionFinder.findOption(select, optionLocator);
    }

    public List<HtmlOption> findOptions(HtmlSelect select, String optionLocator) {
        return this.optionFinder.findOptions(select, optionLocator);
    }

    public WebWindow findWindow(WebClient webClient, String windowLocator) {
        return this.windowFinder.find(webClient, windowLocator);
    }

    public boolean isElementPresent(HtmlPage page, String locator) {
        try {
            this.findElement(page, locator, false);
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    private ElementFinder getFinder(boolean visibleElementsOnly) {
        return visibleElementsOnly ? this.visibleFinder : this.finder;
    }
}

