/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.htmlunit;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.xceptance.xlt.engine.scripting.htmlunit.HtmlUnitFinder;
import com.xceptance.xlt.engine.scripting.htmlunit.IllegalLocatorException;
import com.xceptance.xlt.engine.scripting.htmlunit.NoSuchWindowException;
import com.xceptance.xlt.engine.scripting.util.TextMatchingUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;

class WindowFinder {
    private static final Strategy IMPLICIT_STRATEGY = new ImplicitStrategy();
    private static final Strategy NAME_STRATEGY = new NameStrategy();
    private static final Strategy TITLE_STRATEGY = new TitleStrategy();
    private final Map<String, Strategy> strategies = new HashMap<String, Strategy>();

    WindowFinder() {
        this.strategies.put("name", NAME_STRATEGY);
        this.strategies.put("title", TITLE_STRATEGY);
        this.strategies.put("implicit", IMPLICIT_STRATEGY);
    }

    WebWindow find(WebClient webClient, String windowLocator) {
        String value;
        String strategyName;
        Matcher m = HtmlUnitFinder.STRATEGY_PATTERN.matcher(windowLocator);
        if (m.matches()) {
            strategyName = m.group(1);
            value = m.group(2);
        } else {
            strategyName = "implicit";
            value = windowLocator;
        }
        Strategy strategy = this.strategies.get(strategyName);
        if (strategy == null) {
            throw new IllegalLocatorException("Unknown window locator strategy: " + strategyName);
        }
        WebWindow windowHandle = strategy.find(webClient, value);
        if (windowHandle == null) {
            throw new NoSuchWindowException("No window found for locator: " + windowLocator);
        }
        return windowHandle;
    }

    private static final class TitleStrategy
    extends Strategy {
        private TitleStrategy() {
        }

        @Override
        protected WebWindow find(WebClient webClient, String windowTitle) {
            for (WebWindow webWindow : webClient.getTopLevelWindows()) {
                Page page = webWindow.getEnclosedPage();
                if (!(page instanceof HtmlPage) || !TextMatchingUtils.isAMatch(((HtmlPage)page).getTitleText(), windowTitle, true, true)) continue;
                return webWindow;
            }
            return null;
        }
    }

    private static final class NameStrategy
    extends Strategy {
        private NameStrategy() {
        }

        @Override
        protected WebWindow find(WebClient webClient, String windowName) {
            for (WebWindow webWindow : webClient.getTopLevelWindows()) {
                if (!TextMatchingUtils.isAMatch(webWindow.getName(), windowName, true, true)) continue;
                return webWindow;
            }
            return null;
        }
    }

    private static final class ImplicitStrategy
    extends Strategy {
        private ImplicitStrategy() {
        }

        @Override
        protected WebWindow find(WebClient webClient, String nameOrTitle) {
            WebWindow w = NAME_STRATEGY.find(webClient, nameOrTitle);
            if (w == null) {
                w = TITLE_STRATEGY.find(webClient, nameOrTitle);
            }
            return w;
        }
    }

    private static abstract class Strategy {
        private Strategy() {
        }

        protected abstract WebWindow find(WebClient var1, String var2);
    }
}

