/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.util;

import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.PageStatistics;
import com.xceptance.xlt.engine.TimeoutException;
import com.xceptance.xlt.engine.scripting.ScriptException;
import com.xceptance.xlt.engine.scripting.TestContext;
import com.xceptance.xlt.engine.scripting.util.CommonScriptCommands;
import com.xceptance.xlt.engine.scripting.util.Condition;
import com.xceptance.xlt.engine.scripting.util.NoSuchElementAttributeException;
import com.xceptance.xlt.engine.scripting.util.ReplayUtils;
import com.xceptance.xlt.engine.scripting.util.TextMatchingUtils;
import com.xceptance.xlt.engine.util.TimerUtils;
import com.xceptance.xlt.engine.util.URLInfo;
import com.xceptance.xlt.engine.util.UrlUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommandAdapter
implements CommonScriptCommands {
    protected static final Pattern FRAME_INDEX_PATTERN = Pattern.compile("^index=\\d+$");
    protected static final Pattern FRAME_NAME_LOCATOR_PATTERN;
    protected static final Pattern FRAME_NAME_PATTERN;
    protected static final Pattern VARIABLE_PATTERN;
    protected static final Pattern ATT_LOCATOR_PATTERN;
    public static final Logger LOGGER;

    @Override
    public void assertAttribute(String attributeLocator, String textPattern) {
        this.assureCondition(this.attributeMatches(attributeLocator, textPattern, true));
    }

    @Override
    public void assertAttribute(String elementLocator, String attributeName, String textPattern) {
        this.assureCondition(this.attributeMatches(elementLocator, attributeName, textPattern, true));
    }

    @Override
    public void assertClass(String elementLocator, String clazzString) {
        this.assureCondition(this.classMatches(elementLocator, clazzString, true));
    }

    @Override
    public void assertElementCount(String elementLocator, int count) {
        this.executeRunnable(count == 0, () -> this.assureCondition(this.elementCountEqual(elementLocator, count, true)));
    }

    @Override
    public void assertElementCount(String elementLocator, String count) {
        this.assertElementCount(elementLocator, Integer.parseInt(count));
    }

    @Override
    public void assertElementPresent(String elementLocator) {
        this.assureCondition(this.elementPresent(elementLocator, true));
    }

    @Override
    public void assertEval(String expression, String textPattern) {
        this.assureCondition(this.evalMatches(expression, textPattern, true));
    }

    @Override
    public void assertLoadTime(long maxLoadTime) {
        Assert.assertFalse((String)"Page load time exceeded", (PageStatistics.getPageStatistics().getLoadTime() > maxLoadTime ? 1 : 0) != 0);
    }

    @Override
    public void assertLoadTime(String maxLoadTime) {
        this.assertLoadTime(Long.parseLong(maxLoadTime));
    }

    @Override
    public void assertNotAttribute(String attributeLocator, String textPattern) {
        this.assureCondition(this.attributeMatches(attributeLocator, textPattern, false));
    }

    @Override
    public void assertNotAttribute(String elementLocator, String attributeName, String textPattern) {
        this.assureCondition(this.attributeMatches(elementLocator, attributeName, textPattern, false));
    }

    @Override
    public void assertNotClass(String elementLocator, String clazzString) {
        this.assureCondition(this.classMatches(elementLocator, clazzString, false));
    }

    @Override
    public void assertNotElementCount(String elementLocator, int count) {
        this.executeRunnable(count != 0, () -> this.assureCondition(this.elementCountEqual(elementLocator, count, false)));
    }

    @Override
    public void assertNotElementCount(String elementLocator, String count) {
        this.assertNotElementCount(elementLocator, Integer.parseInt(count));
    }

    @Override
    public void assertNotElementPresent(String elementLocator) {
        this.executeRunnable(true, () -> this.assureCondition(this.elementPresent(elementLocator, false)));
    }

    @Override
    public void assertNotEval(String expression, String textPattern) {
        this.assureCondition(this.evalMatches(expression, textPattern, false));
    }

    @Override
    public void assertNotText(String elementLocator, String textPattern) {
        this.assureCondition(this.textMatches(elementLocator, textPattern, false));
    }

    @Override
    public void assertNotTextPresent(String textPattern) {
        this.assureCondition(this.pageTextMatches(textPattern, false));
    }

    @Override
    public void assertNotTitle(String titlePattern) {
        this.assureCondition(this.titleMatches(titlePattern, false));
    }

    @Override
    public void assertNotXpathCount(String xpath, int count) {
        this.executeRunnable(count != 0, () -> this.assureCondition(this.xpathCountEqual(xpath, count, false)));
    }

    @Override
    public void assertNotXpathCount(String xpath, String count) {
        this.assertNotXpathCount(xpath, Integer.parseInt(count));
    }

    @Override
    public void assertPageSize(long maxPageSize) {
        Assert.assertFalse((String)"Page size exceeded", (PageStatistics.getPageStatistics().getTotalBytes() > maxPageSize ? 1 : 0) != 0);
    }

    @Override
    public void assertPageSize(String maxPageSize) {
        this.assertPageSize(Long.parseLong(maxPageSize));
    }

    @Override
    public boolean hasText(String elementLocator, String textPattern) {
        return this.textMatches(elementLocator, textPattern, true).isTrue();
    }

    @Override
    public boolean hasValue(String elementLocator, String valuePattern) {
        return this.valueMatches(elementLocator, valuePattern, true).isTrue();
    }

    @Override
    public void assertText(String elementLocator, String textPattern) {
        this.assureCondition(this.textMatches(elementLocator, textPattern, true));
    }

    @Override
    public void assertValue(String elementLocator, String valuePattern) {
        this.assureCondition(this.valueMatches(elementLocator, valuePattern, true));
    }

    @Override
    public void assertNotValue(String elementLocator, String valuePattern) {
        this.assureCondition(this.valueMatches(elementLocator, valuePattern, false));
    }

    @Override
    public boolean isTextPresent(String textPattern) {
        return this.pageTextMatches(textPattern, true).isTrue();
    }

    @Override
    public void assertTextPresent(String textPattern) {
        this.assureCondition(this.pageTextMatches(textPattern, true));
    }

    @Override
    public boolean hasTitle(String title) {
        return this.titleMatches(title, true).isTrue();
    }

    @Override
    public void assertTitle(String title) {
        this.assureCondition(this.titleMatches(title, true));
    }

    @Override
    public void assertXpathCount(String xpath, int count) {
        this.executeRunnable(count == 0, () -> this.assureCondition(this.xpathCountEqual(xpath, count, true)));
    }

    @Override
    public void assertXpathCount(String xpath, String count) {
        this.assertXpathCount(xpath, Integer.parseInt(count));
    }

    @Override
    public void echo(String message) {
        this.checkIsTrue("Invalid message: " + message, message != null);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("echo : " + message);
        }
    }

    @Override
    public void setTimeout(long timeout) {
        TestContext.getCurrent().setTimeout(timeout);
    }

    @Override
    public void setTimeout(String timeout) {
        this.setTimeout(Long.parseLong(timeout));
    }

    @Override
    public void store(String text, String variableName) {
        this.checkVariable(variableName);
        this.checkIsTrue("Cannot store null reference", text != null);
        TestContext.getCurrent().storeValue(variableName, text);
    }

    @Override
    public void storeElementCount(String elementLocator, String variableName) {
        this.checkVariable(variableName);
        int nbElements = this.getElementCount(elementLocator);
        TestContext.getCurrent().storeValue(variableName, Integer.toString(nbElements));
    }

    @Override
    public void storeEval(String expression, String variable) {
        this.checkVariable(variable);
        String result = this.evaluate(expression);
        this.checkIsTrue("Failed to evaluate expression '" + expression + "'", result != null);
        TestContext.getCurrent().storeValue(variable, result);
    }

    @Override
    public void storeText(String locator, String variable) {
        this.checkVariable(variable);
        String elementText = this.getText(locator);
        TestContext.getCurrent().storeValue(variable, elementText);
    }

    @Override
    public void storeTitle(String variable) {
        this.checkVariable(variable);
        String title = this.getTitle();
        TestContext.getCurrent().storeValue(variable, title);
    }

    @Override
    public void storeValue(String elementLocator, String variableName) {
        this.checkVariable(variableName);
        String elementText = this.getValue(elementLocator);
        TestContext.getCurrent().storeValue(variableName, elementText);
    }

    @Override
    public void storeXpathCount(String xpath, String variable) {
        this.checkVariable(variable);
        int nbElements = this.getXpathCount(xpath);
        TestContext.getCurrent().storeValue(variable, Integer.toString(nbElements));
    }

    @Override
    public void storeAttribute(String attributeLocator, String variable) {
        this.checkVariable(variable);
        String attributeValue = this.getAttribute(attributeLocator);
        TestContext.getCurrent().storeValue(variable, attributeValue);
    }

    @Override
    public void storeAttribute(String elementLocator, String attributeName, String variable) {
        this.checkVariable(variable);
        String attributeValue = this.getAttribute(elementLocator, attributeName);
        TestContext.getCurrent().storeValue(variable, attributeValue);
    }

    protected void checkAttributeName(String attributeName) {
        this.checkIsTrue("Attribute name must not be blank", StringUtils.isNotBlank((CharSequence)attributeName));
    }

    protected void checkVariable(String variable) {
        this.checkIsTrue("Name of variable '" + variable + "' is invalid", RegExUtils.isMatching(variable, VARIABLE_PATTERN));
    }

    protected void checkAttributeLocator(String attributeLocator) {
        this.checkIsTrue("Attribute locator '" + attributeLocator + "' is invalid", RegExUtils.isMatching(attributeLocator, ATT_LOCATOR_PATTERN));
    }

    protected void checkElementLocator(String elementLocator) {
        this.checkIsTrue("Element locator is null", elementLocator != null);
    }

    protected void checkIsEqual(String message, Object expected, Object actual) {
        if (!(actual == expected || actual != null && actual.equals(expected))) {
            throw new XltException(message);
        }
    }

    protected void checkIsTrue(String message, boolean flag) {
        if (!flag) {
            throw new XltException(message);
        }
    }

    protected URL rewriteUrl(String urlString) {
        XltProperties props = XltProperties.getInstance();
        String protocol = props.getProperty("startUrl.protocol", "");
        String userInfo = props.getProperty("startUrl.userInfo", "");
        String host = props.getProperty("startUrl.host", "");
        int port = props.getProperty("startUrl.port", -1);
        String path = props.getProperty("startUrl.path", "");
        String query = props.getProperty("startUrl.query", "");
        String fragment = props.getProperty("startUrl.fragment", "");
        URLInfo urlInfo = URLInfo.builder().proto(protocol).userInfo(userInfo).host(host).port(port).path(path).query(query).fragment(fragment).build();
        try {
            return UrlUtils.rewriteUrl(urlString, urlInfo);
        }
        catch (Exception e) {
            throw new ScriptException("Failed to rewrite URL", e);
        }
    }

    protected void waitForCondition(Condition condition) {
        this.waitForCondition(condition, TestContext.getCurrent().getTimeout());
    }

    protected void waitForCondition(Condition condition, long maxWaitingTime) {
        long end = TimerUtils.getTime() + (maxWaitingTime < 0L ? TestContext.getCurrent().getTimeout() : maxWaitingTime);
        do {
            try {
                if (condition.isTrue()) {
                    return;
                }
            }
            catch (Exception e) {
                for (Throwable t = e; t != null; t = t.getCause()) {
                    if (!(t instanceof InterruptedException)) continue;
                    throw new ScriptException("Interrupted while waiting for condition", e);
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                throw new ScriptException("Interrupted while waiting for condition", ie);
            }
        } while (TimerUtils.getTime() < end);
        throw new TimeoutException("Timed out while waiting for condition: " + condition.getReason());
    }

    protected abstract List<String> getSelectedIds(String var1);

    protected abstract List<Integer> getSelectedIndices(String var1);

    protected abstract List<String> getSelectedLabels(String var1);

    protected abstract List<String> getSelectedValues(String var1);

    public boolean isSelectedId(String selectLocator, String idPattern) {
        return this.idSelected(selectLocator, idPattern, true).isTrue();
    }

    @Override
    public void assertSelectedId(String selectLocator, String idPattern) {
        this.assureCondition(this.idSelected(selectLocator, idPattern, true));
    }

    @Override
    public void assertNotSelectedId(String selectLocator, String idPattern) {
        this.assureCondition(this.idSelected(selectLocator, idPattern, false));
    }

    public boolean isSelectedIndex(String selectLocator, String indexPattern) {
        return this.indexSelected(selectLocator, indexPattern, true).isTrue();
    }

    @Override
    public void assertSelectedIndex(String selectLocator, String indexPattern) {
        this.assureCondition(this.indexSelected(selectLocator, indexPattern, true));
    }

    @Override
    public void assertNotSelectedIndex(String selectLocator, String indexPattern) {
        this.assureCondition(this.indexSelected(selectLocator, indexPattern, false));
    }

    public boolean isSelectedLabel(String selectLocator, String labelPattern) {
        return this.labelSelected(selectLocator, labelPattern, true).isTrue();
    }

    @Override
    public void assertSelectedLabel(String selectLocator, String labelPattern) {
        this.assureCondition(this.labelSelected(selectLocator, labelPattern, true));
    }

    @Override
    public void assertNotSelectedLabel(String selectLocator, String labelPattern) {
        this.assureCondition(this.labelSelected(selectLocator, labelPattern, false));
    }

    public boolean isSelectedValue(String selectLocator, String valuePattern) {
        return this.valueSelected(selectLocator, valuePattern, true).isTrue();
    }

    @Override
    public void assertSelectedValue(String selectLocator, String valuePattern) {
        this.assureCondition(this.valueSelected(selectLocator, valuePattern, true));
    }

    @Override
    public void assertNotSelectedValue(String selectLocator, String valuePattern) {
        this.assureCondition(this.valueSelected(selectLocator, valuePattern, false));
    }

    @Override
    public void assertVisible(String elementLocator) {
        this.assureCondition(this.elementVisible(elementLocator, true));
    }

    @Override
    public void assertNotVisible(String elementLocator) {
        this.assureCondition(this.elementVisible(elementLocator, false));
    }

    @Override
    public void assertChecked(String elementLocator) {
        this.assureCondition(this.elementChecked(elementLocator, true));
    }

    @Override
    public void assertNotChecked(String elementLocator) {
        this.assureCondition(this.elementChecked(elementLocator, false));
    }

    @Override
    public void assertStyle(String elementLocator, String style) {
        this.assureCondition(this.styleMatches(elementLocator, style, true));
    }

    @Override
    public void assertNotStyle(String elementLocator, String style) {
        this.assureCondition(this.styleMatches(elementLocator, style, false));
    }

    @Override
    public boolean isEvalMatching(String expression, String textPattern) {
        return this.evalMatches(expression, textPattern, true).isTrue();
    }

    @Override
    public boolean hasAttribute(String attributeLocator, String textPattern) {
        return this.attributeMatches(attributeLocator, textPattern, true).isTrue();
    }

    @Override
    public boolean hasAttribute(String elementLocator, String attributeName, String textPattern) {
        return this.attributeMatches(elementLocator, attributeName, textPattern, true).isTrue();
    }

    protected abstract String _getEffectiveStyle(String var1, String var2);

    @Override
    public boolean hasStyle(String elementLocator, String style) {
        return this.styleMatches(elementLocator, style, true).isTrue();
    }

    @Override
    public boolean hasNotStyle(String elementLocator, String style) {
        return this.styleMatches(elementLocator, style, false).isTrue();
    }

    @Override
    public boolean hasClass(String elementLocator, String clazz) {
        return this.classMatches(elementLocator, clazz, true).isTrue();
    }

    @Override
    public boolean hasNotClass(String elementLocator, String clazz) {
        return this.classMatches(elementLocator, clazz, false).isTrue();
    }

    @Override
    public String evaluate(String jsExpression) {
        this.checkIsTrue("Expression is null", jsExpression != null);
        return this._evaluate(jsExpression);
    }

    @Override
    public boolean evaluatesToTrue(String jsExpression) {
        if (StringUtils.isBlank((CharSequence)jsExpression)) {
            return false;
        }
        String result = this.evaluate("!!(".concat(jsExpression).concat(")"));
        this.checkIsTrue("Failed to evaluate expression: " + jsExpression, result != null);
        return Boolean.valueOf(result);
    }

    @Override
    public String getAttribute(String attributeLocator) {
        this.checkAttributeLocator(attributeLocator);
        return this._getAttribute(attributeLocator);
    }

    @Override
    public String getAttribute(String elementLocator, String attributeName) {
        this.checkElementLocator(elementLocator);
        this.checkAttributeName(attributeName);
        return this._getAttribute(elementLocator, attributeName);
    }

    @Override
    public int getElementCount(String elementLocator) {
        this.checkElementLocator(elementLocator);
        return this._getElementCount(elementLocator);
    }

    @Override
    public String getText(String elementLocator) {
        this.checkElementLocator(elementLocator);
        return this._getText(elementLocator);
    }

    @Override
    public String getValue(String elementLocator) {
        this.checkElementLocator(elementLocator);
        return this._getValue(elementLocator);
    }

    @Override
    public int getXpathCount(String xpath) {
        this.checkIsTrue("XPath expression is null", xpath != null);
        return this._getXpathCount(xpath);
    }

    @Override
    public boolean isChecked(String elementLocator) {
        this.checkElementLocator(elementLocator);
        return this._isChecked(elementLocator);
    }

    @Override
    public boolean isElementPresent(String elementLocator) {
        this.checkElementLocator(elementLocator);
        return this._isElementPresent(elementLocator);
    }

    @Override
    public boolean isEnabled(String elementLocator) {
        this.checkElementLocator(elementLocator);
        return this._isEnabled(elementLocator);
    }

    @Override
    public boolean isVisible(String elementLocator) {
        this.checkElementLocator(elementLocator);
        return this._isVisible(elementLocator);
    }

    protected String _getAttribute(String attributeLocator) {
        ReplayUtils.AttributeLocatorInfo info = ReplayUtils.parseAttributeLocator(attributeLocator);
        return this._getAttribute(info.getElementLocator(), info.getAttributeName());
    }

    protected abstract String _getAttribute(String var1, String var2);

    protected abstract String _getText(String var1);

    protected abstract String _getValue(String var1);

    protected abstract String _evaluate(String var1);

    protected abstract int _getElementCount(String var1);

    protected abstract int _getXpathCount(String var1);

    protected abstract boolean _isChecked(String var1);

    protected abstract boolean _isElementPresent(String var1);

    protected abstract boolean _isEnabled(String var1);

    protected abstract boolean _isVisible(String var1);

    protected Condition attributeMatches(final String attributeLocator, final String textPattern, final boolean positiveMatch) {
        this.checkAttributeLocator(attributeLocator);
        this.checkIsTrue("Text pattern is null", textPattern != null);
        return new Condition(positiveMatch ? "ATTRIBUTE MATCH" : "ATTRIBUTE NO-MATCH"){

            @Override
            protected boolean evaluate() {
                String attValue = AbstractCommandAdapter.this._getAttribute(attributeLocator);
                if (attValue == null) {
                    throw new NoSuchElementAttributeException("Couldn't find element attribute: " + attributeLocator);
                }
                boolean matches = TextMatchingUtils.isAMatch(attValue, textPattern, true, false);
                String format = "Attribute value '%s' " + (matches ? "matches" : "does not match");
                this.setReason(String.format(format, attValue));
                return positiveMatch ? matches : !matches;
            }
        };
    }

    protected Condition attributeMatches(final String elementLocator, final String attributeName, final String textPattern, final boolean positiveMatch) {
        this.checkElementLocator(elementLocator);
        this.checkIsTrue("Attribute name must not be blank", StringUtils.isNotBlank((CharSequence)attributeName));
        this.checkIsTrue("Text pattern is null", textPattern != null);
        return new Condition(positiveMatch ? "ATTRIBUTE MATCH" : "ATTRIBUTE NO-MATCH"){

            @Override
            protected boolean evaluate() {
                String attValue = AbstractCommandAdapter.this._getAttribute(elementLocator, attributeName);
                if (attValue == null) {
                    throw new NoSuchElementAttributeException("Element [" + elementLocator + "] does not have such an attribute: " + attributeName);
                }
                boolean matches = TextMatchingUtils.isAMatch(attValue, textPattern, true, false);
                String format = "Attribute value '%s' " + (matches ? "matches" : "does not match");
                this.setReason(String.format(format, attValue));
                return positiveMatch ? matches : !matches;
            }
        };
    }

    protected Condition styleMatches(final String elementLocator, final String style, final boolean positiveMatch) {
        this.checkElementLocator(elementLocator);
        this.checkIsTrue("Style is null", StringUtils.isNotBlank((CharSequence)style));
        return new Condition(positiveMatch ? "STYLE MATCH" : "STYLE NO-MATCH"){
            private final Map<String, String> cssProps;
            {
                super(aDescription);
                this.cssProps = ReplayUtils.parseStyleString(style);
            }

            @Override
            protected boolean evaluate() {
                ArrayList<Object> props = new ArrayList<Object>();
                boolean match = true;
                for (Map.Entry<String, String> entry : this.cssProps.entrySet()) {
                    String cssValue;
                    String propName = entry.getKey();
                    String expValue = entry.getValue();
                    if (expValue.equals(cssValue = AbstractCommandAdapter.this._getEffectiveStyle(elementLocator, entry.getKey()))) {
                        if (positiveMatch) continue;
                        props.add(propName);
                        continue;
                    }
                    match = false;
                    if (!positiveMatch) continue;
                    props.add(new StylePropertyResultInfo(propName, cssValue, expValue));
                }
                StringBuilder sb = new StringBuilder(256);
                sb.append("Actual style '").append(style).append("' ");
                if (match) {
                    sb.append("matches");
                } else {
                    sb.append("does not match");
                }
                if (!props.isEmpty()) {
                    sb.append(" (");
                    if (positiveMatch) {
                        sb.append("non-");
                    }
                    sb.append("matching properties: ");
                    sb.append(StringUtils.join(props, (String)", "));
                    sb.append(')');
                }
                this.setReason(sb.toString());
                return props.isEmpty();
            }
        };
    }

    protected Condition pageTextMatches(final String textPattern, final boolean positiveMatch) {
        this.checkIsTrue("Text pattern is null", textPattern != null);
        return new Condition(positiveMatch ? "PAGE TEXT MATCH" : "PAGE TEXT NO-MATCH"){

            @Override
            protected boolean evaluate() {
                boolean match = TextMatchingUtils.isAMatch(AbstractCommandAdapter.this.getPageText(), textPattern, false, true);
                this.setReason("Page text " + (match ? "matches" : "does not match"));
                return positiveMatch ? match : !match;
            }
        };
    }

    protected Condition textMatches(final String elementLocator, final String textPattern, final boolean positiveMatch) {
        this.checkElementLocator(elementLocator);
        this.checkIsTrue("Text pattern is null", textPattern != null);
        return new Condition(positiveMatch ? "ELEMENT TEXT MATCH" : "ELEMENT TEXT NO-MATCH"){

            @Override
            protected boolean evaluate() {
                String text = AbstractCommandAdapter.this._getText(elementLocator);
                boolean match = TextMatchingUtils.isAMatch(text, textPattern, true, true);
                String format = "Element text '%s' " + (match ? "matches" : "does not match");
                this.setReason(String.format(format, text));
                return positiveMatch ? match : !match;
            }
        };
    }

    protected Condition titleMatches(final String titlePattern, final boolean positiveMatch) {
        this.checkIsTrue("Title pattern is null", titlePattern != null);
        return new Condition(positiveMatch ? "TITLE MATCH" : "TITLE NO-MATCH"){

            @Override
            protected boolean evaluate() {
                String pageTitle = AbstractCommandAdapter.this.getTitle();
                boolean match = TextMatchingUtils.isAMatch(pageTitle, titlePattern, true, true);
                String format = "Page title '%s' " + (match ? "matches" : "does not match");
                this.setReason(String.format(format, pageTitle));
                return positiveMatch ? match : !match;
            }
        };
    }

    protected Condition valueMatches(final String elementLocator, final String valuePattern, final boolean positiveMatch) {
        this.checkElementLocator(elementLocator);
        this.checkIsTrue("Value pattern is null", valuePattern != null);
        return new Condition(positiveMatch ? "ELEMENT VALUE MATCH" : "ELEMENT VALUE NO-MATCH"){

            @Override
            protected boolean evaluate() {
                String elementValue = AbstractCommandAdapter.this._getValue(elementLocator);
                boolean match = TextMatchingUtils.isAMatch(elementValue, valuePattern, true, true);
                String format = "Element's value '%s' " + (match ? "matches" : "does not match");
                this.setReason(String.format(format, elementValue));
                return positiveMatch ? match : !match;
            }
        };
    }

    protected Condition classMatches(final String elementLocator, final String classString, final boolean positiveMatch) {
        this.checkElementLocator(elementLocator);
        this.checkIsTrue("Class string is null", classString != null);
        return new Condition(positiveMatch ? "CLASS MATCH" : "CLASS NO-MATCH"){
            private final String[] clazzes;
            {
                super(aDescription);
                this.clazzes = classString.split("\\s+");
            }

            @Override
            protected boolean evaluate() {
                String clazzAttribute = StringUtils.defaultString((String)AbstractCommandAdapter.this._getAttribute(elementLocator, "class"));
                HashSet<String> classesSet = new HashSet<String>(Arrays.asList(clazzAttribute.split("\\s+")));
                ArrayList<String> classList = new ArrayList<String>();
                boolean match = true;
                for (String s : this.clazzes) {
                    if (StringUtils.isEmpty((CharSequence)s)) continue;
                    if (classesSet.contains(s)) {
                        if (positiveMatch) continue;
                        classList.add(s);
                        continue;
                    }
                    match = false;
                    if (!positiveMatch) continue;
                    classList.add(s);
                }
                String format = "Element's class attribute '%s' " + (match ? "matches" : "does not match") + " (" + (positiveMatch ? "missing" : "found") + " classes: %s)";
                this.setReason(String.format(format, clazzAttribute, StringUtils.defaultIfBlank((CharSequence)StringUtils.join(classList, (String)", "), (CharSequence)"none")));
                return classList.isEmpty();
            }
        };
    }

    protected Condition evalMatches(final String expression, final String textPattern, final boolean positiveMatch) {
        this.checkIsTrue("Expression to evaluate is null", expression != null);
        this.checkIsTrue("Text pattern is null", textPattern != null);
        return new Condition(positiveMatch ? "EVAL MATCH" : "EVAL NO-MATCH"){

            @Override
            protected boolean evaluate() {
                String text = AbstractCommandAdapter.this._evaluate(expression);
                boolean match = TextMatchingUtils.isAMatch(text, textPattern, true, false);
                String format = "Result of evaluation '%s' " + (match ? "matches" : "does not match");
                this.setReason(String.format(format, text));
                return positiveMatch ? match : !match;
            }
        };
    }

    protected Condition elementChecked(final String elementLocator, final boolean positiveMatch) {
        this.checkElementLocator(elementLocator);
        return new Condition(positiveMatch ? "ELEMENT CHECKED" : "ELEMENT UNCHECKED"){

            @Override
            protected boolean evaluate() {
                boolean checked = AbstractCommandAdapter.this._isChecked(elementLocator);
                this.setReason("Checkbox/radio element is " + (checked ? "checked" : "not checked"));
                return positiveMatch ? checked : !checked;
            }
        };
    }

    protected Condition elementPresent(final String elementLocator, final boolean positive) {
        this.checkElementLocator(elementLocator);
        return new Condition(positive ? "ELEMENT PRESENT" : "ELEMENT ABSENT"){

            @Override
            protected boolean evaluate() {
                boolean found = AbstractCommandAdapter.this._isElementPresent(elementLocator);
                this.setReason(found ? "Element found" : "Element not found");
                return positive ? found : !found;
            }
        };
    }

    protected Condition elementVisible(final String elementLocator, final boolean positiveMatch) {
        this.checkElementLocator(elementLocator);
        return new Condition(positiveMatch ? "ELEMENT VISIBLE" : "ELEMENT INVISIBLE"){

            @Override
            protected boolean evaluate() {
                boolean visible = AbstractCommandAdapter.this._isVisible(elementLocator);
                this.setReason("Element is " + (visible ? "visible" : "invisible"));
                return positiveMatch ? visible : !visible;
            }
        };
    }

    protected Condition elementCountEqual(final String elementLocator, final int count, final boolean positive) {
        this.checkElementLocator(elementLocator);
        this.checkIsTrue("Element count is negative", count > -1);
        return new Condition(positive ? "ELEMENT COUNT EQUAL" : "ELEMENT COUNT DIFFERENT"){

            @Override
            protected boolean evaluate() {
                boolean isEqual;
                int nbElements = AbstractCommandAdapter.this._getElementCount(elementLocator);
                boolean bl = isEqual = count == nbElements;
                if (isEqual) {
                    this.setReason(String.format("Number of matching elements is equal to '%d'", count));
                } else {
                    this.setReason(String.format("Invalid number of matching elements, expected <%d> but was <%d>", count, nbElements));
                }
                return positive ? isEqual : !isEqual;
            }
        };
    }

    protected Condition xpathCountEqual(final String xpath, final int count, final boolean positive) {
        this.checkIsTrue("XPath expression is null", xpath != null);
        this.checkIsTrue("Element count is negative", count > -1);
        return new Condition(positive ? "XPATH COUNT EQUAL" : "XPATH COUNT DIFFERENT"){

            @Override
            protected boolean evaluate() {
                boolean equal;
                int nbElements = AbstractCommandAdapter.this._getXpathCount(xpath);
                boolean bl = equal = count == nbElements;
                if (equal) {
                    this.setReason(String.format("Number of matching elements is equal to '%d'", count));
                } else {
                    this.setReason(String.format("Invalid number of matching elements, expected <%d> but was <%d>", count, nbElements));
                }
                return positive ? equal : !equal;
            }
        };
    }

    protected Condition idSelected(final String selectLocator, final String idPattern, final boolean positiveMatch) {
        this.checkIsTrue("Select locator is null", selectLocator != null);
        this.checkIsTrue("ID pattern is null", idPattern != null);
        return new Condition(positiveMatch ? "SELECTED ID MATCH" : "SELECTED ID NO-MATCH"){

            @Override
            protected boolean evaluate() {
                boolean match = false;
                for (String id : AbstractCommandAdapter.this.getSelectedIds(selectLocator)) {
                    if (!TextMatchingUtils.isAMatch(id, idPattern, true, false)) continue;
                    match = true;
                    break;
                }
                this.setReason((match ? "At least one" : "No") + " selected option found whose ID matches the specified pattern");
                return positiveMatch ? match : !match;
            }
        };
    }

    protected Condition indexSelected(final String selectLocator, final String indexPattern, final boolean positiveMatch) {
        this.checkIsTrue("Select locator is null", selectLocator != null);
        this.checkIsTrue("Index pattern is null", indexPattern != null);
        return new Condition(positiveMatch ? "SELECTED INDEX MATCH" : "SELECTED INDEX NO-MATCH"){

            @Override
            protected boolean evaluate() {
                boolean match = false;
                for (Integer idx : AbstractCommandAdapter.this.getSelectedIndices(selectLocator)) {
                    if (!TextMatchingUtils.isAMatch(idx.toString(), indexPattern, true, false)) continue;
                    match = true;
                    break;
                }
                this.setReason((match ? "At least one" : "No") + " selected option found whose index matches the specified pattern");
                return positiveMatch ? match : !match;
            }
        };
    }

    protected Condition labelSelected(final String selectLocator, final String labelPattern, final boolean positiveMatch) {
        this.checkIsTrue("Select locator is null", selectLocator != null);
        this.checkIsTrue("Label pattern is null", labelPattern != null);
        return new Condition(positiveMatch ? "SELECTED LABEL MATCH" : "SELECTED LABEL NO-MATCH"){

            @Override
            protected boolean evaluate() {
                boolean match = false;
                for (String label : AbstractCommandAdapter.this.getSelectedLabels(selectLocator)) {
                    if (!TextMatchingUtils.isAMatch(label, labelPattern, true, true)) continue;
                    match = true;
                    break;
                }
                this.setReason((match ? "At least one" : "No") + " selected option found whose label matches the specified pattern");
                return positiveMatch ? match : !match;
            }
        };
    }

    protected Condition valueSelected(final String selectLocator, final String valuePattern, final boolean positiveMatch) {
        this.checkIsTrue("Select locator is null", selectLocator != null);
        this.checkIsTrue("Value pattern is null", valuePattern != null);
        return new Condition(positiveMatch ? "SELECTED VALUE MATCH" : "SELECTED VALUE NO-MATCH"){

            @Override
            protected boolean evaluate() {
                boolean match = false;
                for (String value : AbstractCommandAdapter.this.getSelectedValues(selectLocator)) {
                    if (!TextMatchingUtils.isAMatch(value, valuePattern, true, false)) continue;
                    match = true;
                    break;
                }
                this.setReason((match ? "At least one" : "No") + " selected option found whose value attribute matches the specified pattern");
                return positiveMatch ? match : !match;
            }
        };
    }

    protected long disableImplicitWaitTimeout() {
        TestContext testContext = TestContext.getCurrent();
        long timeout = testContext.getImplicitTimeout();
        testContext.setImplicitTimeout(0L);
        return timeout;
    }

    protected void enableImplicitWaitTimeout(long timeout) {
        TestContext.getCurrent().setImplicitTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeRunnable(boolean disableImplicitWait, Runnable runnable) {
        long timeout = 0L;
        if (disableImplicitWait) {
            timeout = this.disableImplicitWaitTimeout();
        }
        try {
            runnable.run();
        }
        finally {
            if (disableImplicitWait) {
                this.enableImplicitWaitTimeout(timeout);
            }
        }
    }

    private void assureCondition(Condition condition) {
        if (!condition.isTrue()) {
            Assert.fail((String)condition.getReason());
        }
    }

    static {
        VARIABLE_PATTERN = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");
        ATT_LOCATOR_PATTERN = Pattern.compile("\\S+@[^\\d\\s]\\S*$");
        String framePatternString = "frames\\[(['\"])([^'\"]+)\\1\\](\\.frames\\[(['\"])[^'\"]+\\4\\])*";
        FRAME_NAME_LOCATOR_PATTERN = Pattern.compile("^dom=frames\\[(['\"])([^'\"]+)\\1\\](\\.frames\\[(['\"])[^'\"]+\\4\\])*$");
        FRAME_NAME_PATTERN = Pattern.compile("frames\\[(['\"])([^'\"]+)\\1\\](\\.frames\\[(['\"])[^'\"]+\\4\\])*?");
        LOGGER = LoggerFactory.getLogger(AbstractCommandAdapter.class);
    }

    private static class StylePropertyResultInfo {
        private final String propertyName;
        private final String actualValue;
        private final String expectedValue;

        private StylePropertyResultInfo(String propertyName, String actualValue, String expectedValue) {
            this.propertyName = propertyName;
            this.actualValue = actualValue;
            this.expectedValue = expectedValue;
        }

        public String toString() {
            return String.format("'%s' (expected '%s' but was '%s')", this.propertyName, this.expectedValue, this.actualValue);
        }
    }
}

