/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.webdriver;

import com.gargoylesoftware.htmlunit.html.DomElement;
import com.xceptance.xlt.engine.scripting.util.ReplayUtils;
import com.xceptance.xlt.engine.scripting.util.TextMatchingUtils;
import com.xceptance.xlt.engine.scripting.webdriver.WebDriverFinder;
import com.xceptance.xlt.engine.scripting.webdriver.WebDriverUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

class ElementFinder {
    private final Strategy CSS_STRATEGY = new CssStrategy();
    private final Strategy DOM_STRATEGY = new DomStrategy();
    private final Strategy ID_STRATEGY = new IdStrategy();
    private final Strategy IDENTIFIER_STRATEGY = new IdentifierStrategy();
    private final Strategy IMPLICIT_STRATEGY = new ImplicitStrategy();
    private final Strategy LINK_STRATEGY = new LinkStrategy();
    private final Strategy NAME_STRATEGY = new NameStrategy();
    private final Strategy XPATH_STRATEGY = new XPathStrategy();
    private final Map<String, Strategy> strategies = new HashMap<String, Strategy>();
    private final boolean visibleOnly;

    ElementFinder(boolean visibleOnly) {
        this.visibleOnly = visibleOnly;
        this.strategies.put("css", this.CSS_STRATEGY);
        this.strategies.put("link", this.LINK_STRATEGY);
        this.strategies.put("dom", this.DOM_STRATEGY);
        this.strategies.put("xpath", this.XPATH_STRATEGY);
        this.strategies.put("name", this.NAME_STRATEGY);
        this.strategies.put("id", this.ID_STRATEGY);
        this.strategies.put("identifier", this.IDENTIFIER_STRATEGY);
        this.strategies.put("implicit", this.IMPLICIT_STRATEGY);
    }

    WebElement find(WebDriver webDriver, String locator) {
        String value;
        String strategyName;
        Matcher m = WebDriverFinder.STRATEGY_PATTERN.matcher(locator);
        if (m.matches()) {
            strategyName = m.group(1);
            value = m.group(2);
        } else {
            strategyName = "implicit";
            value = locator;
        }
        Strategy strategy = this.strategies.get(strategyName);
        if (strategy == null) {
            throw new InvalidSelectorException("Unknown element locator strategy: " + strategyName);
        }
        WebElement e = strategy.find(webDriver, value);
        if (e == null) {
            throw new NoSuchElementException("No element found for locator: " + locator);
        }
        return e;
    }

    List<WebElement> findAll(WebDriver webDriver, String locator) {
        String value;
        String strategyName;
        Matcher m = WebDriverFinder.STRATEGY_PATTERN.matcher(locator);
        if (m.matches()) {
            strategyName = m.group(1);
            value = m.group(2);
        } else {
            strategyName = "implicit";
            value = locator;
        }
        Strategy strategy = this.strategies.get(strategyName);
        if (strategy == null) {
            throw new InvalidSelectorException("Unknown element locator strategy: " + strategyName);
        }
        return strategy.findAll(webDriver, value);
    }

    private class XPathStrategy
    extends Strategy {
        private XPathStrategy() {
        }

        @Override
        protected WebElement find(WebDriver webDriver, String locator) {
            List found = webDriver.findElements(By.xpath((String)locator));
            for (WebElement e : found) {
                if (!this.isAcceptable(e)) continue;
                return e;
            }
            return null;
        }

        @Override
        protected List<WebElement> findAll(WebDriver webDriver, String locator) {
            ArrayList<WebElement> result = new ArrayList<WebElement>();
            List found = webDriver.findElements(By.xpath((String)locator));
            for (WebElement e : found) {
                if (!this.isAcceptable(e)) continue;
                result.add(e);
            }
            return result;
        }
    }

    private class NameStrategy
    extends Strategy {
        private final String INDEX_KEY = "index";
        private final String NAME_KEY = "name";
        private final String VALUE_KEY = "value";

        private NameStrategy() {
            this.INDEX_KEY = "index";
            this.NAME_KEY = "name";
            this.VALUE_KEY = "value";
        }

        @Override
        protected WebElement find(WebDriver webDriver, String locator) {
            Map<String, String> attributes = ReplayUtils.parseAttributes(locator);
            List found = webDriver.findElements(By.xpath((String)String.format("//*[@name='%s']", attributes.get("name"))));
            List<WebElement> elements = new ArrayList<WebElement>();
            for (WebElement e : found) {
                if (!this.isAcceptable(e)) continue;
                elements.add(e);
            }
            if (attributes.containsKey("value")) {
                String value = attributes.get("value");
                Iterator it = elements.iterator();
                while (it.hasNext()) {
                    WebElement e = (WebElement)it.next();
                    String elementValue = e.getAttribute("value");
                    boolean keep = false;
                    if (elementValue != null) {
                        if (value.length() > 0) {
                            if (value.equals(elementValue)) {
                                keep = true;
                            }
                        } else if (elementValue.length() == 0 && elementValue != DomElement.ATTRIBUTE_NOT_DEFINED && value.equals(elementValue)) {
                            keep = true;
                        }
                    }
                    if (keep) continue;
                    it.remove();
                }
            }
            if (attributes.containsKey("index")) {
                String index = attributes.get("index");
                try {
                    int idx = Integer.parseInt(index);
                    elements = Collections.singletonList((WebElement)elements.get(idx));
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (elements.isEmpty()) {
                return null;
            }
            return (WebElement)elements.get(0);
        }

        @Override
        protected List<WebElement> findAll(WebDriver webDriver, String locator) {
            Map<String, String> attributes = ReplayUtils.parseAttributes(locator);
            List found = webDriver.findElements(By.xpath((String)String.format("//*[@name='%s']", attributes.get("name"))));
            List<Object> elements = new ArrayList<WebElement>();
            for (WebElement e : found) {
                if (!this.isAcceptable(e)) continue;
                elements.add(e);
            }
            if (attributes.containsKey("value")) {
                String value = attributes.get("value");
                Iterator it = elements.iterator();
                while (it.hasNext()) {
                    WebElement e = (WebElement)it.next();
                    String elementValue = e.getAttribute("value");
                    boolean keep = false;
                    if (elementValue != null) {
                        if (value.length() > 0) {
                            if (value.equals(elementValue)) {
                                keep = true;
                            }
                        } else if (elementValue.length() == 0 && elementValue != DomElement.ATTRIBUTE_NOT_DEFINED && value.equals(elementValue)) {
                            keep = true;
                        }
                    }
                    if (keep) continue;
                    it.remove();
                }
            }
            if (attributes.containsKey("index")) {
                String index = attributes.get("index");
                try {
                    int idx = Integer.parseInt(index);
                    elements = Collections.singletonList((WebElement)elements.get(idx));
                }
                catch (Exception e) {
                    elements = Collections.emptyList();
                }
            }
            return elements;
        }
    }

    private class LinkStrategy
    extends Strategy {
        private LinkStrategy() {
        }

        @Override
        protected WebElement find(WebDriver webDriver, String locator) {
            List anchors = webDriver.findElements(By.tagName((String)"a"));
            for (WebElement a : anchors) {
                if (!this.isAcceptable(a) || !TextMatchingUtils.isAMatch(a.getText(), locator, true, true)) continue;
                return a;
            }
            return null;
        }

        @Override
        protected List<WebElement> findAll(WebDriver webDriver, String locator) {
            ArrayList<WebElement> result = new ArrayList<WebElement>();
            List found = webDriver.findElements(By.tagName((String)"a"));
            for (WebElement e : found) {
                if (!this.isAcceptable(e) || !TextMatchingUtils.isAMatch(e.getText(), locator, true, true)) continue;
                result.add(e);
            }
            return result;
        }
    }

    private class ImplicitStrategy
    extends Strategy {
        private ImplicitStrategy() {
        }

        @Override
        protected WebElement find(WebDriver webDriver, String locator) {
            if (locator.startsWith("document.")) {
                return ElementFinder.this.DOM_STRATEGY.find(webDriver, locator);
            }
            if (locator.startsWith("//")) {
                return ElementFinder.this.XPATH_STRATEGY.find(webDriver, locator);
            }
            return ElementFinder.this.IDENTIFIER_STRATEGY.find(webDriver, locator);
        }

        @Override
        protected List<WebElement> findAll(WebDriver webDriver, String locator) {
            if (locator.startsWith("document.")) {
                return ElementFinder.this.DOM_STRATEGY.findAll(webDriver, locator);
            }
            if (locator.startsWith("//")) {
                return ElementFinder.this.XPATH_STRATEGY.findAll(webDriver, locator);
            }
            return ElementFinder.this.IDENTIFIER_STRATEGY.findAll(webDriver, locator);
        }
    }

    private class IdStrategy
    extends Strategy {
        private IdStrategy() {
        }

        @Override
        protected WebElement find(WebDriver webDriver, String locator) {
            return ElementFinder.this.XPATH_STRATEGY.find(webDriver, this.toXPath(locator));
        }

        @Override
        protected List<WebElement> findAll(WebDriver webDriver, String locator) {
            return ElementFinder.this.XPATH_STRATEGY.findAll(webDriver, this.toXPath(locator));
        }

        private String toXPath(String id) {
            return "//*[@id='" + id + "']";
        }
    }

    private class IdentifierStrategy
    extends Strategy {
        private IdentifierStrategy() {
        }

        @Override
        protected WebElement find(WebDriver webDriver, String locator) {
            WebElement e = ElementFinder.this.ID_STRATEGY.find(webDriver, locator);
            if (e == null) {
                e = ElementFinder.this.XPATH_STRATEGY.find(webDriver, String.format("//*[@name='%s']", locator));
            }
            return e;
        }

        @Override
        protected List<WebElement> findAll(WebDriver webDriver, String locator) {
            ArrayList<WebElement> result = new ArrayList<WebElement>();
            result.addAll(ElementFinder.this.ID_STRATEGY.findAll(webDriver, locator));
            result.addAll(ElementFinder.this.XPATH_STRATEGY.findAll(webDriver, String.format("//*[@name='%s']", locator)));
            return result;
        }
    }

    private class DomStrategy
    extends Strategy {
        private DomStrategy() {
        }

        @Override
        protected WebElement find(WebDriver webDriver, String locator) {
            WebElement element;
            Object result = WebDriverUtils.executeJavaScript(webDriver, "return " + locator, new Object[0]);
            if (result instanceof WebElement && this.isAcceptable(element = (WebElement)result)) {
                return element;
            }
            return null;
        }

        @Override
        protected List<WebElement> findAll(WebDriver webDriver, String locator) {
            ArrayList<WebElement> result = new ArrayList<WebElement>();
            WebElement e = this.find(webDriver, locator);
            if (e != null) {
                result.add(e);
            }
            return result;
        }
    }

    private class CssStrategy
    extends Strategy {
        private CssStrategy() {
        }

        @Override
        protected WebElement find(WebDriver webDriver, String cssSelector) {
            List found = webDriver.findElements(By.cssSelector((String)cssSelector));
            for (WebElement e : found) {
                if (!this.isAcceptable(e)) continue;
                return e;
            }
            return null;
        }

        @Override
        protected List<WebElement> findAll(WebDriver webDriver, String locator) {
            ArrayList<WebElement> result = new ArrayList<WebElement>();
            List found = webDriver.findElements(By.cssSelector((String)locator));
            for (WebElement e : found) {
                if (!this.isAcceptable(e)) continue;
                result.add(e);
            }
            return result;
        }
    }

    private abstract class Strategy {
        private Strategy() {
        }

        protected abstract WebElement find(WebDriver var1, String var2);

        protected abstract List<WebElement> findAll(WebDriver var1, String var2);

        protected boolean isAcceptable(WebElement webElement) {
            if (ElementFinder.this.visibleOnly) {
                return webElement.isDisplayed();
            }
            return true;
        }
    }
}

