/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.util;

import com.xceptance.xlt.api.engine.scripting.ScriptName;
import org.apache.commons.lang3.StringUtils;

public final class ScriptingUtils {
    public static final String DEFAULT_PACKAGE = "";

    private ScriptingUtils() {
    }

    public static String getScriptName(Class<?> testClass) {
        String scriptName;
        ScriptName scriptNameAnnotation = testClass.getAnnotation(ScriptName.class);
        if (scriptNameAnnotation != null && (scriptName = scriptNameAnnotation.value()).length() > 0) {
            return scriptName;
        }
        return testClass.getName();
    }

    public static String getScriptBaseName(String scriptName) {
        int idx = scriptName.lastIndexOf(".");
        if (idx != -1) {
            return scriptName.substring(idx + 1);
        }
        return scriptName;
    }

    public static String getScriptPackage(String scriptName) {
        int idx = scriptName.lastIndexOf(".");
        if (idx != -1) {
            return scriptName.substring(0, idx);
        }
        return DEFAULT_PACKAGE;
    }

    public static String getParentPackageName(String packageName) {
        return ScriptingUtils.getScriptPackage(StringUtils.defaultString((String)packageName));
    }
}

