/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.xltdriver;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseEvent;
import com.xceptance.xlt.engine.scripting.htmlunit.HtmlUnitElementUtils;
import com.xceptance.xlt.engine.xltdriver.HtmlUnitDriver;
import com.xceptance.xlt.engine.xltdriver.HtmlUnitKeyboard;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.Point;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.interactions.Coordinates;
import org.openqa.selenium.interactions.InvalidCoordinatesException;
import org.openqa.selenium.interactions.Mouse;

public class HtmlUnitMouse
implements Mouse {
    private final HtmlUnitDriver parent;
    private final HtmlUnitKeyboard keyboard;
    private DomElement currentActiveElement;
    private Point currentMousePosition;

    public HtmlUnitMouse(HtmlUnitDriver parent, HtmlUnitKeyboard keyboard) {
        this.parent = parent;
        this.keyboard = keyboard;
    }

    private DomElement getElementForOperation(Coordinates potentialCoordinates) {
        if (potentialCoordinates != null) {
            return (DomElement)potentialCoordinates.getAuxiliary();
        }
        if (this.currentActiveElement == null) {
            throw new InvalidCoordinatesException("About to perform an interaction that relies on the active element, but there isn't one.");
        }
        return this.currentActiveElement;
    }

    public void click(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent.click(element, false);
    }

    void click(DomElement element, boolean directClick) {
        if (!element.isDisplayed()) {
            throw new ElementNotInteractableException("You may only interact with visible elements");
        }
        this.moveOutIfNeeded(element);
        try {
            element.click(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed() || directClick && element instanceof HtmlOption, this.keyboard.isAltPressed());
            this.updateActiveElement(element);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (ScriptException e) {
            System.out.println(e.getMessage());
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SocketTimeoutException) {
                throw new TimeoutException(cause);
            }
            throw e;
        }
    }

    private void moveOutIfNeeded(DomElement element) {
        try {
            if (this.currentActiveElement != element) {
                if (this.currentActiveElement != null) {
                    this.currentActiveElement.mouseOver(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
                    this.currentActiveElement.mouseOut(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
                }
                if (element != null) {
                    element.mouseMove(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
                    element.mouseOver(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
                }
            }
        }
        catch (ScriptException ignored) {
            System.out.println(ignored.getMessage());
        }
    }

    private void updateActiveElement(DomElement element) {
        if (element != null) {
            this.currentActiveElement = element;
        }
    }

    public void doubleClick(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent.doubleClick(element);
    }

    void doubleClick(DomElement element) {
        this.moveOutIfNeeded(element);
        try {
            element.dblClick(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed());
            this.updateActiveElement(element);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void contextClick(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.moveOutIfNeeded(element);
        if (this.currentMousePosition == null) {
            element.rightClick(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed());
        } else {
            int xPos = this.currentMousePosition.getX();
            int yPos = this.currentMousePosition.getY();
            HtmlUnitElementUtils.fireMouseEvent(element, "mousedown", xPos, yPos, 2);
            HtmlUnitElementUtils.fireMouseEvent(element, "mouseup", xPos, yPos, 2);
            HtmlUnitElementUtils.fireMouseEvent(element, "contextmenu", xPos, yPos, 2);
        }
        this.updateActiveElement(element);
    }

    public void mouseDown(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent.mouseDown(element);
    }

    void mouseDown(DomElement element) {
        this.moveOutIfNeeded(element);
        element.mouseDown(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
        this.updateActiveElement(element);
    }

    public void mouseUp(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent.mouseUp(element);
    }

    void mouseUp(DomElement element) {
        this.moveOutIfNeeded(element);
        element.mouseUp(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
        this.updateActiveElement(element);
    }

    public void mouseMove(Coordinates elementCoordinates) {
        this.mouseMove(elementCoordinates, 0L, 0L);
    }

    void mouseMove(DomElement element) {
        this.moveOutIfNeeded(element);
        this.updateActiveElement(element);
    }

    public void mouseMove(Coordinates where, long xOffset, long yOffset) {
        DomElement e = this.getElementForOperation(where);
        Point p = where.onPage();
        long coordX = (long)p.getX() + xOffset;
        long coordY = (long)p.getY() + yOffset;
        this.moveOutIfNeeded(e, coordX, coordY);
        this.updateMousePosition(new Point((int)coordX, (int)coordY));
        this.updateActiveElement(e);
    }

    private void moveOutIfNeeded(DomElement element, long coordX, long coordY) {
        try {
            if (this.currentActiveElement != element) {
                if (this.currentActiveElement != null) {
                    this.currentActiveElement.mouseOver(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
                    this.currentActiveElement.mouseOut(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
                    this.currentActiveElement.blur();
                }
                if (element != null) {
                    this.mouseMove(element, coordX, coordY);
                }
            }
        }
        catch (ScriptException ignored) {
            System.out.println(ignored.getMessage());
        }
    }

    private void mouseMove(DomElement element, long coordX, long coordY) {
        if (element instanceof DisabledElement && ((DisabledElement)((Object)element)).isDisabled()) {
            return;
        }
        MouseEvent event = new MouseEvent(element, "mousemove", this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
        event.setClientX((int)coordX);
        event.setClientY((int)coordY);
        element.fireEvent(event);
        event = new MouseEvent(element, "mouseover", this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
        event.setClientX((int)coordX);
        event.setClientY((int)coordY);
        element.fireEvent(event);
    }

    private void updateMousePosition(Point newPosition) {
        if (newPosition != null) {
            this.currentMousePosition = newPosition;
        }
    }
}

