/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.gce;

import com.xceptance.xlt.gce.GceAdmin;
import com.xceptance.xlt.gce.GceAdminUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class GceAdminMain {
    public static void main(String[] args) {
        Options options = GceAdminMain.createCommandLineOptions();
        CommandLine commandLine = GceAdminMain.parseCommandLine(options, args);
        if (commandLine.hasOption("help")) {
            GceAdminMain.printUsageInfo(options);
        } else {
            try {
                GceAdmin gceAdmin = new GceAdmin();
                if (commandLine.getArgs().length > 0) {
                    gceAdmin.startNonInteractiveMode(commandLine);
                } else {
                    gceAdmin.startInteractiveMode();
                }
            }
            catch (Exception e) {
                GceAdminUtils.dieWithMessage("An unexpected error occurred: " + e.getMessage(), e);
            }
        }
    }

    private static Options createCommandLineOptions() {
        Options options = new Options();
        options.addOption(null, "help", false, "Show help.");
        options.addOption("o", "outputFile", true, "The file that will contain the agent controller connection properties corresponding to the started instances. If no such file is specified, the properties will be printed to the console.");
        return options;
    }

    private static CommandLine parseCommandLine(Options options, String[] args) {
        DefaultParser parser = new DefaultParser();
        try {
            return parser.parse(options, args);
        }
        catch (ParseException ex) {
            GceAdminMain.printUsageInfo(options);
            System.exit(2);
            return null;
        }
    }

    private static void printUsageInfo(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        System.out.println("Simple front-end application to manage Google Compute Engine instances.");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("    gce_admin");
        System.out.println("      -> Run in interactive mode.\n");
        System.out.println();
        System.out.println("    gce_admin list-by-label <region-name> <name-label> [<options>]");
        System.out.println("      -> List instances non-interactively by a name label.\n");
        System.out.println();
        System.out.println("    gce_admin list-by-group <region-name> <group-name> [<options>]");
        System.out.println("      -> List instances non-interactively by instance group name.\n");
        System.out.println();
        System.out.println("    gce_admin create-group <region-name> <group-name> <instance-template-name> <instance-count> [<options>]");
        System.out.println("      -> Create managed instance group non-interactively.\n");
        System.out.println();
        System.out.println("    gce_admin delete-group <region-name> <group-name>");
        System.out.println("      -> Delete managed instance group non-interactively.");
        formatter.setSyntaxPrefix("");
        formatter.setWidth(79);
        if (!options.equals(null)) {
            formatter.printHelp(" ", "Options:", options, "");
        }
        System.out.println();
    }
}

