/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.common.util.ProductInformation;
import com.xceptance.xlt.agentcontroller.AgentController;
import com.xceptance.xlt.util.AgentControllerInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentControllersInformation {
    private static final Logger log = LoggerFactory.getLogger(AgentControllersInformation.class);
    private static final String VERSION_UNKNOWN = "Version Unknown";
    private static final long DEFAULT_TIME_DIFF_THRESHOLD = 10L;
    private final Map<String, AgentControllerInfo> agentControllerInfos = Collections.synchronizedMap(new TreeMap());
    private final Set<String> xltInfos = new HashSet<String>();
    private final Set<String> javaInfos = new HashSet<String>();
    private final ThreadPoolExecutor executor;
    private final long timeDifferenceThreshold;
    private boolean hasErrors = false;
    private boolean hasHighDiff = false;
    private boolean hasJavaConflict = false;
    private boolean hasXltVersionConflict = false;

    public AgentControllersInformation(Collection<AgentController> agentControllers, ThreadPoolExecutor executor) {
        this(agentControllers, executor, 10L);
    }

    public AgentControllersInformation(Collection<AgentController> agentControllers, ThreadPoolExecutor executor, long timeDifferenceThreshold) {
        this.executor = executor;
        this.timeDifferenceThreshold = timeDifferenceThreshold;
        this.init(agentControllers);
    }

    private void init(Collection<AgentController> agentControllers) {
        this.loadAgentControllersInformation(agentControllers);
        this.xltInfos.add(ProductInformation.getProductInformation().getCondensedProductIdentifier());
        this.analyze();
    }

    private void loadAgentControllersInformation(Collection<AgentController> agentControllers) {
        final CountDownLatch latch = new CountDownLatch(agentControllers.size());
        for (final AgentController agentcontroller : agentControllers) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    AgentControllerInfo agentControllerInfo = new AgentControllerInfo();
                    agentControllerInfo.setName(agentcontroller.getName());
                    agentControllerInfo.setHostName(agentcontroller.getHostname());
                    try {
                        agentControllerInfo.setAgentControllerSystemInfo(agentcontroller.info());
                        agentControllerInfo.setTimeDifferenceTo(System.currentTimeMillis());
                    }
                    catch (Exception e) {
                        log.error("Failed to query agent controller information: " + agentcontroller, (Throwable)e);
                        agentControllerInfo.setException(e);
                    }
                    AgentControllersInformation.this.agentControllerInfos.put(agentControllerInfo.getName(), agentControllerInfo);
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("Waiting for agent controller system information results to complete has failed", (Throwable)e);
        }
    }

    private void analyze() {
        for (AgentControllerInfo agentControllerInfo : this.agentControllerInfos.values()) {
            if (agentControllerInfo.getAgentControllerSystemInfo() != null) {
                String xltVersion = agentControllerInfo.getAgentControllerSystemInfo().getXltVersion();
                this.xltInfos.add(xltVersion);
                String javaVersion = agentControllerInfo.getAgentControllerSystemInfo().getJavaVersion();
                this.javaInfos.add(javaVersion);
                long timeDiff = agentControllerInfo.getTimeDifference();
                if (timeDiff < this.timeDifferenceThreshold * 1000L) continue;
                this.hasHighDiff = true;
                continue;
            }
            this.hasErrors = true;
            this.xltInfos.add(VERSION_UNKNOWN);
            this.javaInfos.add(VERSION_UNKNOWN);
        }
        if (this.xltInfos.size() > 1 || this.xltInfos.contains(VERSION_UNKNOWN)) {
            this.hasXltVersionConflict = true;
        }
        if (this.javaInfos.size() > 1 || this.javaInfos.contains(VERSION_UNKNOWN)) {
            this.hasJavaConflict = true;
        }
    }

    public Collection<AgentControllerInfo> getAgentControllerInformation() {
        return this.agentControllerInfos.values();
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public boolean hasXltVersionConflict() {
        return this.hasXltVersionConflict;
    }

    public boolean hasJavaConflict() {
        return this.hasJavaConflict;
    }

    public boolean hasHighTimeDifference() {
        return this.hasHighDiff;
    }

    public long getTimeDiffThreshold() {
        return this.timeDifferenceThreshold;
    }
}

