/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.xlt.api.engine.ActionData;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.PageLoadTimingData;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.engine.TransactionData;
import com.xceptance.xlt.report.DataRecordFactory;
import com.xceptance.xlt.report.Dispatcher;
import com.xceptance.xlt.report.LineChunk;
import com.xceptance.xlt.report.LogReader;
import com.xceptance.xlt.report.mergerules.RequestProcessingRule;
import com.xceptance.xlt.report.mergerules.RequestProcessingRuleResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataRecordParser
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(LogReader.class);
    private static final Pattern WD_TIMER_NAME_PATTERN = Pattern.compile("page_\\d+");
    private final DataRecordFactory dataRecordFactory;
    private final Dispatcher dispatcher;
    private final long fromTime;
    private final List<RequestProcessingRule> requestProcessingRules;
    private final long toTime;
    private final boolean removeIndexesFromRequestNames;

    public DataRecordParser(DataRecordFactory dataRecordFactory, long fromTime, long toTime, List<RequestProcessingRule> requestProcessingRules, Dispatcher dispatcher, boolean removeIndexesFromRequestNames) {
        this.dataRecordFactory = dataRecordFactory;
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.requestProcessingRules = requestProcessingRules;
        this.dispatcher = dispatcher;
        this.removeIndexesFromRequestNames = removeIndexesFromRequestNames;
    }

    @Override
    public void run() {
        try {
            while (true) {
                LineChunk lineChunk = this.dispatcher.getNextLineChunk();
                List<String> lines = lineChunk.getLines();
                ArrayList<Data> dataRecordChunk = new ArrayList<Data>(lines.size());
                int lineNumber = lineChunk.getBaseLineNumber();
                int size = lines.size();
                for (int i = 0; i < size; ++i) {
                    Data data = this.parseLine(lines.get(i), lineNumber, lineChunk);
                    if (data != null && (data = this.preprocessDataRecord(data)) != null) {
                        dataRecordChunk.add(data);
                    }
                    ++lineNumber;
                }
                this.dispatcher.addNewParsedDataRecordChunk(dataRecordChunk);
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private Data parseLine(String line, int lineNumber, LineChunk lineChunk) {
        try {
            Data dataRecord = this.dataRecordFactory.createStatistics(line);
            long time = dataRecord.getTime();
            if (time < this.fromTime || time > this.toTime) {
                return null;
            }
            dataRecord.setAgentName(lineChunk.getAgentName());
            dataRecord.setTransactionName(lineChunk.getTestCaseName());
            if (dataRecord instanceof TransactionData) {
                TransactionData td = (TransactionData)dataRecord;
                td.setTestUserNumber(lineChunk.getUserNumber());
            } else if (lineChunk.getCollectActionNames() && dataRecord instanceof ActionData) {
                lineChunk.getActionNames().put(dataRecord.getTime(), dataRecord.getName());
            } else if (lineChunk.getAdjustTimerNames() && (dataRecord instanceof RequestData || dataRecord instanceof PageLoadTimingData)) {
                Map.Entry<Long, String> entry = lineChunk.getActionNames().floorEntry(time);
                String actionName = entry != null ? entry.getValue() : "UnknownAction";
                Matcher m = WD_TIMER_NAME_PATTERN.matcher(dataRecord.getName());
                dataRecord.setName(m.replaceFirst(actionName));
            }
            return dataRecord;
        }
        catch (Exception ex) {
            String msg = String.format("Failed to parse data record at line %,d in file '%s': %s", lineNumber, lineChunk.getFile(), ex);
            LOG.error(msg);
            System.out.println(msg);
            return null;
        }
    }

    private Data preprocessDataRecord(Data data) {
        if (data instanceof RequestData) {
            return this.processRequestData((RequestData)data);
        }
        return data;
    }

    private RequestData processRequestData(RequestData requestData) {
        String requestName;
        int firstDotPos;
        if (this.removeIndexesFromRequestNames && (firstDotPos = (requestName = requestData.getName()).indexOf(".")) > 0) {
            requestName = requestName.substring(0, firstDotPos);
            requestData.setName(requestName);
        }
        String originalName = requestData.getName();
        int size = this.requestProcessingRules.size();
        for (int i = 0; i < size; ++i) {
            RequestProcessingRule requestProcessingRule = this.requestProcessingRules.get(i);
            try {
                RequestProcessingRuleResult result = requestProcessingRule.process(requestData);
                requestData = result.requestData;
                if (!result.stopRequestProcessing) continue;
            }
            catch (Throwable t) {
                String msg = String.format("Failed to apply request merge rule: %s\n%s", requestProcessingRule, t);
                LOG.error(msg);
                System.out.println(msg);
                requestData.setName(originalName);
            }
            break;
        }
        return requestData;
    }
}

