/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.mergerules;

import com.xceptance.common.lang.ThrowableUtils;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.report.mergerules.AbstractRequestFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPatternRequestFilter
extends AbstractRequestFilter {
    private final Pattern pattern;
    private final boolean isExclude;

    public AbstractPatternRequestFilter(String typeCode, String regex) {
        this(typeCode, regex, false);
    }

    public AbstractPatternRequestFilter(String typeCode, String regex, boolean exclude) {
        super(typeCode);
        this.pattern = StringUtils.isBlank((CharSequence)regex) ? null : RegExUtils.getPattern(regex, 0);
        this.isExclude = exclude;
    }

    protected abstract String getText(RequestData var1);

    @Override
    public Object appliesTo(RequestData requestData) {
        if (this.pattern == null) {
            return Boolean.TRUE;
        }
        Matcher matcher = this.pattern.matcher(this.getText(requestData));
        return matcher.find() ^ this.isExclude ? matcher : null;
    }

    @Override
    public String getReplacementText(RequestData requestData, int capturingGroupIndex, Object filterState) {
        if (this.isExclude || this.pattern == null || capturingGroupIndex == -1) {
            return this.getText(requestData);
        }
        try {
            return ((Matcher)filterState).group(capturingGroupIndex);
        }
        catch (IndexOutOfBoundsException ioobe) {
            String format = "No matching group %d for input string '%s' and pattern '%s'";
            ThrowableUtils.setMessage(ioobe, String.format("No matching group %d for input string '%s' and pattern '%s'", capturingGroupIndex, this.getText(requestData), this.getPattern()));
            throw ioobe;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{ type: '");
        sb.append(this.getTypeCode()).append("', ");
        sb.append("pattern: '").append(this.getPattern()).append("', ");
        sb.append("isExclude: ").append(this.isExclude).append(" }");
        return sb.toString();
    }

    public String getPattern() {
        return this.pattern == null ? "" : this.pattern.pattern();
    }

    public boolean isEmpty() {
        return this.pattern == null;
    }

    public boolean isExclude() {
        return this.isExclude;
    }
}

