/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.agent.JvmResourceUsageData;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.providers.AbstractDataProcessor;
import com.xceptance.xlt.report.providers.AgentReport;
import com.xceptance.xlt.report.providers.DoubleStatisticsReport;
import com.xceptance.xlt.report.util.ArithmeticMean;
import com.xceptance.xlt.report.util.DoubleMinMaxValueSet;
import com.xceptance.xlt.report.util.DoubleSummaryStatistics;
import com.xceptance.xlt.report.util.JFreeChartUtils;
import com.xceptance.xlt.report.util.MinMaxTimeSeriesCollection;
import com.xceptance.xlt.report.util.MinMaxValueSet;
import com.xceptance.xlt.report.util.ReportUtils;
import com.xceptance.xlt.report.util.TaskManager;
import java.io.File;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class AgentDataProcessor
extends AbstractDataProcessor {
    private final MinMaxValueSet blockedThreadsValueSet;
    private final DoubleMinMaxValueSet cpuUsageValueSet;
    private long fullGcCount;
    private final ArithmeticMean fullGcCpuUsageMean = new ArithmeticMean();
    private long fullGcTime;
    private final DoubleMinMaxValueSet gcCpuUsageValueSet;
    private long minorGcCount;
    private final ArithmeticMean minorGcCpuUsageMean = new ArithmeticMean();
    private long minorGcTime;
    private final MinMaxValueSet runnableThreadsValueSet;
    private final MinMaxValueSet totalHeapValueSet;
    private final MinMaxValueSet totalThreadsValueSet;
    private final MinMaxValueSet usedHeapValueSet;
    private final MinMaxValueSet waitingThreadsValueSet;
    private final MinMaxValueSet minorGcTimeValueSet;
    private final MinMaxValueSet fullGcTimeValueSet;
    private final DoubleMinMaxValueSet totalCpuUsageValueSet;
    private int transactions;
    private int transactionErrors;

    public AgentDataProcessor(String name, AbstractReportProvider provider) {
        super(name, provider);
        this.setChartDir(new File(this.getChartDir(), "agents"));
        this.setCsvDir(new File(this.getCsvDir(), "agents"));
        int minMaxValueSetSize = this.getChartWidth();
        this.cpuUsageValueSet = new DoubleMinMaxValueSet(minMaxValueSetSize);
        this.totalCpuUsageValueSet = new DoubleMinMaxValueSet(minMaxValueSetSize);
        this.gcCpuUsageValueSet = new DoubleMinMaxValueSet(minMaxValueSetSize);
        this.usedHeapValueSet = new MinMaxValueSet(minMaxValueSetSize);
        this.totalHeapValueSet = new MinMaxValueSet(minMaxValueSetSize);
        this.runnableThreadsValueSet = new MinMaxValueSet(minMaxValueSetSize);
        this.blockedThreadsValueSet = new MinMaxValueSet(minMaxValueSetSize);
        this.waitingThreadsValueSet = new MinMaxValueSet(minMaxValueSetSize);
        this.totalThreadsValueSet = new MinMaxValueSet(minMaxValueSetSize);
        this.minorGcTimeValueSet = new MinMaxValueSet(minMaxValueSetSize);
        this.fullGcTimeValueSet = new MinMaxValueSet(minMaxValueSetSize);
    }

    public AgentReport createAgentReport() {
        String name = this.getName();
        if (((ReportGeneratorConfiguration)this.getConfiguration()).agentChartsEnabled()) {
            File agentChartDir = new File(this.getChartDir(), name);
            agentChartDir.mkdirs();
            TaskManager taskManager = TaskManager.getInstance();
            taskManager.addTask(() -> this.createMemoryUsageChart(name, agentChartDir));
            taskManager.addTask(() -> this.createCpuUsageChart(name, agentChartDir));
            taskManager.addTask(() -> this.createThreadsChart(name, agentChartDir));
        }
        DoubleSummaryStatistics cpuUsageStats = ReportUtils.toSummaryStatistics(this.cpuUsageValueSet);
        DoubleSummaryStatistics totalCpuUsageStats = ReportUtils.toSummaryStatistics(this.totalCpuUsageValueSet);
        AgentReport agentReport = new AgentReport();
        agentReport.name = name;
        agentReport.minorGcCount = this.minorGcCount;
        agentReport.minorGcTime = this.minorGcTime;
        agentReport.minorGcCpuUsage = ReportUtils.convertToBigDecimal(this.minorGcCpuUsageMean.getMean());
        agentReport.fullGcCount = this.fullGcCount;
        agentReport.fullGcTime = this.fullGcTime;
        agentReport.fullGcCpuUsage = ReportUtils.convertToBigDecimal(this.fullGcCpuUsageMean.getMean());
        agentReport.cpuUsage = this.createStatisticsReport(cpuUsageStats);
        agentReport.totalCpuUsage = this.createStatisticsReport(totalCpuUsageStats);
        agentReport.transactions = this.transactions;
        agentReport.transactionErrors = this.transactionErrors;
        return agentReport;
    }

    private DoubleStatisticsReport createStatisticsReport(DoubleSummaryStatistics statistics) {
        DoubleStatisticsReport statisticsReport = new DoubleStatisticsReport();
        statisticsReport.mean = ReportUtils.convertToBigDecimal(statistics.getMean());
        statisticsReport.min = ReportUtils.convertToBigDecimal(statistics.getMinimum());
        statisticsReport.max = ReportUtils.convertToBigDecimal(statistics.getMaximum());
        statisticsReport.deviation = ReportUtils.convertToBigDecimal(statistics.getStandardDeviation());
        return statisticsReport;
    }

    @Override
    public void processDataRecord(Data stat) {
        JvmResourceUsageData usageStats = (JvmResourceUsageData)stat;
        long time = usageStats.getTime();
        this.totalHeapValueSet.addOrUpdateValue(time, (int)(usageStats.getTotalHeapSize() / 1024L / 1024L));
        this.usedHeapValueSet.addOrUpdateValue(time, (int)(usageStats.getUsedHeapSize() / 1024L / 1024L));
        double cpuUsage = usageStats.getCpuUsage();
        this.cpuUsageValueSet.addOrUpdateValue(time, cpuUsage);
        double totalCpuUsage = usageStats.getTotalCpuUsage();
        this.totalCpuUsageValueSet.addOrUpdateValue(time, totalCpuUsage);
        int runnable = usageStats.getRunnableThreadCount();
        int blocked = usageStats.getBlockedThreadCount();
        int waiting = usageStats.getWaitingThreadCount();
        int total = runnable + blocked + waiting;
        this.totalThreadsValueSet.addOrUpdateValue(time, total);
        this.waitingThreadsValueSet.addOrUpdateValue(time, waiting);
        this.blockedThreadsValueSet.addOrUpdateValue(time, blocked);
        this.runnableThreadsValueSet.addOrUpdateValue(time, runnable);
        double minorGcCpuUsage = usageStats.getMinorGcCpuUsage();
        double fullGcCpuUsage = usageStats.getFullGcCpuUsage();
        this.gcCpuUsageValueSet.addOrUpdateValue(time, minorGcCpuUsage + fullGcCpuUsage);
        this.minorGcCpuUsageMean.addValue(minorGcCpuUsage);
        this.fullGcCpuUsageMean.addValue(fullGcCpuUsage);
        this.minorGcTimeValueSet.addOrUpdateValue(time, (int)Math.round((double)usageStats.getMinorGcTimeDiff() / Math.max(1.0, (double)usageStats.getMinorGcCountDiff())));
        this.fullGcTimeValueSet.addOrUpdateValue(time, (int)Math.round((double)usageStats.getFullGcTimeDiff() / Math.max(1.0, (double)usageStats.getFullGcCountDiff())));
        this.minorGcCount = Math.max(this.minorGcCount, usageStats.getMinorGcCount());
        this.minorGcTime = Math.max(this.minorGcTime, usageStats.getMinorGcTime());
        this.fullGcCount = Math.max(this.fullGcCount, usageStats.getFullGcCount());
        this.fullGcTime = Math.max(this.fullGcTime, usageStats.getFullGcTime());
    }

    void incrementTransactionCounters(boolean failed) {
        ++this.transactions;
        if (failed) {
            ++this.transactionErrors;
        }
    }

    protected void createCpuUsageChart(String agentName, File outputDir) {
        TimeSeriesCollection cpuTimeSeriesCollection = new TimeSeriesCollection();
        TimeSeries cpuTimeSeries = JFreeChartUtils.toMinMaxTimeSeries(this.cpuUsageValueSet, "Agent CPU Usage");
        TimeSeries avgCpuTimeSeries = JFreeChartUtils.createMovingAverageTimeSeries(cpuTimeSeries, this.getMovingAveragePercentage());
        TimeSeries gcCpuTimeSeries = JFreeChartUtils.toMinMaxTimeSeries(this.gcCpuUsageValueSet, "Agent GC CPU Usage");
        TimeSeries totalCpuUsageTimeSeries = JFreeChartUtils.toMinMaxTimeSeries(this.totalCpuUsageValueSet, "Total CPU Usage");
        cpuTimeSeriesCollection.addSeries(avgCpuTimeSeries);
        cpuTimeSeriesCollection.addSeries(cpuTimeSeries);
        cpuTimeSeriesCollection.addSeries(gcCpuTimeSeries);
        cpuTimeSeriesCollection.addSeries(totalCpuUsageTimeSeries);
        JFreeChart chart = JFreeChartUtils.createLineChart(agentName + " -- CPU Usage", "CPU Usage [%]", cpuTimeSeriesCollection, this.getStartTime(), this.getEndTime());
        JFreeChartUtils.saveChart(chart, "CpuUsage", outputDir, this.getChartWidth(), this.getChartHeight());
    }

    protected void createMemoryUsageChart(String name, File outputDir) {
        MinMaxTimeSeriesCollection memoryCollection = new MinMaxTimeSeriesCollection();
        TimeSeries usedHeapSeries = JFreeChartUtils.toMinMaxTimeSeries(this.usedHeapValueSet, "Used Heap");
        TimeSeries totalHeapSeries = JFreeChartUtils.toMinMaxTimeSeries(this.totalHeapValueSet, "Total Heap");
        TimeSeries usedHeapAvgSeries = JFreeChartUtils.createMovingAverageTimeSeries(usedHeapSeries, this.getMovingAveragePercentage());
        memoryCollection.addSeries(usedHeapAvgSeries);
        memoryCollection.addSeries(usedHeapSeries);
        memoryCollection.addSeries(totalHeapSeries);
        TimeSeriesCollection fullGcCollection = new TimeSeriesCollection();
        fullGcCollection.addSeries(JFreeChartUtils.toMinMaxTimeSeries(this.fullGcTimeValueSet, "Full GC time"));
        TimeSeriesCollection minorGcCollection = new TimeSeriesCollection();
        minorGcCollection.addSeries(JFreeChartUtils.toMinMaxTimeSeries(this.minorGcTimeValueSet, "Minor GC time"));
        JFreeChart chart = JFreeChartUtils.createCombinedPlotChart(name + " -- Memory Usage and Garbage Collection Time", this.getStartTime(), this.getEndTime());
        JFreeChartUtils.addLinePlotToCombinedPlotChart(chart, "Memory Usage [MB]", (XYDataset)memoryCollection);
        JFreeChartUtils.addLinePlotToCombinedPlotChart(chart, "Full GC Time [ms]", (XYDataset)fullGcCollection);
        JFreeChartUtils.addLinePlotToCombinedPlotChart(chart, "Minor GC Time [ms]", (XYDataset)minorGcCollection);
        JFreeChartUtils.saveChart(chart, "MemoryUsage", outputDir, this.getChartWidth(), (int)((double)this.getChartHeight() * 2.3));
    }

    protected void createThreadsChart(String name, File outputDir) {
        TimeSeries totalThreadsTimeSeries = JFreeChartUtils.toMinMaxTimeSeries(this.totalThreadsValueSet, "Total Threads");
        TimeSeries runnableThreadsTimeSeries = JFreeChartUtils.toMinMaxTimeSeries(this.runnableThreadsValueSet, "Runnable Threads");
        TimeSeries blockedThreadsTimeSeries = JFreeChartUtils.toMinMaxTimeSeries(this.blockedThreadsValueSet, "Blocked Threads");
        TimeSeries waitingThreadsTimeSeries = JFreeChartUtils.toMinMaxTimeSeries(this.waitingThreadsValueSet, "Waiting Threads");
        MinMaxTimeSeriesCollection collection = new MinMaxTimeSeriesCollection();
        collection.addSeries(totalThreadsTimeSeries);
        collection.addSeries(runnableThreadsTimeSeries);
        collection.addSeries(blockedThreadsTimeSeries);
        collection.addSeries(waitingThreadsTimeSeries);
        JFreeChart chart = JFreeChartUtils.createLineChart(name + " -- Threads", "Threads", collection, this.getStartTime(), this.getEndTime());
        JFreeChartUtils.saveChart(chart, "Threads", outputDir, this.getChartWidth(), this.getChartHeight());
    }
}

