/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.report.providers.HostReport;
import com.xceptance.xlt.report.providers.HostsReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HostsReportProvider
extends AbstractReportProvider {
    private static final String UNKNOWN_HOST = "(unknown)";
    private final Map<String, HostReport> hostReports = new HashMap<String, HostReport>();

    @Override
    public Object createReportFragment() {
        HostsReport report = new HostsReport();
        report.hosts = new ArrayList<HostReport>(this.hostReports.values());
        return report;
    }

    @Override
    public void processDataRecord(Data data) {
        if (data instanceof RequestData) {
            RequestData reqData = (RequestData)data;
            String url = reqData.getUrl();
            String hostName = StringUtils.isBlank((CharSequence)url) ? UNKNOWN_HOST : this.extractHostNameFromUrl(url);
            HostReport hostReport = this.hostReports.get(hostName);
            if (hostReport == null) {
                hostReport = new HostReport();
                hostReport.name = hostName;
                this.hostReports.put(hostName, hostReport);
            }
            ++hostReport.count;
        }
    }

    private String extractHostNameFromUrl(String url) {
        int endIndex;
        String tmp = url;
        int startIndex = tmp.indexOf("://");
        if (startIndex != -1) {
            tmp = StringUtils.substring((String)tmp, (int)(startIndex + 3));
        }
        if ((endIndex = StringUtils.indexOfAny((CharSequence)tmp, (String)"/?#")) != -1) {
            tmp = StringUtils.substring((String)tmp, (int)0, (int)endIndex);
        }
        return tmp;
    }
}

