/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.providers.AbstractDataProcessor;
import com.xceptance.xlt.report.providers.BasicTimerDataProcessor;
import com.xceptance.xlt.report.providers.ExtendedStatisticsReport;
import com.xceptance.xlt.report.providers.RequestReport;
import com.xceptance.xlt.report.providers.StatisticsReport;
import com.xceptance.xlt.report.providers.TimerReport;
import com.xceptance.xlt.report.providers.UrlData;
import com.xceptance.xlt.report.util.HistogramValueSet;
import com.xceptance.xlt.report.util.JFreeChartUtils;
import com.xceptance.xlt.report.util.MinMaxValueSet;
import com.xceptance.xlt.report.util.ReportUtils;
import com.xceptance.xlt.report.util.SegmentationValueSet;
import com.xceptance.xlt.report.util.SummaryStatistics;
import com.xceptance.xlt.report.util.TaskManager;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYPointerAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.Layer;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;

public class RequestDataProcessor
extends BasicTimerDataProcessor {
    private static final int MAXIMUM_NUMBER_OF_URLS = 10;
    private final MinMaxValueSet responseSizeValueSet;
    private final TIntSet distinctUrlHashCodeSet = new TIntHashSet();
    private final Set<String> distinctUrlSet = new HashSet<String>(10);
    private final int[] boundaries;
    private final SegmentationValueSet countPerSegment;
    private final HistogramValueSet runTimeHistogramValueSet;
    private final SummaryStatistics bytesSentStatistics = new SummaryStatistics();
    private final SummaryStatistics bytesReceivedStatistics = new SummaryStatistics();
    private final SummaryStatistics connectTimeStatistics = new SummaryStatistics();
    private final SummaryStatistics sendTimeStatistics = new SummaryStatistics();
    private final SummaryStatistics serverBusyTimeStatistics = new SummaryStatistics();
    private final SummaryStatistics receiveTimeStatistics = new SummaryStatistics();
    private final SummaryStatistics timeToFirstBytesStatistics = new SummaryStatistics();
    private final SummaryStatistics timeToLastBytesStatistics = new SummaryStatistics();
    private final SummaryStatistics dnsTimeStatistics = new SummaryStatistics();
    private final boolean countDistinctUrls;

    public <T extends AbstractDataProcessor> RequestDataProcessor(String name, AbstractReportProvider provider) {
        this(name, provider, true);
    }

    public <T extends AbstractDataProcessor> RequestDataProcessor(String name, AbstractReportProvider provider, boolean countDistinctUrls) {
        super(name, provider);
        this.countDistinctUrls = countDistinctUrls;
        this.setChartDir(new File(this.getChartDir(), "requests"));
        this.setCsvDir(new File(this.getCsvDir(), "requests"));
        ReportGeneratorConfiguration config = (ReportGeneratorConfiguration)this.getConfiguration();
        this.boundaries = config.getRuntimeIntervalBoundaries();
        if (this.boundaries.length > 0) {
            int numberOfBins = 101;
            double maxValue = (double)this.boundaries[this.boundaries.length - 1] * 101.0 / 100.0;
            this.runTimeHistogramValueSet = new HistogramValueSet(0.0, maxValue, 101);
            this.countPerSegment = new SegmentationValueSet(this.boundaries);
        } else {
            this.runTimeHistogramValueSet = null;
            this.countPerSegment = null;
        }
        int minMaxValueSetSize = this.getChartWidth();
        this.responseSizeValueSet = new MinMaxValueSet(minMaxValueSetSize);
        this.setChartCappingInfo(config.getRequestChartCappingInfo());
    }

    @Override
    public TimerReport createTimerReport(boolean generateHistograms) {
        if (this.getConfiguration().shouldChartsGenerated()) {
            TaskManager taskManager = TaskManager.getInstance();
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    TimeSeries responseSizeTimeSeries = JFreeChartUtils.toMinMaxTimeSeries(RequestDataProcessor.this.responseSizeValueSet, "Response Size");
                    RequestDataProcessor.this.createResponseSizeChart(RequestDataProcessor.this.getName(), responseSizeTimeSeries);
                }
            });
            taskManager.addTask(new Runnable(){

                @Override
                public void run() {
                    String seriesName = "Number of Requests";
                    XYIntervalSeries histogramSeries = RequestDataProcessor.this.runTimeHistogramValueSet != null ? RequestDataProcessor.this.runTimeHistogramValueSet.toSeries("Number of Requests") : RequestDataProcessor.this.getHistogramValueSet().toVerticalSeries("Number of Requests");
                    RequestDataProcessor.this.saveResponseTimeHistogramChart(RequestDataProcessor.this.getName(), histogramSeries, RequestDataProcessor.this.boundaries);
                }
            });
        }
        RequestReport timerReport = (RequestReport)super.createTimerReport(generateHistograms);
        timerReport.urls = this.getUrlList(this.distinctUrlSet, this.distinctUrlHashCodeSet.size());
        timerReport.countPerInterval = this.countPerSegment != null ? this.countPerSegment.getCountPerSegment() : ArrayUtils.EMPTY_INT_ARRAY;
        long duration = Math.max((this.getConfiguration().getChartEndTime() - this.getConfiguration().getChartStartTime()) / 1000L, 1L);
        timerReport.bytesSent = this.createExtendedStatisticsReport(this.bytesSentStatistics, duration);
        timerReport.bytesReceived = this.createExtendedStatisticsReport(this.bytesReceivedStatistics, duration);
        timerReport.dnsTime = this.createStatisticsReport(this.dnsTimeStatistics);
        timerReport.connectTime = this.createStatisticsReport(this.connectTimeStatistics);
        timerReport.sendTime = this.createStatisticsReport(this.sendTimeStatistics);
        timerReport.serverBusyTime = this.createStatisticsReport(this.serverBusyTimeStatistics);
        timerReport.receiveTime = this.createStatisticsReport(this.receiveTimeStatistics);
        timerReport.timeToFirstBytes = this.createStatisticsReport(this.timeToFirstBytesStatistics);
        timerReport.timeToLastBytes = this.createStatisticsReport(this.timeToLastBytesStatistics);
        return timerReport;
    }

    @Override
    public void processDataRecord(Data data) {
        super.processDataRecord(data);
        RequestData reqData = (RequestData)data;
        int runTime = (int)reqData.getRunTime();
        if (this.runTimeHistogramValueSet != null) {
            this.runTimeHistogramValueSet.addValue(runTime);
            this.countPerSegment.addValue(runTime);
        }
        this.responseSizeValueSet.addOrUpdateValue(reqData.getEndTime(), reqData.getBytesReceived());
        if (this.countDistinctUrls) {
            String url = reqData.getUrl();
            int pos = url.indexOf(35);
            if (pos > 0) {
                url = url.substring(0, pos);
            }
            this.distinctUrlHashCodeSet.add(url.hashCode());
            if (this.distinctUrlSet.size() < 10) {
                this.distinctUrlSet.add(url);
            }
        }
        this.bytesSentStatistics.addValue(reqData.getBytesSent());
        this.bytesReceivedStatistics.addValue(reqData.getBytesReceived());
        this.dnsTimeStatistics.addValue(reqData.getDnsTime());
        this.connectTimeStatistics.addValue(reqData.getConnectTime());
        this.sendTimeStatistics.addValue(reqData.getSendTime());
        this.serverBusyTimeStatistics.addValue(reqData.getServerBusyTime());
        this.receiveTimeStatistics.addValue(reqData.getReceiveTime());
        this.timeToFirstBytesStatistics.addValue(reqData.getTimeToFirstBytes());
        this.timeToLastBytesStatistics.addValue(reqData.getTimeToLastBytes());
    }

    protected void createResponseSizeChart(String timerName, TimeSeries timeSeries) {
        JFreeChart chart = JFreeChartUtils.createLineChart(timerName, "Bytes", timeSeries, this.getStartTime(), this.getEndTime(), true, this.getMovingAveragePercentage());
        JFreeChartUtils.saveChart(chart, timerName + "_ResponseSize", this.getChartDir(), this.getChartWidth(), this.getChartHeight());
    }

    protected JFreeChart createHistogramChart(String chartTitle, XYIntervalSeries histogramSeries, int[] runtimeSegmentBoundaries) {
        XYIntervalSeriesCollection dataset = new XYIntervalSeriesCollection();
        dataset.addSeries(histogramSeries);
        double domainAxisUpperBound = histogramSeries.getXHighValue(histogramSeries.getItemCount() - 1);
        NumberAxis xAxis = new NumberAxis("Runtime [ms]");
        xAxis.setRange(0.0, domainAxisUpperBound);
        XYPlot plot = JFreeChartUtils.createBarPlot((XYDataset)dataset, (ValueAxis)xAxis, "Count", JFreeChartUtils.COLOR_HISTOGRAM);
        plot.setOrientation(PlotOrientation.VERTICAL);
        if (this.boundaries.length > 0) {
            for (int boundary : runtimeSegmentBoundaries) {
                ValueMarker marker = new ValueMarker((double)boundary);
                marker.setPaint((Paint)Color.GRAY);
                plot.addDomainMarker((Marker)marker, Layer.BACKGROUND);
            }
            int maxValue = runtimeSegmentBoundaries[runtimeSegmentBoundaries.length - 1];
            String annotationText = String.format("All requests > %,d ms", maxValue);
            double binWidth = domainAxisUpperBound / (double)histogramSeries.getItemCount();
            double x = domainAxisUpperBound - binWidth / 2.0;
            double y = plot.getRangeAxis().getUpperBound() * 0.75;
            XYPointerAnnotation annotation = new XYPointerAnnotation(annotationText, x, y, 3.92);
            annotation.setTextAnchor(TextAnchor.BOTTOM_RIGHT);
            annotation.setPaint((Paint)Color.GRAY);
            annotation.setArrowPaint((Paint)Color.GRAY);
            annotation.setArrowLength(0.0);
            annotation.setTipRadius(0.0);
            plot.addAnnotation((XYAnnotation)annotation);
        }
        JFreeChart chart = JFreeChartUtils.createChart(chartTitle, (Plot)plot);
        return chart;
    }

    protected void saveResponseTimeHistogramChart(String timerName, XYIntervalSeries histogramSeries, int[] boundaries) {
        JFreeChart chart = this.createHistogramChart(timerName, histogramSeries, boundaries);
        JFreeChartUtils.saveChart(chart, timerName + "_Histogram", this.getChartDir(), this.getChartWidth(), this.getChartHeight());
    }

    @Override
    protected TimerReport createTimerReport() {
        return new RequestReport();
    }

    private UrlData getUrlList(Set<String> urls, int totalUrlCount) {
        UrlData urlData = new UrlData();
        urlData.total = totalUrlCount;
        urlData.list = new ArrayList<String>(urls);
        Collections.sort(urlData.list);
        return urlData;
    }

    private ExtendedStatisticsReport createExtendedStatisticsReport(SummaryStatistics statistics, long duration) {
        ExtendedStatisticsReport statisticsReport = new ExtendedStatisticsReport();
        statisticsReport.mean = ReportUtils.convertToBigDecimal(statistics.getMean());
        statisticsReport.min = statistics.getMinimum();
        statisticsReport.max = statistics.getMaximum();
        statisticsReport.deviation = ReportUtils.convertToBigDecimal(statistics.getStandardDeviation());
        double sum = statistics.getSum();
        statisticsReport.totalCount = BigInteger.valueOf((long)sum);
        statisticsReport.countPerSecond = ReportUtils.convertToBigDecimal(sum / (double)duration);
        statisticsReport.countPerMinute = ReportUtils.convertToBigDecimal(sum * 60.0 / (double)duration);
        statisticsReport.countPerHour = ReportUtils.convertToBigDecimal(sum * 3600.0 / (double)duration);
        statisticsReport.countPerDay = ReportUtils.convertToBigDecimal(sum * 86400.0 / (double)duration);
        return statisticsReport;
    }

    private StatisticsReport createStatisticsReport(SummaryStatistics statistics) {
        StatisticsReport statisticsReport = new StatisticsReport();
        statisticsReport.mean = ReportUtils.convertToBigDecimal(statistics.getMean());
        statisticsReport.min = statistics.getMinimum();
        statisticsReport.max = statistics.getMaximum();
        statisticsReport.deviation = ReportUtils.convertToBigDecimal(statistics.getStandardDeviation());
        return statisticsReport;
    }
}

