/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import org.jfree.data.xy.XYIntervalSeries;

public class HistogramValueSet {
    private final int[] countPerBin;
    private final double maxValue;
    private final double minValue;
    private final int numberOfBins;
    private final double binWidth;

    public HistogramValueSet(double minValue, double maxValue, int numberOfBins) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.numberOfBins = numberOfBins;
        this.countPerBin = new int[numberOfBins];
        this.binWidth = (maxValue - minValue) / (double)numberOfBins;
    }

    public void addValue(double value) {
        int binIndex = value <= this.binWidth ? 0 : (value > this.maxValue ? this.numberOfBins - 1 : (int)Math.ceil(value / this.binWidth) - 1);
        int n = binIndex;
        this.countPerBin[n] = this.countPerBin[n] + 1;
    }

    public double getBinWidth() {
        return this.binWidth;
    }

    public int[] getCountPerBin() {
        return this.countPerBin;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public int getNumberOfBins() {
        return this.numberOfBins;
    }

    public XYIntervalSeries toSeries(String seriesName) {
        XYIntervalSeries series = new XYIntervalSeries((Comparable)((Object)seriesName));
        double xHigh = this.minValue;
        for (int i = 0; i < this.countPerBin.length; ++i) {
            double xLow = xHigh;
            xHigh = xLow + this.binWidth;
            double y = this.countPerBin[i];
            series.add(xLow, xLow, xHigh, y, 0.0, y);
        }
        return series;
    }
}

