/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.util;

import com.xceptance.common.lang.StringUtils;
import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.common.util.ProductInformation;
import com.xceptance.common.util.PropertiesUtils;
import com.xceptance.xlt.api.engine.GlobalClock;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.api.util.XltRandom;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.XltEngine;
import com.xceptance.xlt.engine.XltExecutionContext;
import com.xceptance.xlt.engine.util.IncludedFilesResolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;

public class XltPropertiesImpl
extends XltProperties {
    private final Properties properties;
    private long startTime = -1L;
    private String version;
    private final List<String> resolvedPropertyFiles = new ArrayList<String>();
    private static volatile XltPropertiesImpl _instance;
    private static final ThreadLocal<ThreadLocal<?>> Gate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XltPropertiesImpl getInstance(boolean ignoreMissingIncludes) {
        if (_instance != null) return _instance;
        Class<XltPropertiesImpl> clazz = XltPropertiesImpl.class;
        synchronized (XltPropertiesImpl.class) {
            if (_instance != null) return _instance;
            _instance = XltPropertiesImpl._createInstance(ignoreMissingIncludes);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _instance;
        }
    }

    private static XltPropertiesImpl _createInstance(boolean ignoreMissingInclude) {
        if (Gate.get() != null) {
            return null;
        }
        try {
            Gate.set(Gate);
            XltPropertiesImpl xltPropertiesImpl = new XltPropertiesImpl(null, null, ignoreMissingInclude);
            return xltPropertiesImpl;
        }
        finally {
            Gate.set(null);
        }
    }

    public static XltPropertiesImpl getInstance() {
        return XltPropertiesImpl.getInstance(false);
    }

    public static synchronized void reset() {
        XltPropertiesImpl.getInstance().initialize(null, null, false);
    }

    public XltPropertiesImpl(FileObject homeDirectory, FileObject configDirectory, boolean ignoreMissing) {
        this.properties = new VarSubstitutionSupportedProperties();
        this.initialize(homeDirectory, configDirectory, ignoreMissing);
    }

    @Override
    public boolean containsKey(String key) {
        return this.properties.containsKey("secret." + key) || this.properties.containsKey(key);
    }

    @Override
    public final Properties getProperties() {
        Properties copy = new Properties();
        for (Object k : this.properties.keySet()) {
            String key = (String)k;
            copy.setProperty(key, this.properties.getProperty(key));
        }
        return copy;
    }

    @Override
    public Map<String, String> getPropertiesForKey(String domainKey) {
        return PropertiesUtils.getPropertiesForKey(domainKey, this.properties);
    }

    private String getEffectiveKey(String bareKey) {
        String secretKey;
        String nonPrefixedKey = bareKey.startsWith("secret.") ? bareKey.substring("secret.".length()) : bareKey;
        SessionImpl session = SessionImpl.getCurrent();
        if (session != null) {
            String userNameQualifiedSecretKey = "secret." + session.getUserName() + "." + nonPrefixedKey;
            if (this.properties.containsKey(userNameQualifiedSecretKey)) {
                return userNameQualifiedSecretKey;
            }
            String userNameQualifiedKey = session.getUserName() + "." + bareKey;
            if (this.properties.containsKey(userNameQualifiedKey)) {
                return userNameQualifiedKey;
            }
            String classNameQualifiedSecretKey = "secret." + session.getTestCaseClassName() + "." + nonPrefixedKey;
            if (this.properties.containsKey(classNameQualifiedSecretKey)) {
                return classNameQualifiedSecretKey;
            }
            String classNameQualifiedKey = session.getTestCaseClassName() + "." + bareKey;
            if (this.properties.containsKey(classNameQualifiedKey)) {
                return classNameQualifiedKey;
            }
        }
        if (this.properties.containsKey(secretKey = "secret." + nonPrefixedKey)) {
            return secretKey;
        }
        return bareKey;
    }

    @Override
    public String getProperty(String key) {
        String effectiveKey = this.getEffectiveKey(key);
        return this.properties.getProperty(effectiveKey);
    }

    @Override
    public boolean getProperty(String key, boolean defaultValue) {
        String valueString = this.getProperty(key);
        if (valueString != null) {
            return Boolean.valueOf(valueString);
        }
        return defaultValue;
    }

    @Override
    public int getProperty(String key, int defaultValue) {
        String valueString = this.getProperty(key);
        if (valueString != null) {
            try {
                return Integer.parseInt(valueString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public long getProperty(String key, long defaultValue) {
        String valueString = this.getProperty(key);
        if (valueString != null) {
            try {
                return Long.parseLong(valueString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public String getPropertyRandomValue(String key, String defaultValue) {
        String value = this.getProperty(key, defaultValue);
        if (value == null) {
            return "";
        }
        String[] values = StringUtils.split(value, "[ ,;]");
        return values[XltRandom.nextInt(values.length)];
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void removeProperty(String key) {
        ParameterCheckUtils.isNotNull(key, "key");
        this.properties.remove(key);
    }

    @Override
    public void setProperties(File file) throws IOException {
        ParameterCheckUtils.isNotNull(file, "file");
        this.setProperties(VFS.getManager().resolveFile(file.getAbsolutePath()));
    }

    @Override
    public void setProperties(FileObject file) throws IOException {
        ParameterCheckUtils.isNotNull(file, "file");
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info("Loading properties from file: " + file.getName().getURI());
        }
        Properties properties = PropertiesUtils.loadProperties(file);
        this.setProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(Properties newProperties) {
        ParameterCheckUtils.isNotNull(newProperties, "newProperties");
        Properties properties = newProperties;
        synchronized (properties) {
            this.properties.putAll((Map<?, ?>)newProperties);
        }
    }

    @Override
    public void setProperty(String key, String value) {
        ParameterCheckUtils.isNotNull(key, "key");
        ParameterCheckUtils.isNotNull(value, "value");
        this.properties.setProperty(key, value);
    }

    @Override
    public void update() {
        this.update(null, null, false);
    }

    public void update(FileObject homeDirectory, FileObject configDirectory, boolean ignoreMissing) {
        this.properties.clear();
        this.loadProperties(homeDirectory, configDirectory, ignoreMissing);
    }

    private void initialize(FileObject homeDirectory, FileObject configDirectory, boolean ignoreMissing) {
        this.update(homeDirectory, configDirectory, ignoreMissing);
        this.version = ProductInformation.getProductInformation().getVersion();
        this.startTime = GlobalClock.getInstance().getTime();
    }

    private void loadProperties(FileObject homeDirectory, FileObject configDirectory, boolean ignoreMissing) {
        if (homeDirectory == null) {
            homeDirectory = XltExecutionContext.getCurrent().getTestSuiteHomeDir();
        }
        if (configDirectory == null) {
            configDirectory = XltExecutionContext.getCurrent().getTestSuiteConfigDir();
        }
        List<FileObject> roots = this.getRoots(configDirectory);
        ArrayList<String> files = new ArrayList<String>();
        for (String file : IncludedFilesResolver.resolveIncludePropertyFiles(roots, homeDirectory, ignoreMissing)) {
            files.add(XltPropertiesImpl.makeRelativeTo(file, configDirectory));
        }
        this.loadPropertyFiles(files, 0, configDirectory);
        int alreadyLoadedFiles = files.size();
        files.clear();
        roots.addAll(this.getAdditionalRoots(configDirectory));
        for (String file : IncludedFilesResolver.resolveIncludePropertyFiles(roots, homeDirectory, ignoreMissing)) {
            String path = XltPropertiesImpl.makeRelativeTo(file, configDirectory);
            this.resolvedPropertyFiles.add(path);
            files.add(path);
        }
        this.loadPropertyFiles(files, alreadyLoadedFiles, configDirectory);
        this.loadSecretProperties(configDirectory);
        this.setProperties(System.getProperties());
        this.logProperties();
    }

    private void loadSecretProperties(FileObject configDirectory) {
        try {
            FileObject secretFile = configDirectory.resolveFile("secret.properties");
            if (secretFile.isReadable()) {
                Properties props = PropertiesUtils.loadProperties(secretFile);
                this.resolvedPropertyFiles.add(secretFile.getName().getBaseName());
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (name.startsWith("secret.")) {
                        this.properties.setProperty(name, value);
                        continue;
                    }
                    this.properties.setProperty("secret." + name, value);
                }
            }
        }
        catch (FileNotFoundException _e) {
            XltLogger.runTimeLogger.trace("Could not load secret properties. File does not exist.");
        }
        catch (IOException e) {
            XltLogger.runTimeLogger.error("Could not load secret properties.", (Throwable)e);
        }
    }

    private void loadPropertyFiles(List<String> files, int alreadyLoadedFiles, FileObject configDirectory) {
        for (int i = alreadyLoadedFiles; i < files.size(); ++i) {
            this.loadPropertiesFile(files.get(i), false, configDirectory);
        }
    }

    private List<FileObject> getRoots(FileObject configDir) {
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        this.addFile(configDir, "default.properties", true, roots);
        this.addFile(configDir, "project.properties", true, roots);
        return roots;
    }

    private List<FileObject> getAdditionalRoots(FileObject configDir) {
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        String testPropertiesFile = this.properties.getProperty("com.xceptance.xlt.testPropertiesFile");
        this.addFile(configDir, testPropertiesFile, false, roots);
        boolean isDevMode = XltEngine.getInstance().isDevMode();
        if (isDevMode) {
            this.addFile(configDir, "dev.properties", true, roots);
        }
        return roots;
    }

    private void addFile(FileObject configDir, String fileName, boolean logNotExistingFile, List<FileObject> files) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fileName)) {
            boolean exists = false;
            try {
                FileObject child = configDir.resolveFile(fileName);
                exists = child.exists();
                if (exists) {
                    files.add(child);
                }
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
            if (!exists && logNotExistingFile && XltLogger.runTimeLogger.isInfoEnabled()) {
                XltLogger.runTimeLogger.info("No such property file: " + configDir.getName().getPath() + "/" + fileName);
            }
        }
    }

    private void loadPropertiesFile(String fileName, boolean ignoreMissingFile, FileObject configDir) {
        if (fileName == null || fileName.length() == 0) {
            return;
        }
        try {
            if (configDir == null) {
                throw new IOException("Unable to access configuration directory");
            }
            FileObject file = configDir.resolveFile(fileName);
            if (XltLogger.runTimeLogger.isInfoEnabled()) {
                XltLogger.runTimeLogger.info("Trying to load property file '" + file.getName().getURI() + "'.");
            }
            if (!ignoreMissingFile || file.exists() && file.getType() == FileType.FILE) {
                this.setProperties(file);
            }
        }
        catch (IOException e) {
            XltLogger.runTimeLogger.error("Failed to load properties file: " + fileName, (Throwable)e);
        }
    }

    private void logProperties() {
        if (XltLogger.runTimeLogger.isDebugEnabled()) {
            XltLogger.runTimeLogger.debug("----------------------------------------------------------------");
            TreeMap<Object, Object> sortedProperties = new TreeMap<Object, Object>(this.properties);
            for (Map.Entry entry : sortedProperties.entrySet()) {
                String maskedValue = ((String)entry.getKey()).startsWith("secret.") ? "******" : (String)entry.getValue();
                XltLogger.runTimeLogger.debug("| " + entry.getKey() + " = " + maskedValue);
            }
            XltLogger.runTimeLogger.debug("----------------------------------------------------------------");
        }
    }

    @Override
    public List<String> getResolvedPropertyFiles() {
        return this.resolvedPropertyFiles;
    }

    private static String makeRelativeTo(String path, FileObject target) {
        try {
            int depthPivot;
            int depthResolved;
            FileObject fo = target.resolveFile(path);
            ArrayList<String> pathSegments = new ArrayList<String>();
            FileObject tmp = target;
            FileObject tmp2 = fo;
            if (depthResolved < depthPivot) {
                for (depthPivot = target.getName().getDepth() + 1; depthResolved < depthPivot; --depthPivot) {
                    tmp = tmp.getParent();
                    pathSegments.add("..");
                }
            } else if (depthResolved > depthPivot) {
                for (depthResolved = fo.getName().getDepth(); depthResolved > depthPivot; --depthResolved) {
                    tmp2 = tmp2.getParent();
                    pathSegments.add(0, tmp2.getName().getBaseName());
                }
            }
            if (!tmp2.getParent().equals(tmp)) {
                throw new IllegalArgumentException(String.format("Paths '%s' and '%s' do not have a common ancestor.", fo.getName().getPath(), target.getName().getPath()));
            }
            pathSegments.add(fo.getName().getBaseName());
            return org.apache.commons.lang3.StringUtils.join(pathSegments, (char)'/').toString();
        }
        catch (Exception e) {
            XltLogger.runTimeLogger.warn(e.getMessage());
            return path;
        }
    }

    static {
        Gate = new ThreadLocal();
    }

    private static class VarSubstitutionSupportedProperties
    extends Properties {
        private static final long serialVersionUID = -9202819207114231133L;

        private VarSubstitutionSupportedProperties() {
        }

        @Override
        public String getProperty(String key) {
            String val = super.getProperty(key);
            if (val == null || val.length() == 0) {
                return val;
            }
            return PropertiesUtils.substituteVariables(val, this);
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            if (null == key || null == value) {
                return null;
            }
            return super.put(key, ((String)value).trim());
        }

        @Override
        public synchronized void putAll(Map<? extends Object, ? extends Object> map) {
            for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

