/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util.concurrent;

import com.xceptance.common.util.Getter;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
    private final String threadNamePrefix;
    private final AtomicInteger count = new AtomicInteger();
    private final Getter<String> prefixGetter;

    public DaemonThreadFactory() {
        this((String)null);
    }

    public DaemonThreadFactory(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
        this.prefixGetter = null;
    }

    public DaemonThreadFactory(Getter<String> getter) {
        this.threadNamePrefix = null;
        this.prefixGetter = getter;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = this.defaultThreadFactory.newThread(runnable);
        thread.setDaemon(true);
        String name = this.threadNamePrefix == null ? (this.prefixGetter != null ? this.prefixGetter.get() : "") : this.threadNamePrefix;
        thread.setName(name + this.count.getAndIncrement());
        return thread;
    }
}

